/*
                            Endeavour Pixmap
 */

#ifndef EDV_PIXMAP_H
#define EDV_PIXMAP_H

#include <gtk/gtk.h>


typedef struct _edv_pixmap		edv_pixmap;
#define EDV_PIXMAP(p)	((edv_pixmap *)(p))


/*
 *	Pixmap:
 */
struct _edv_pixmap {

	GdkPixmap	*pixmap;
	GdkBitmap	*mask;
	gint		width,
			height;
	guint8		**data;		/* XPM data used to create
					 * pixmap (shared) */
	gchar		*name;		/* C Decl ID (taken from data) */
};


extern GList *EDVPixmapListNew(
        GList *pixmaps_list,
        guint8 **data, const gchar *name,
        edv_pixmap **p_rtn   
);
extern GList *EDVPixmapListClean(GList *pixmaps_list);

extern edv_pixmap *EDVPixmapListMatchByName(
	GList *pixmaps_list, const gchar *name
);

extern edv_pixmap *EDVPixmapNew(guint8 **data, const gchar *name);
extern void EDVPixmapDelete(edv_pixmap *p);


#endif	/* EDV_PIXMAP_H */
