#include <stdio.h>
#include <string.h>

#include <libbonobo.h>

#include "Evolution-DataServer-Mail.h"
#include "e-mail-remote-glue-utils.h"
#include "e-mail-remote-glue-msgstream.h"

static void e_mail_remote_glue_msgstream_class_init (EMailRemoteGlueMsgStreamClass *klass);
static void e_mail_remote_glue_msgstream_init (EMailRemoteGlueMsgStream *comp, EMailRemoteGlueMsgStreamClass *klass);
static void e_mail_remote_glue_msgstream_finalize (GObject *object);

/*static guint e_mail_remote_signals[LAST_SIGNAL] = { 0 };*/

static GObjectClass *parent_class;

struct _EMailRemoteGlueMsgStreamPrivate {
  Bonobo_Unknown stream; /* Evolution_Mail_MessageStream */
};

/**
 * e_mail_remote_glue_msgstream_get_type:
 *
 * Registers the #EMailRemoteGlueMsgStream class if necessary, and returns the type ID
 * associated to it.
 *
 * Return value: The type ID of the #EMailRemoteGlueMsgStream class.
 **/
GType
e_mail_remote_glue_msgstream_get_type (void)
{
  static GType e_mail_remote_glue_msgstream_type = 0;

  if (!e_mail_remote_glue_msgstream_type) {
    static GTypeInfo info = {
      sizeof (EMailRemoteGlueMsgStreamClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) e_mail_remote_glue_msgstream_class_init,
      NULL, NULL,
      sizeof (EMailRemoteGlueMsgStream),
      0,
      (GInstanceInitFunc) e_mail_remote_glue_msgstream_init
    };
    e_mail_remote_glue_msgstream_type = g_type_register_static (G_TYPE_OBJECT, "EMailRemoteGlueMsgStream", &info, 0);
  }

  return e_mail_remote_glue_msgstream_type;
}

/* Class initialization function for the calendar-glue object */
static void
e_mail_remote_glue_msgstream_class_init (EMailRemoteGlueMsgStreamClass *klass)
{
  GObjectClass *object_class;

  object_class = (GObjectClass *) klass;

  parent_class = g_type_class_peek_parent (klass);

  object_class->finalize = e_mail_remote_glue_msgstream_finalize;
}

/* Object initialization function for the calendar-glue object */
static void
e_mail_remote_glue_msgstream_init (EMailRemoteGlueMsgStream *emrg_msgstream, EMailRemoteGlueMsgStreamClass *klass)
{  
  emrg_msgstream->priv = g_new0 (EMailRemoteGlueMsgStreamPrivate, 1);
}

/**
 * e_mail_remote_glue_msgstream_new:
 *
 * Creates a new empty calendar-glue component object.  
 *
 * Return value: A newly-created calendar-glue component object.
 **/
EMailRemoteGlueMsgStream *
e_mail_remote_glue_msgstream_new (void)
{
  return E_MAIL_REMOTE_GLUE_MSGSTREAM (g_object_new (E_TYPE_MAIL_REMOTE_GLUE_MSGSTREAM, NULL));
}

/* Finalize handler for the calendar-glue component object */
static void
e_mail_remote_glue_msgstream_finalize (GObject *object)
{
  EMailRemoteGlueMsgStream *stream;
  EMailRemoteGlueMsgStreamPrivate *priv;

  g_return_if_fail (object != NULL);
  g_return_if_fail (E_IS_MAIL_REMOTE_GLUE_MSGSTREAM (object));

  stream = E_MAIL_REMOTE_GLUE_MSGSTREAM (object);
  priv = stream->priv;

  if (priv) {
    bonobo_object_release_unref (priv->stream, NULL);
    priv->stream = NULL;

    g_free (priv);
    stream->priv = NULL;
  }
  
  if (G_OBJECT_CLASS (parent_class)->finalize)
    (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

EMailRemoteGlueMsgStream*
e_mail_remote_glue_msgstream_new_clone (EMailRemoteGlueMsgStream* stream)
{
  CORBA_Environment ev = { 0 };
  EMailRemoteGlueMsgStream* emrg_msgstream = e_mail_remote_glue_msgstream_new ();
  EMailRemoteGlueMsgStreamPrivate* priv = emrg_msgstream->priv;

  priv->stream = bonobo_object_dup_ref (stream->priv->stream, &ev);
  /* FIXME: Error handling */
  
  return emrg_msgstream;
}


EMailRemoteGlueMsgStream*
e_mail_remote_glue_msgstream_new_from_EMMsgStream (Evolution_Mail_MessageStream stream)
{
  EMailRemoteGlueMsgStream* emrg_msgstream = e_mail_remote_glue_msgstream_new ();
  EMailRemoteGlueMsgStreamPrivate* priv = emrg_msgstream->priv;
  CORBA_Environment ev = { 0 };

  priv->stream = bonobo_object_dup_ref (stream, &ev);
  /* FIXME: Error handling */
  
  return emrg_msgstream;
}

Evolution_Mail_MessageStream 
e_mail_remote_glue_msgstream_peek_stream (EMailRemoteGlueMsgStream* stream)
{
  g_return_val_if_fail (stream != NULL, NULL);
  g_return_val_if_fail (stream->priv != NULL, NULL);

  return stream->priv->stream;
}

char*
e_mail_remote_glue_msgstream_get_next (EMailRemoteGlueMsgStream* emrg_msgstream, 
				       size_t n_bytes, 
				       size_t* bytes_read)
{
  EMailRemoteGlueMsgStreamPrivate* priv = emrg_msgstream->priv;
  Evolution_Mail_Buffer *buf = NULL;
  CORBA_Environment ev = { 0 };
  char* retbuf = NULL;

  buf = Evolution_Mail_MessageStream_next (priv->stream, n_bytes, &ev);
  if (ev._major != CORBA_NO_EXCEPTION) {
    e_mail_exception_dump(&ev, "getting next message-stream");
    return NULL;
  }

  retbuf = g_strdup (buf->_buffer);
  *bytes_read = buf->_length;

  CORBA_free (buf);

  return retbuf;
}
