/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "battery.h"

#define NAME_(x)	battery_ ## x

struct cpssp {
	unsigned int generic_voltage;

	struct sig_std_logic *port_vdd;
	struct sig_std_logic *port_vss;

	unsigned long long time;
};

static void
NAME_(event)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	double energy;

	energy = sig_std_logic_supply(cpssp->port_vdd, cpssp);

	// fprintf(stderr, "Energy consumed: %e\n", energy);

	cpssp->time += TIME_HZ / 4;
	time_call_at(cpssp->time, NAME_(event), cpssp);
}

void *
NAME_(create)(
	const char *name,
	const char *voltage,
	struct sig_manage *manage,
	struct sig_std_logic *port_vdd,
	struct sig_std_logic *port_vss
)
{
	struct cpssp *cpssp;

	if (! voltage) voltage = "3300";

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->generic_voltage = atoi(voltage);

	cpssp->time = 0ULL;

	/* Out */
	cpssp->port_vdd = port_vdd;
	sig_std_logic_connect_out(port_vdd, cpssp,
			SIG_COMB(cpssp->generic_voltage, -1));

	cpssp->port_vss = port_vss;
	sig_std_logic_connect_out(port_vss, cpssp,
			SIG_COMB(0, -1));

	time_call_at(cpssp->time, NAME_(event), cpssp);

	return cpssp;
}

void
NAME_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
NAME_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
NAME_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
