/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GDB_H_INCLUDED
#define __GDB_H_INCLUDED

struct gdb_funcs {
	int (*reg_read)(void *cpssp, unsigned long addr, void *buf, int len);
	int (*mem_read)(void *cpssp, unsigned long addr, void *buf, int len);
	int (*mem_write)(void *cpssp, unsigned long addr, void *buf, int len);
	int (*brk_set)(void *cpssp, int type, unsigned long addr, int len);
	int (*brk_clr)(void *cpssp, int type, unsigned long addr, int len);
};

struct gdb {
	enum {
		GDB_STATE_RUNNING,
		GDB_STATE_STOPPING,
		GDB_STATE_STOPPED,
		GDB_STATE_EXITING,
	} state;
	int reason;
	enum {
		GDB_PARSE_NONE,
		GDB_PARSE_COMMAND,
		GDB_PARSE_CHECKSUM0,
		GDB_PARSE_CHECKSUM1,
		GDB_PARSE_DONE,
	} parse;

	int sockfd;
	int datafd;

	char req[1024];
	char ans[1024];

	void *cpssp;
	struct gdb_funcs *funcs;
};

extern void
gdb_do(struct gdb *gdb);

extern void
gdb_stop(struct gdb *gdb, int sig);

extern void
gdb_port(int port);

extern struct gdb *
gdb_create(const char *name, void *cpssp, struct gdb_funcs *funcs);
extern void
gdb_destroy(struct gdb *gdb);

#endif /* __GDB_H_INCLUDED */
