/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <ferite.h>
#include "sql_header.h"
#include <mysql.h>
#include <mysql_version.h>

typedef struct __mysql_connection
{
   MYSQL          *connection;
   MYSQL_RES      *currentResult;
   FeriteVariable *currentRecord;
}
MySQLConnection;

#define SelfObject          ((MySQLConnection*)smi->tagged_data)
#define current_connection  ((MySQLConnection*)smi->tagged_data)->connection
#define current_result      ((MySQLConnection*)smi->tagged_data)->currentResult
#define current_record      ((MySQLConnection*)smi->tagged_data)->currentRecord

void db_mysql_init( DbModuleInterface *smi )
{
   SelfObject = fmalloc( sizeof( MySQLConnection ) );
   current_result = NULL;
   current_record = NULL;
   current_connection = NULL;
   current_connection = mysql_init( current_connection );
}

void db_mysql_deinit( DbModuleInterface *smi )
{
   if( current_record )
   {
      __ferite_variable_destroy( NULL, current_record );
   }
   if( current_result )
   {
      mysql_free_result( current_result );
   }
   if( current_connection != NULL )
     mysql_close( current_connection );
   ffree( SelfObject );
}

FeriteVariable *db_mysql_connect( DbModuleInterface *smi, char *database, char *hostname, char *username, char *password )
{
   MYSQL *returnValue;

   FUD(( "db_mysql_connect()\n" ));
   current_connection = mysql_init( current_connection );
   if( mysql_real_connect( current_connection, hostname, username, password, database, 0, NULL, 0 ) == NULL )
   {
      FE_RETURN_FALSE;
   }
   FE_RETURN_TRUE;
}

FeriteVariable *db_mysql_close( DbModuleInterface *smi )
{
   FUD(( "db_mysql_close()\n" ));
   mysql_close( current_connection );
   current_connection = NULL;
   FE_RETURN_VOID;
}

FeriteVariable *db_mysql_query( DbModuleInterface *smi, char *query )
{
   int returnValue = 0;

   FUD(( "db_mysql_query( %s )\n", query ));
   if( current_result )
   {
	  mysql_free_result( current_result );
	  current_result = NULL;
   }
   returnValue = mysql_real_query( current_connection, query, strlen( query ) );
   /*if( returnValue >= 0 ){*/
   current_result = mysql_store_result( current_connection );
   /*}*/
   FE_RETURN_LONG( returnValue );
}

FeriteVariable *db_mysql_result_count( DbModuleInterface *smi )
{
   int count = 0;

   FUD(( "%s()\n", __FUNCTION__ ));
   if( current_result != NULL )
   {
	  count = mysql_num_rows( current_result );
   }
   FE_RETURN_LONG( count );
}

FeriteVariable *db_mysql_column_count( DbModuleInterface *smi )
{
   int count = 0;

   FUD(( "%s()\n", __FUNCTION__ ));
   if( current_result != NULL )
   {
	  count = mysql_num_fields( current_result );
   }
   FE_RETURN_LONG( count );
}

FeriteVariable *db_mysql_result_reset( DbModuleInterface *smi )
{
   FUD(( "%s()\n", __FUNCTION__ ));
   if( current_result != NULL )
   {
	  mysql_data_seek( current_result, 0 );
   }
   FE_RETURN_VOID;
}

FeriteVariable *db_mysql_next_record( DbModuleInterface *smi )
{
   unsigned int    num_fields, i = 0;
   unsigned long  *lengths;
   MYSQL_ROW       current_row;
   MYSQL_FIELD    *fields;
   FeriteVariable *array;

   FUD(( "%s()\n", __FUNCTION__ ));
   if( current_result != NULL )
   {
      num_fields = mysql_num_fields( current_result );
      current_row = mysql_fetch_row( current_result );
      fields = mysql_fetch_fields( current_result);
      if( current_row )
	  {
		 if( current_record )
		   __ferite_variable_destroy( smi->script, current_record );
		 array = __ferite_create_uarray_variable( "mysql_db_next_record", num_fields );
		 lengths = mysql_fetch_lengths( current_result );
		 FUD(( "Row: " ));
		 for(i = 0; i < num_fields; i++)
	     {
			__ferite_uarray_add( smi->script, VAUA(array), fe_new_str( fields[i].name, current_row[i] ? current_row[i] : "NULL" ), fields[i].name, -1 );
			FUD(("%s:[%.*s] ", fields[i].name, (int)lengths[i], current_row[i] ? current_row[i] : "NULL" ));
	     }
		 FUD(("\n"));
		 current_record = array;
		 FE_RETURN_TRUE;
	  }
   }
   else
   {
      if( current_record != NULL )
		__ferite_variable_destroy( smi->script, current_record );
      current_record = NULL;
   }
   FE_RETURN_FALSE;
}

FeriteVariable *db_mysql_get_row( DbModuleInterface *smi )
{
   FeriteVariable *var;

   FUD(( "%s()\n", __FUNCTION__ ));
   if( current_record != NULL )
   {
      var = __ferite_duplicate_variable( smi->script, current_record );
      FUD(( "size: %d\n", VAUA(var)->size ));
   }
   else
   {
      ferite_error( smi->script, "SQL:MySQL:getRow: No row to fetch" );
   }
   FE_RETURN_VAR( var );
}

FeriteVariable *db_mysql_fetch_fielFUD( DbModuleInterface *smi, char *name )
{
   FeriteVariable *var = NULL, *key = fe_new_str( name, name );

   FUD(( "%s()\n", __FUNCTION__ ));
   var = __ferite_uarray_op( smi->script, VAUA(current_record), key, NULL );
   __ferite_variable_destroy( smi->script, key );
   var = __ferite_duplicate_variable( smi->script, var );
   FE_RETURN_VAR( var );
}

/* I nicked this from php */
static char *db_mysql_get_field_name( int field_type )
{
   switch(field_type) {
	case FIELD_TYPE_STRING:
	case FIELD_TYPE_VAR_STRING:
	  return "string";
	  break;
#ifdef FIELD_TYPE_TINY
	case FIELD_TYPE_TINY:
#endif
	case FIELD_TYPE_SHORT:
	case FIELD_TYPE_LONG:
	case FIELD_TYPE_LONGLONG:
	case FIELD_TYPE_INT24:
	  return "int";
	  break;
	case FIELD_TYPE_FLOAT:
	case FIELD_TYPE_DOUBLE:
	case FIELD_TYPE_DECIMAL:
	  return "real";
	  break;
	case FIELD_TYPE_TIMESTAMP:
	  return "timestamp";
	  break;
	case FIELD_TYPE_DATE:
	  return "date";
	  break;
	case FIELD_TYPE_TIME:
	  return "time";
	  break;
	case FIELD_TYPE_DATETIME:
	  return "datetime";
	  break;
	case FIELD_TYPE_TINY_BLOB:
	case FIELD_TYPE_MEDIUM_BLOB:
	case FIELD_TYPE_LONG_BLOB:
	case FIELD_TYPE_BLOB:
	  return "blob";
	  break;
	case FIELD_TYPE_NULL:
	  return "null";
	  break;
	default:
	  return "unknown";
	  break;
   }
}

FeriteVariable *db_mysql_fetch_field_type( DbModuleInterface *smi, int index )
{
   FeriteVariable *var = NULL;
   MYSQL_FIELD *field;
   
   FUD(( "%s()\n", __FUNCTION__ ));
   if( current_result != NULL ){
	  if( index < 0 || index >= (int)mysql_num_fields( current_result ) ){
		 ferite_error( smi->script, "SQL:MySQL:fieldType: Invalid index %d for sql query", index );
		 FE_RETURN_VOID;
	  }
	  mysql_field_seek( current_result, index );
	  if( (field = mysql_fetch_field( current_result )) == NULL ){
		 ferite_error( smi->script, "SQL:MySQL:fieldType: Invalid record at index %d", index );
		 FE_RETURN_VOID;
	  }
	  var = fe_new_str( "fieldType", db_mysql_get_field_name( field->type ) );
   } else {
	  ferite_error( smi->script, "No result availible" );
   }
   FE_RETURN_VAR( var );
}

FeriteVariable *db_mysql_fetch_field_name( DbModuleInterface *smi, int index )
{
   FeriteVariable *var = NULL;
   MYSQL_FIELD *field;
   
   FUD(( "%s()\n", __FUNCTION__ ));
   if( current_result != NULL ){
	  if( index < 0 || index >= (int)mysql_num_fields( current_result ) ){
		 ferite_error( smi->script, "SQL:MySQL:fieldName: Invalid index %d for sql query", index );
		 FE_RETURN_VOID;
	  }
	  mysql_field_seek( current_result, index );
	  if( (field = mysql_fetch_field( current_result )) == NULL ){
		 ferite_error( smi->script, "SQL:MySQL:fieldName: Invalid record at index %d", index );
		 FE_RETURN_VOID;
	  }
	  var = fe_new_str( "fieldName", field->name );
   } else {
	  ferite_error( smi->script, "No result availible" );
   }
   FE_RETURN_VAR( var );
}

FeriteVariable *db_mysql_fetch_field_length( DbModuleInterface *smi, int index )
{
   FeriteVariable *var = NULL;
   MYSQL_FIELD *field;
   
   FUD(( "%s()\n", __FUNCTION__ ));
   if( current_result != NULL ){
	  if( index < 0 || index >= (int)mysql_num_fields( current_result ) ){
		 ferite_error( smi->script, "SQL:MySQL:fieldLength: Invalid index %d for sql query", index );
		 FE_RETURN_VOID;
	  }
	  mysql_field_seek( current_result, index );
	  if( (field = mysql_fetch_field( current_result )) == NULL ){
		 ferite_error( smi->script, "SQL:MySQL:fieldLength: Invalid record at index %d", index );
		 FE_RETURN_VOID;
	  }
	  var = fe_new_lng( "fieldLength", field->length );
   } else {
	  ferite_error( smi->script, "No result availible" );
   }
   FE_RETURN_VAR( var );
}


