#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 2000, 2003 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the unterminated last line functionality
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

fail()
{
	set +x
	echo 'FAILED test of the unterminated last line functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test the unterminated last line functionality
#
cat > test.ok << 'fubar'
FILE A: f1
FILE B: f2
TOTALS: 1 inserted  1 deleted  1 matched

******************** REPLACE [A 2, B 2]:
line_two
******************** WITH:
line
fubar
if test $? -ne 0 ; then fail; fi

cat > f1 << 'fubar'
line_one
fubar
if test $? -ne 0 ; then fail; fi

cp f1 f2
if test $? -ne 0 ; then fail; fi

cat > twoA << 'fubar'
line_two
fubar
if test $? -ne 0 ; then fail; fi

#
# text files are different on Unix and Dos
# so if we want the same test both times,
# we have to be careful just _how_ we truncate the damn file.
#
dd if=twoA of=twoB bs=4 count=1 > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

cat twoA >> f1
if test $? -ne 0 ; then fail; fi
cat twoB >> f2
if test $? -ne 0 ; then fail; fi

$bin/fcomp f1 f2 > test.out 2> LOG
if test $? -ne 0 ; then cat LOG; fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
