#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 1993, 1994, 1998 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the fcomp -spaces option
#

work=/tmp/$$
PAGER=cat
export PAGER

fail()
{
	set +x
	echo FAILED test of the fcomp -spaces option 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# create the first file
#
sed 's/X//' > first << 'fubar'
this line has  embedded spaces
   this line has leading spaces
this line has trailing spaces   X
this line has	tabs	in	it
	int ident;		/* comment */
fubar
if test $? -ne 0 ; then fail; fi

#
# create the second file
#
sed 's/X//' > second << 'fubar'
this  line has embedded spaces
	this line has leading spaces
this  line has trailing spaces    X
this line has	tabs	in	it
	int	ident;	/* comment */
fubar
if test $? -ne 0 ; then fail; fi

#
# create the expected output
#
sed 's/X//' > ok << 'fubar'
Files "first" and "second" are identical
fubar
if test $? -ne 0 ; then fail; fi

#
# see if it works the way it should
#
$bin/fcomp -s first second -o output
if test $? -ne 0 ; then fail; fi
diff ok output
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
