#!/usr/bin/perl -w

use XFig;

my $fig = new XFig;

my $success = 1;

$fig->parseHead (*DATA);
$fig->parseBody (*DATA);
close DATA;

my @objects = $fig->eachCompound();
$success = 0
  if scalar @objects != 1;

$elem = $objects [0];
$success = 0
  if (not $elem->isCompound ())
     || (not defined $elem->{comment})
     || (scalar @{$elem->{comment}} != 1)
     || ((@{$elem->{comment}} [0]) ne " compound comment");

print "Reading compound comments: ", ($success ? "ok" : "failed"), "\n";

exit not $success;

__DATA__
#FIG 3.2
Landscape
Center
Metric
A4
100.00
Single
-2
1200 2
# compound comment
6 2700 3195 3870 4275
2 4 0 1 0 7 50 -1 -1 0.000 0 0 7 0 0 5
         3870 3915 3870 3510 3015 3510 3015 3915 3870 3915
2 3 0 1 0 7 50 -1 -1 0.000 0 0 0 0 0 7
         3600 4185 3832 3687 3517 3237 2970 3285 2738 3783 3053 4233
         3600 4185
-6
