/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  File-Roller
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef FR_COMMAND_CFILE_H
#define FR_COMMAND_CFILE_H


#include <gtk/gtk.h>
#include "fr-command.h"
#include "typedefs.h"


#define FR_COMMAND_CFILE_TYPE        (fr_command_cfile_get_type ())
#define FR_COMMAND_CFILE(o)          GTK_CHECK_CAST (o, FR_COMMAND_CFILE_TYPE, FRCommandCFile)
#define FR_COMMAND_CFILE_CLASS(k)    GTK_CHECK_CLASS_CAST (k, FR_COMMAND_CFILE_TYPE, FRCommandCFileClass)
#define IS_FR_COMMAND_CFILE(o)       GTK_CHECK_TYPE (o, FR_COMMAND_CFILE_TYPE)


typedef struct _FRCommandCFile       FRCommandCFile;
typedef struct _FRCommandCFileClass  FRCommandCFileClass;


struct _FRCommandCFile
{
	FRCommand  __parent;

	/*<private>*/

	FRCompressProgram compress_prog;
	FRProcError error;
};


struct _FRCommandCFileClass
{
	FRCommandClass __parent_class;
};


GtkType      fr_command_cfile_get_type   (void);

FRCommand*   fr_command_cfile_new        (FRProcess *process,
					  char *filename,
					  FRCompressProgram prog);


#endif /* FR_COMMAND_CFILE_H */
