#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "conf_callbacks.h"
#include "conf_mail.h"
#include "conf_support.h"
#include "main.h"

gint selected;

void
on_settings_clist_show                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
    add_to_clist(widget, NULL);
    selected = 0;
}



void
on_settings_ok_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *window = (GtkWidget *) user_data;
    hide_widget(NULL, user_data);
	gnome_config_push_prefix("");
	gnome_config_private_set_string("flink/general/soundfile", 
		gtk_entry_get_text(GTK_ENTRY(lookup_widget(window, "general_sound_entry"))));
	gnome_config_private_set_string("flink/general/programfile", 
		gtk_entry_get_text(GTK_ENTRY(lookup_widget(window, "general_external_entry"))));
	gnome_config_private_set_string("flink/theme3/pixmap_no", 
		gtk_entry_get_text(GTK_ENTRY(lookup_widget(window, "theme_entry_no"))));
	gnome_config_private_set_string("flink/theme3/pixmap_yes", 
		gtk_entry_get_text(GTK_ENTRY(lookup_widget(window, "theme_entry_yes"))));

	gnome_config_sync();
	read_conf(NULL, NULL);
}


void
on_settings_conf_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *pls_sel;
    if (selected == 0)
    {
		pls_sel = create_messagebox1();
		gtk_widget_show(pls_sel);
		return;
    }
    edit_account_win(NULL,(gint *) selected);
}


void
on_settings_clist_select_row           (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    selected = row + 1;
}


void
on_configure_abort_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    hide_widget(NULL, user_data);
}


void
on_button1_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
    hide_widget(NULL, user_data);
}


void
on_configure_apply_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    save_account(NULL, user_data);
    selected = 0;
}


void
on_configure_ok_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
    save_account(NULL, user_data);
    selected = 0;
    hide_widget(NULL, user_data);
}


void
on_druid1_cancel                       (GnomeDruid      *gnomedruid,
                                        gpointer         user_data)
{
    hide_widget(NULL, user_data);
}


void
on_druidpagefinish1_finish             (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
    save_account(NULL, user_data);
    hide_widget(NULL, user_data);
}


void
on_settings_del_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *pls_sel;
    if (selected == 0)
    {
		pls_sel = create_messagebox1();
		gtk_widget_show(pls_sel);
		return;
    }
    delete_account(NULL, (gint *) selected);
    selected = 0;
}


void
on_button5_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
    hide_widget(NULL, user_data);
}

void
on_configure_pop3_radio_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *window = (GtkWidget *) user_data;
    
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "label21")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "configure_fold_entry")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "label26")));    
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "configure_path_entry")));
    
    gtk_label_set_text(GTK_LABEL(lookup_widget(window, "configure_type_label")), "pop3");
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "configure_host_entry")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "configure_user_entry")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "configure_pass_entry")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "label5")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "label6")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "label7")));
}


void
on_configure_imap4_radio_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *window = (GtkWidget *) user_data;
    
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "label26")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "configure_path_entry")));
    
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "label21")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "configure_fold_entry")));
    gtk_label_set_text(GTK_LABEL(lookup_widget(window, "configure_type_label")), "imap4");

    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "configure_host_entry")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "configure_user_entry")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "configure_pass_entry")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "configure_fold_entry")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "label5")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "label6")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "label7")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "label21")));
}


void
on_configure_mbox_radio_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *window = (GtkWidget *) user_data;
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "label26")));
    gtk_widget_show(GTK_WIDGET(lookup_widget(window, "configure_path_entry")));
    gtk_label_set_text(GTK_LABEL(lookup_widget(window, "configure_type_label")), "mbox");
    
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "configure_host_entry")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "configure_user_entry")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "configure_pass_entry")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "configure_fold_entry")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "label5")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "label6")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "label7")));
    gtk_widget_hide(GTK_WIDGET(lookup_widget(window, "label21")));
}

void
on_general_horisontal_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_config_push_prefix("");
	gnome_config_private_set_string("flink/general/layout", "horisontal");
	gnome_config_sync();
	read_conf(NULL, NULL);
	update_layout();
}



void
on_general_vertical_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_config_push_prefix("");
	gnome_config_private_set_string("flink/general/layout", "vertical");
	gnome_config_sync();
	read_conf(NULL, NULL);
	update_layout();
}


void
on_general_theme_show                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
	add_to_theme_list(widget, NULL);
}


void
on_general_themes_select_row           (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gint no;
	no = row + 1;
	gnome_config_push_prefix("");
	if (no == 3)
	{
		save_user_theme();
	}
		
	gnome_config_private_set_int("flink/general/selected_theme", no);
	gnome_config_sync();
	update_label((gint *) no);
}

void
on_dialog1_realize                     (GtkWidget       *widget,
                                        gpointer         user_data)
{
	visualize_general_prefs(NULL, user_data);
}

void
on_general_beep_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_config_push_prefix("flink/general/");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) == TRUE)
		gnome_config_private_set_int("bell", 1);
	else
		gnome_config_private_set_int("bell", 0);
	gnome_config_sync();
	read_conf(NULL, NULL);
}


void
on_general_sound_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_config_push_prefix("flink/general/");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) == TRUE)
		gnome_config_private_set_bool("sound", TRUE);
	else
		gnome_config_private_set_bool("sound", FALSE);
	gnome_config_sync();
	read_conf(NULL,NULL);
}


void
on_general_external_in_menu_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_config_push_prefix("flink/general/");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) == TRUE)
		gnome_config_private_set_bool("program", TRUE);
	else
		gnome_config_private_set_bool("program", FALSE);
	remove_program_item();
	gnome_config_sync();
	read_conf(NULL,NULL);
	update_menu();
}


void
on_general_external_auto_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_config_push_prefix("flink/general/");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) == TRUE)
		gnome_config_private_set_bool("autoprog", TRUE);
	else
		gnome_config_private_set_bool("autoprog", FALSE);
	gnome_config_sync();
	read_conf(NULL,NULL);
}


void
on_button6_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_sound_play(gtk_entry_get_text(GTK_ENTRY(lookup_widget((GtkWidget *) user_data, "general_sound_entry"))));
}
