/***************************************************************************
 *
 *		File		: imaplib.h
 *
 *		Title		: IMAPv4 connect/mailcheck library
 *
 *		Description	: see imaplib.c
 *
 *		Author		: Marcus Leyman, 2001
 *
 *		License		: GPL
 *
 *		Date		: 6 May, 2001
 *
 **************************************************************************/
 
#ifndef IMAPLIB_H
#define IMAPLIB_H


typedef struct {
	int sd;
	char *host;
	int port;
	int state;
#		define IMAP_NONE   0
#		define IMAP_AUTH   1
#		define IMAP_TRANS  2
#		define IMAP_UPDATE 3
} imapLink;

typedef struct {
	char *err;
	int msgs;
	int msgs_new;
	long bytes;
} imapStatInfo;

imapLink *imapConnect (char *host);

void imapDisconnect (imapLink *link);

char *imapStdLogin (imapLink *link, char *user, char *pass);

imapStatInfo *imapStatistics (imapLink *link, char *folder);

#endif
