/***************************************************************************
 *
 *		File		: main.c
 *
 *		Title		: Flink email checking applet for GNOME
 *
 *		Description	: E-mail biff.
 *
 *		Author		: Marcus Leyman, 2001
 *
 *		License		: GPL
 *
 *		Date		: 6 May, 2001
 *
 *		THANKS	:	Dave Neitz for fixing bug if Polltime is 0
 *
 **************************************************************************/

#include <gnome.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>
#include <applet-widget.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>
#include <unistd.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <pthread.h>
#include <gdk/gdk.h>
#include <config.h>

#include "main.h"
#include "poplib.h"
#include "imaplib.h"
#include "mboxlib.h"
#include "conf_mail.h"
#include "conf_support.h"

/* public declarations, this is... this is.. gah. */

/* applet itself */
GtkWidget *applet;
GtkWidget *settings_win;
GtkWidget *wizard_win;
GtkWidget *acc_win;
/* for the panel button */
GtkWidget *a_button;
GtkWidget *a_pixmap_yes;
GtkWidget *a_pixmap_no;
GtkWidget *a_label;
GtkWidget *a_table;
/* for the menu */
GtkWidget *b_menu;
GtkWidget *b_item[64];
gchar *b_label[64];
GtkWidget *b_item_err[64];
GtkWidget *program_item;
/* config stores */
gchar *cfg_name[64];
gchar *cfg_host[64];
gchar *cfg_user[64];
gchar *cfg_pass[64];
gchar *cfg_fold[64];
gchar *cfg_type[64];
gchar *cfg_path[64];
gint  cfg_bell;	//change me to bool
gboolean cfg_sound; 
gboolean cfg_program;
gboolean cfg_program_auto;
gchar *cfg_programfile; 
gchar *cfg_soundfile;
gint  cfg_layout;
gint  cfg_poll[64];
gint  cfg_boxes;    
gint first_time; //change me to bool
gint new_mail[64];
gint new_mail_old[64];
gchar *err_mail[64];
gint timeout[64];
/* theme specific */
gchar *theme_name[6];
gchar *cfg_pixmap_yes[6];
gchar *cfg_pixmap_no[6];
gint themes;
gint theme;

/* main function */
int main(int argc, char **argv)
{
    gint upd_lab;
    gint current;
	gchar *test;
	struct rlimit rlim;
	
	/* init i18n stuff */
    bindtextdomain (PACKAGE, GNOMELOCALEDIR);
    textdomain (PACKAGE);

	/* dont dump core! */
	rlim.rlim_cur = 0;
	rlim.rlim_max = 0;
	setrlimit(RLIMIT_CORE, &rlim);
	
	/* do gnome applet magic */
    applet_widget_init(PACKAGE, VERSION, argc, argv, NULL, 0, NULL);
    
    applet = applet_widget_new(PACKAGE);
    if (!applet)
		g_error(_("Can't create applet\n"));   
		
    gtk_signal_connect(GTK_OBJECT(applet), "destroy",
			GTK_SIGNAL_FUNC(gtk_exit), NULL);
  
    gtk_signal_connect(GTK_OBJECT(applet), "delete_event",
			GTK_SIGNAL_FUNC(gtk_exit), NULL);

    applet_widget_register_stock_callback(APPLET_WIDGET(applet),
										    "config",
										    GNOME_STOCK_MENU_PROP,
				   						 _("Settings"),
				    						load_config_win,
				    						NULL);
				  
    applet_widget_register_callback(APPLET_WIDGET(applet),
								    "about",
								    _("About..."),
				   				 load_about_win,
				    				NULL);

    read_conf(NULL, NULL);
    start_poll_stuff();
    create_panel_applet();
	
    upd_lab = gtk_timeout_add(1000, update_label, NULL);
    update_label(NULL); 

    for (current = 1; current <= cfg_boxes; current++)
    {
		new_mail[current] = 0;
		new_mail_old[current] = 0;
		err_mail[current] = "";
    }
    
    applet_widget_gtk_main();
    return 0;
}

void create_panel_applet()
{
    gint current;
    gchar *pix_file;
    GtkWidget *checkall;
    GtkWidget *separator;

    /* lets create the panel button */
    
    a_button = gtk_button_new();
    gtk_button_set_relief(GTK_BUTTON(a_button), GTK_RELIEF_NONE);

    a_label = gtk_label_new("0");

    a_pixmap_yes = gtk_type_new(gnome_pixmap_get_type());
    a_pixmap_no = gtk_type_new(gnome_pixmap_get_type());
	if (theme != 3)
	    pix_file = gnome_pixmap_file(cfg_pixmap_no[theme]);
	else
		pix_file = cfg_pixmap_no[theme];

    if (pix_file)
		gnome_pixmap_load_file(GNOME_PIXMAP(a_pixmap_no), pix_file);
    else
		g_warning (_("Couldn't find pixmap file: %s"), cfg_pixmap_no[theme]);
 	   g_free(pix_file);
	if (theme != 3)
	    pix_file = gnome_pixmap_file(cfg_pixmap_yes[theme]);
	else
		pix_file = cfg_pixmap_yes[theme];
    if (pix_file)
		gnome_pixmap_load_file(GNOME_PIXMAP(a_pixmap_yes), pix_file);
    else
		g_warning (_("Couldn't find pixmap file: %s"), cfg_pixmap_yes[theme]);
 	   g_free(pix_file);
 	   
    a_table = gtk_table_new(2,2, FALSE);
    if(cfg_layout == 0)
    {
    	gtk_table_attach_defaults(GTK_TABLE(a_table), a_pixmap_no, 0,1,0,1);
    	gtk_table_attach_defaults(GTK_TABLE(a_table), a_pixmap_yes, 0,1,0,1);
    	gtk_table_attach_defaults(GTK_TABLE(a_table), a_label, 1,2,0,1);
    	gtk_table_set_col_spacings(GTK_TABLE(a_table), 4);
    } else {
    	gtk_table_attach_defaults(GTK_TABLE(a_table), a_pixmap_no, 0,1,0,1);
    	gtk_table_attach_defaults(GTK_TABLE(a_table), a_pixmap_yes, 0,1,0,1);
    	gtk_table_attach_defaults(GTK_TABLE(a_table), a_label, 0,1,1,2);
    }

    gtk_container_add(GTK_CONTAINER(a_button), a_table);
    applet_widget_add(APPLET_WIDGET(applet), a_button);
    gtk_widget_show(a_button);
    gtk_widget_show(a_table);
    gtk_widget_show(a_pixmap_no);
    gtk_widget_show(a_label);
    gtk_widget_show(applet);
    gtk_signal_connect(GTK_OBJECT(a_button), "clicked",
			GTK_SIGNAL_FUNC(show_menu), NULL);

	/* Create the Menu */
    b_menu = gtk_menu_new();    

    for (current = 1; current <= cfg_boxes; current++)
    {
 	   b_label[current] = g_strdup_printf(_("0 new mail in: %s"), cfg_name[current]);

		b_item[current] = gtk_menu_item_new_with_label(b_label[current]);
		gtk_widget_show(b_item[current]);
		gtk_menu_append(GTK_MENU(b_menu), b_item[current]);
		gtk_signal_connect(GTK_OBJECT(b_item[current]), "activate",
			    GTK_SIGNAL_FUNC(check_this), (gpointer) current);
    }
    
    separator = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(b_menu), separator);
    gtk_widget_show(separator);

    checkall = gtk_menu_item_new_with_label(_("Check all accounts"));
    gtk_menu_append(GTK_MENU(b_menu), checkall);
    gtk_widget_show(checkall);
    gtk_signal_connect(GTK_OBJECT(checkall), "activate",
						GTK_SIGNAL_FUNC(check_all), NULL);

	if (cfg_program == TRUE)
	{
		program_item = gtk_menu_item_new_with_label(_("Run program..."));
		gtk_menu_append(GTK_MENU(b_menu), program_item);
		gtk_widget_show(program_item);
		gtk_signal_connect(GTK_OBJECT(program_item), "activate",
							GTK_SIGNAL_FUNC(run_program), NULL);
	}
}

void show_menu(GtkWidget *widget, gpointer data)
{
    gtk_menu_popup(GTK_MENU(b_menu), NULL, NULL, pos, NULL, 1, 0);
}

void update_menu()
{
	gint current;
    for (current = cfg_boxes; current >= 1; current--)
    {
		if(b_item[current])
		{
			gtk_widget_destroy(b_item[current]);
			g_free(b_label[current]);
		}
		
		if (err_mail[current] != "") 
		{
		    b_label[current] = g_strdup_printf(_("X new mail in: %s, %s"),
												cfg_name[current],
												err_mail[current]);
		} else {
	 	   b_label[current] = g_strdup_printf(_("%d new mail in: %s"), 
												new_mail[current], 
												cfg_name[current]);
		}
	
		b_item[current] = gtk_menu_item_new_with_label(b_label[current]);
		gtk_widget_show(b_item[current]);
		gtk_menu_prepend(GTK_MENU(b_menu), b_item[current]);
		gtk_signal_connect(GTK_OBJECT(b_item[current]), "activate",
			    GTK_SIGNAL_FUNC(check_this), (gpointer) current);
    }
 
	if (cfg_program == TRUE)
	{
		gtk_widget_destroy(program_item);
		program_item = gtk_menu_item_new_with_label(_("Run program..."));
		gtk_menu_append(GTK_MENU(b_menu), program_item);
		gtk_widget_show(program_item);
		gtk_signal_connect(GTK_OBJECT(program_item), "activate",
							GTK_SIGNAL_FUNC(run_program), NULL);
	}

}

void pos(GtkMenu *b_menu, gint * x, gint * y, gpointer data)
{
    gint lx, ty, by;
    gint scr_width, scr_height;
    gint width, height;
    
    gdk_window_get_position(GTK_WIDGET(applet)->window, &lx, &ty);
    scr_width = gdk_screen_width();
    scr_height = gdk_screen_height();
    width = GTK_WIDGET(b_menu)->requisition.width;
    height = GTK_WIDGET(b_menu)->requisition.height;
    by = ty + applet->allocation.height;
    if ( lx + width > scr_width)
	lx = scr_width - width;
    if ( lx < 0)
	lx = 0;
    *x = lx;
    if ( by + height < scr_height)
    {
	*y = by;
	return;
    }    
    if ( ty - height > 0)
	*y = ty - height;
    else
	*y = 0;
}

void read_conf(GtkWidget *widget, gpointer data)
{
    gint current;
    gchar *path;
	gchar *tmp;    
	gchar *themename;
	gchar *themeyes;
	gchar *themeno;

	gnome_config_push_prefix("");
	first_time = 0;
	/* this fixes sections defaults for new, or old config files */

	if (gnome_config_private_has_section("flink/version"))
	{

		if (gnome_config_private_get_int("flink/version/cfg_version") != 3)
		{
			config_file_set();
			first_time = 1;
		} else {
			first_time = 0;
		}
	}
	
	if (!(gnome_config_private_has_section("flink/version")))
	{
		config_file_set();
		first_time = 1;
	}

    gnome_config_push_prefix("");
    if (first_time == 1)
    {
		theme = 1;
		cfg_pixmap_yes[1] = "flink/mail_yes.xpm";
		cfg_pixmap_no[1] = "flink/mail_no.xpm";
		first_time_dia();
    } else {

		first_time = 0;
		gnome_config_push_prefix("flink/general/");
		cfg_boxes = gnome_config_private_get_int("boxes");
		tmp = gnome_config_private_get_string("layout");
		themes = gnome_config_private_get_int("themes");
		theme = gnome_config_private_get_int("selected_theme");
		cfg_bell = gnome_config_private_get_int("bell");
		cfg_sound = gnome_config_private_get_bool("sound");
		cfg_soundfile = gnome_config_private_get_string("soundfile");
		cfg_program = gnome_config_private_get_bool("program");
		cfg_programfile = gnome_config_private_get_string("programfile");
		cfg_program_auto = gnome_config_private_get_bool("autoprog");
		gnome_config_push_prefix("");
		for (current = 1; current <= themes; current++)
		{
			themename = g_strdup_printf("flink/theme%d/name", current);
			themeyes = g_strdup_printf("flink/theme%d/pixmap_yes", current);
			themeno = g_strdup_printf("flink/theme%d/pixmap_no", current);
			theme_name[current] = gnome_config_private_get_string(themename);
			cfg_pixmap_yes[current] = gnome_config_private_get_string(themeyes);
			cfg_pixmap_no[current] = gnome_config_private_get_string(themeno);
		}
	    g_free(themename);
		g_free(themeyes);
		g_free(themeno);

		if(strcmp(tmp, "horisontal") == 0)
			cfg_layout = 0;
		else
			cfg_layout = 1;
		g_free(tmp);
		for (current = 1; current <= cfg_boxes; current++)
		{	
		    path = g_strdup_printf("flink/mail%d/", current);
		    gnome_config_push_prefix(path);
				g_free(path);
    	    cfg_type[current] = gnome_config_private_get_string("Type");
		    cfg_name[current] = gnome_config_private_get_string("Name");
		    if(strcmp(cfg_type[current], "mbox") == 0)
		    {
				cfg_path[current] = gnome_config_private_get_string("Path");
				cfg_poll[current] = gnome_config_private_get_int("Poll");
		    } else {   
		    	cfg_host[current] = gnome_config_private_get_string("Host");
		    	cfg_user[current] = gnome_config_private_get_string("User");
		    	cfg_pass[current] = gnome_config_private_get_string("Pass");
		    	cfg_poll[current] = gnome_config_private_get_int("Poll");
		    }
		    if (strcmp(cfg_type[current], "imap4") == 0)
				cfg_fold[current] = gnome_config_private_get_string("Folder"); 
		}
    }
}

void check_all(GtkWidget *widget, gpointer data)
{
    gint current;
    pthread_t thread[64];
    for (current = 1; current <= cfg_boxes; current++)
    {	
		if (strcmp(cfg_type[current],"pop3") == 0)
		{
		    pthread_create(&thread[current], 
				    NULL, 
				    (void *)check_pop3, 
				    (gpointer) current);
		}
		if (strcmp(cfg_type[current],"imap4") == 0)
		{
		    pthread_create(&thread[current],
				    NULL,
				    (void *)check_imap4,
				    (gpointer) current);
		}
		if (strcmp(cfg_type[current], "mbox") == 0)
		{
		    pthread_create(&thread[current],
				    NULL,
				    (void *)check_mbox,
				    (gpointer) current);
		}

		pthread_detach(thread[current]);
    }
	
}

void check_this(GtkWidget *widget, gpointer data)
{
    gint current = (gint) data;
    pthread_t 	thread;

    if (strcmp(cfg_type[current], "pop3") == 0)
    {
        pthread_create(&thread, 
		        NULL, 
    			(void *)check_pop3, 
    			(gpointer) current);
    }
    
    if (strcmp(cfg_type[current], "imap4") == 0)
    {
		pthread_create(&thread,
	    	        NULL,
	    	        (void *)check_imap4,
    		        (gpointer) current);
    }
    if (strcmp(cfg_type[current], "mbox") == 0)
    {
        pthread_create(&thread,
			NULL,
			(void *)check_mbox,
			(gpointer) current);
    }
    pthread_detach(thread);	
}

void check_mbox(gpointer data)
{
    gint current = (gint) data;
    new_mail[current] = mboxStatistics(cfg_path[current]);
	if (new_mail[current] == -1)
	{
		new_mail[current] = 0;
		err_mail[current] = _("(no such path)");
	}
	if (new_mail[current] == -2)
	{
		new_mail[current] = 0;
		err_mail[current] = _("(could not open mbox)");
	}
    pthread_exit(0);
}

void check_imap4(gpointer data)
{
    imapLink *link;
    char *err;
    imapStatInfo *stat;
    gint current = (gint) data;

    if (!(link = imapConnect(cfg_host[current])))
    {
		new_mail[current] = 0;    
		err_mail[current] = _("(no connect to host)");
		pthread_exit(0);
    }
	else
    {
		if ((err = imapStdLogin(link, cfg_user[current], cfg_pass[current])))
		{
		    new_mail[current] = 0;
		    err_mail[current] = _("(Wrong password or username)");
		}
		else
		{
		    stat = imapStatistics(link, cfg_fold[current]);
	 	   if (stat->msgs)
	 	   {
				if (stat->msgs_new)
				{    
				    new_mail[current] = stat->msgs_new;
		 		   err_mail[current] = "";
				}
				else
				{
		 		   new_mail[current] = 0;
		  		  err_mail[current] = "";
				}
				err_mail[current] = "";
			}
	    	else
	    	{
				new_mail[current] = 0;
				err_mail[current] = "";
	   	 }
		}
  	  imapDisconnect(link);
    }
	g_free(err);
    pthread_exit(0);
}
void check_pop3(gpointer data)
{
    popLink *link;
    char *err;
    popStatInfo *stat;
    gint current = (gint) data;

    if (!(link = popConnect(cfg_host[current])))	
    {
		new_mail[current] = 0;
		err_mail[current] = _("(no connect to host)");
		pthread_exit(0);
    }
    else
    {
		if ((err = popStdLogin(link, cfg_user[current], cfg_pass[current])))
		{
	  	  new_mail[current] = 0;
	   	 err_mail[current] = _("(Wrong password or username)");
		}
		else
		{
	 	   stat = popStatistics(link);
	  	  if (stat->msgs)
	   	 {
				new_mail[current] = stat->msgs;
				err_mail[current] = "";
	   	 }
	  	  else
	   	 {
				new_mail[current] = 0;
				err_mail[current] = "";
	 	   }
		}
    	popDisconnect(link);
    }
    g_free(err);    
    pthread_exit(0);
}

void load_config_win()
{
    settings_win = create_dialog1();
    gtk_widget_show(settings_win);    
}

void new_account_win()
{
    wizard_win = create_window1();
    gtk_widget_show(wizard_win);
}

void edit_account_win(GtkWidget *w, gpointer data)
{
    gint current = (gint) data;
    acc_win = create_dialog2();
    gtk_widget_show(acc_win);
    gtk_label_set_text(GTK_LABEL(lookup_widget(acc_win, "configure_type_label")), cfg_type[current]);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(lookup_widget(acc_win, "configure_spin_no")), current);
    gtk_entry_set_text(GTK_ENTRY(lookup_widget(acc_win, "configure_name_entry")), cfg_name[current]);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(lookup_widget(acc_win, "configure_poll_spin")), cfg_poll[current]);

    if (strcmp(cfg_type[current], "mbox") != 0)
    {
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(acc_win, "configure_host_entry")), cfg_host[current]);
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(acc_win, "configure_user_entry")), cfg_user[current]);
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(acc_win, "configure_pass_entry")), cfg_pass[current]);
    }
    if (strcmp(cfg_type[current], "imap4") == 0)
    {
		gtk_widget_show(GTK_WIDGET(lookup_widget(acc_win, "label22")));
		gtk_widget_show(GTK_WIDGET(lookup_widget(acc_win, "configure_fold_entry")));
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(acc_win, "configure_fold_entry")), cfg_fold[current]);
    }
    if (strcmp(cfg_type[current], "mbox") == 0)
    {
		gtk_widget_show(GTK_WIDGET(lookup_widget(acc_win, "label27")));
		gtk_widget_show(GTK_WIDGET(lookup_widget(acc_win, "configure_path_entry")));
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(acc_win, "configure_path_entry")), cfg_path[current]);
		gtk_widget_hide(GTK_WIDGET(lookup_widget(acc_win, "label11")));
		gtk_widget_hide(GTK_WIDGET(lookup_widget(acc_win, "label12")));
		gtk_widget_hide(GTK_WIDGET(lookup_widget(acc_win, "label13")));
		gtk_widget_hide(GTK_WIDGET(lookup_widget(acc_win, "configure_host_entry")));
		gtk_widget_hide(GTK_WIDGET(lookup_widget(acc_win, "configure_user_entry")));
		gtk_widget_hide(GTK_WIDGET(lookup_widget(acc_win, "configure_pass_entry")));
    }
}

void hide_widget(GtkWidget *w, gpointer user_data)
{
    GtkWidget *widget = (GtkWidget *) user_data;
    gtk_widget_hide(widget);
}

void save_account(GtkWidget *w, gpointer data)
{
    GtkWidget *dialog = (GtkWidget *) data;
    GtkWidget *clist;
    gchar *path;
    gint current;
    gint poll;
    gint new_flag;
    
    new_flag = 0;
    /* sorry */
    current = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lookup_widget(dialog, "configure_spin_no")));
    if (current == 0)
    {
		gnome_config_push_prefix("");
		current = cfg_boxes + 1;
		new_flag = 1;
		gnome_config_private_set_int("flink/general/boxes", current);	
		new_mail[current] = 0;
		err_mail[current] = "";
    }
    
    path = g_strdup_printf("flink/mail%d/", current);
    gnome_config_push_prefix(path);
	    
    gtk_label_get(GTK_LABEL(lookup_widget(dialog, "configure_type_label")), &cfg_type[current]);
    gnome_config_private_set_string("Type", cfg_type[current]);

    cfg_name[current] = gtk_entry_get_text(GTK_ENTRY(lookup_widget(dialog, "configure_name_entry")));
    gnome_config_private_set_string("Name", cfg_name[current]); 

    if (strcmp(cfg_type[current], "mbox") != 0)
    {
		cfg_host[current] = gtk_entry_get_text(GTK_ENTRY(lookup_widget(dialog, "configure_host_entry")));    
        gnome_config_private_set_string("Host", cfg_host[current]);

    	cfg_user[current] = gtk_entry_get_text(GTK_ENTRY(lookup_widget(dialog, "configure_user_entry")));
        gnome_config_private_set_string("User", cfg_user[current]);

		cfg_pass[current] = gtk_entry_get_text(GTK_ENTRY(lookup_widget(dialog, "configure_pass_entry")));
		gnome_config_private_set_string("Pass", cfg_pass[current]);
    }
    
    cfg_poll[current] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lookup_widget(dialog, 
							    "configure_poll_spin")));
    if (strcmp(cfg_type[current], "imap4") == 0)
    {
		cfg_fold[current] = gtk_entry_get_text(GTK_ENTRY(lookup_widget(dialog, "configure_fold_entry")));
		gnome_config_private_set_string("Folder", cfg_fold[current]);    
    }
    if (strcmp(cfg_type[current], "mbox") == 0)
    {
		cfg_path[current] = gtk_entry_get_text(GTK_ENTRY(lookup_widget(dialog, "configure_path_entry")));
		gnome_config_private_set_string("Path", cfg_path[current]);
    }

    gnome_config_private_set_int("Poll", cfg_poll[current]);
    gnome_config_sync();

    if (first_time != 1)
    {
		clist = lookup_widget(settings_win, "settings_clist");
    	gtk_clist_clear(GTK_CLIST(clist));
		add_to_clist(clist, NULL);
    }

	read_conf(NULL, NULL);
	first_time = 0;    
    update_timeout(current);
	update_menu();
}


void add_to_clist(GtkWidget *widget, gpointer data)
{
    gint current;
    read_conf(NULL, NULL);
    for (current = 1; current <= cfg_boxes; current++)
    {
		gtk_clist_append(GTK_CLIST(widget), &cfg_name[current]);
    }
}

void delete_account(GtkWidget *w, gpointer data)
{
    gint current = (gint) data;
    GtkWidget *dialog_ensure;
    GtkWidget *clist;
    gint ret_val;
    gchar *path;
	gint tmp;
	gint store;
	gint old_store;
	
    dialog_ensure = create_dialog3();
    read_conf(NULL, NULL);
    ret_val = gnome_dialog_run_and_close(GNOME_DIALOG(dialog_ensure));
    if (ret_val == 1)
    {
		return;
	} else {
   	 gtk_timeout_remove(timeout[current]);    
		gnome_config_push_prefix("");
		path = g_strdup_printf("flink/mail%d/", current);		
		gnome_config_private_clean_section(path);
		gnome_config_private_set_int("flink/general/boxes", cfg_boxes -1);
		gnome_config_sync();
		
		/* update config_table, and write to cfg_file */
		if (current != cfg_boxes)
		{
			cfg_boxes = cfg_boxes -1;
			for (store = current; store <= cfg_boxes; store++)
			{
				old_store = store + 1;
				cfg_type[store] = cfg_type[old_store];
				cfg_name[store] = cfg_name[old_store];
				cfg_poll[store] = cfg_poll[old_store];
								
				cfg_host[store] = cfg_host[old_store];
				cfg_user[store] = cfg_user[old_store];
				cfg_pass[store] = cfg_pass[old_store];
				cfg_fold[store] = cfg_fold[old_store];
				cfg_path[store] = cfg_path[old_store];
				
				path = g_strdup_printf("flink/mail%d/", store);
				gnome_config_push_prefix(path);
				gnome_config_private_set_string("Type", cfg_type[old_store]);
				gnome_config_private_set_string("Name", cfg_name[old_store]);
				gnome_config_private_set_int("Poll", cfg_poll[old_store]);
				
    			if (strcmp(cfg_type[old_store], "pop3") == 0)
    			{
					gnome_config_private_set_string("Host", cfg_host[old_store]);
					gnome_config_private_set_string("User", cfg_user[old_store]);
					gnome_config_private_set_string("Pass", cfg_pass[old_store]);
				}
				if (strcmp(cfg_type[old_store], "imap4") == 0)
				{
					gnome_config_private_set_string("Host", cfg_host[old_store]);
					gnome_config_private_set_string("User", cfg_user[old_store]);
					gnome_config_private_set_string("Pass", cfg_pass[old_store]);
					gnome_config_private_set_string("Folder", cfg_fold[old_store]);
				}
				if (strcmp(cfg_type[old_store], "mbox") == 0);
					gnome_config_private_set_string("Path", cfg_path[old_store]);
			}			
			gnome_config_push_prefix("");
			path = g_strdup_printf("flink/mail%d/", cfg_boxes + 1);		
			gnome_config_private_clean_section(path);
		}
		gnome_config_sync();
		read_conf(NULL, NULL);
		/* lets update the list */		
        clist = lookup_widget(settings_win, "settings_clist");
		gtk_clist_clear(GTK_CLIST(clist));
		add_to_clist(clist, NULL);
		/* removes the acc from the menu */
		gtk_widget_destroy(b_item[current]);
		g_free(b_label[current]);

    }
	g_free(path);
}

void first_time_dia()
{
    GtkWidget *first_run_dialog;
    first_run_dialog = create_dialog4();
    gtk_widget_show(first_run_dialog);
}

void start_poll_stuff()
{
    gint current;
    gint polltime;
    gint curr_poll = 1;
    for(current = 1; current <= cfg_boxes; current++)
    {
                if (cfg_poll[current] == 0) curr_poll = 101;
                else curr_poll = cfg_poll[current];
		polltime = curr_poll * 60000;
		timeout[current] = gtk_timeout_add(polltime, poll_check, (gpointer) current);
    }
}

void update_timeout(gint current)
{
    gint polltime;
    gint curr_poll = 1;
    gtk_timeout_remove(timeout[current]);
    if (cfg_poll[current] == 0) curr_poll = 101;
    else curr_poll = cfg_poll[current];
    polltime = curr_poll * 60000;
    timeout[current] = gtk_timeout_add(polltime, poll_check, (gpointer) current);
}

int poll_check(gpointer data)
{
    gint current = (gint) data;
    if (cfg_poll[current] > 0)
      check_this(NULL, data);
    return(1);
}

int update_label(gpointer data)
{
    gint total;
    gchar *total_t;
    gint current;
    gchar *pix_file;

    total = 0;
    for (current = 1; current <= cfg_boxes; current++)
	{
		total = total + new_mail[current];
		if (new_mail[current] > new_mail_old[current]) 
		{
			if(cfg_bell == 1)
				gdk_beep();

			if (cfg_sound == TRUE && cfg_soundfile != "")
				gnome_sound_play(cfg_soundfile);
				
			if (cfg_program_auto == TRUE && cfg_programfile != "")
				run_program();
		}
		if (new_mail[current] != new_mail_old[current])
			update_menu();			
		
		new_mail_old[current] = new_mail[current];
	}		

    total_t = g_strdup_printf("%d", total);
    gtk_label_set_text(GTK_LABEL(a_label), total_t);
    
	/* change pixmaps with theme */
	if ((gpointer *) data != NULL && data != (gint *) theme)
	{
		read_conf(NULL, NULL);
		if (theme != 3)
	   	 pix_file = gnome_pixmap_file(cfg_pixmap_no[theme]);
	    else
	    	pix_file = cfg_pixmap_no[theme];
	    	
  	  if (pix_file)
			gnome_pixmap_load_file(GNOME_PIXMAP(a_pixmap_no), pix_file);
	    else
			g_warning (_("Couldn't find pixmap file: %s"), cfg_pixmap_no[theme]);
		
		if (theme != 3)
		    pix_file = gnome_pixmap_file(cfg_pixmap_yes[theme]);
		else 
			pix_file = cfg_pixmap_no[theme];
	    if (pix_file)
			gnome_pixmap_load_file(GNOME_PIXMAP(a_pixmap_yes), pix_file);
	    else
			g_warning (_("Couldn't find pixmap file: %s"), cfg_pixmap_yes[theme]);
	}

    if (total != 0)
    {
		gtk_widget_hide(GTK_WIDGET(a_pixmap_no));
		gtk_widget_show(GTK_WIDGET(a_pixmap_yes));
    }

    if (total == 0)
    {
		gtk_widget_hide(GTK_WIDGET(a_pixmap_yes));
		gtk_widget_show(GTK_WIDGET(a_pixmap_no));
    }
	g_free(total_t);
    return(1);	
}

void load_about_win()
{
    GtkWidget *about;
    int retsig;
    about = create_about1();
    /* wtf am i using retsig?? */
    retsig = gnome_dialog_run_and_close(GNOME_DIALOG(about));
	g_free((gint *) retsig);
}

void update_layout()
{
	/* FIX ME */
	gtk_widget_destroy(a_button);
	gtk_widget_destroy(a_label);
	gtk_widget_destroy(a_pixmap_no);
	gtk_widget_destroy(a_pixmap_yes);
	gtk_widget_destroy(a_table);
	create_panel_applet();
}

void add_to_theme_list(GtkWidget *widget, gpointer data)
{
    gint current;
    
    read_conf(NULL, NULL);
    
    for (current = 1; current <= themes; current++)
    {
		gtk_clist_append(GTK_CLIST(widget), &theme_name[current]);
    }
}

void visualize_general_prefs(GtkWidget *w, gpointer data)
{
	GtkWidget *dialog = (GtkWidget *) data;

	read_conf(NULL, NULL);
	if (cfg_layout == 0)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(dialog, "general_horisontal")), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(dialog, "general_vertical")), FALSE);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(dialog, "general_horisontal")), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(dialog, "general_vertical")), TRUE);
	}
	if (cfg_bell == 0)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(dialog, "general_beep")), FALSE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(dialog, "general_beep")), TRUE);
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(dialog, "general_sound")), cfg_sound);
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(dialog, "general_sound_entry")), cfg_soundfile);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(dialog, "general_external_in_menu")), cfg_program);
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(dialog, "general_external_entry")), cfg_programfile);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(dialog, "general_external_auto")), cfg_program_auto);
	
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(dialog, "theme_entry_no")), cfg_pixmap_no[3]);
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(dialog, "theme_entry_yes")), cfg_pixmap_yes[3]);
}

void run_program()
{
	gint prog_pid;
	prog_pid = gnome_execute_shell("~/", cfg_programfile);
}

void remove_program_item()
{
	if (cfg_program == TRUE)
		gtk_widget_destroy(program_item);
}

void set_entry(gchar *file)
{
	cfg_soundfile = file;
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(settings_win, "general_sound_entry")), cfg_soundfile);		
}

void save_user_theme()
{
	gnome_config_private_set_string("flink/theme3/pixmap_yes", 
								gtk_entry_get_text(GTK_ENTRY(lookup_widget(settings_win, "theme_entry_yes"))));
	gnome_config_private_set_string("flink/theme3/pixmap_no", 
								gtk_entry_get_text(GTK_ENTRY(lookup_widget(settings_win, "theme_entry_no"))));
}

void config_file_set()
{
	/* makes new config file if first run of version 0.3 */
	gnome_config_private_clean_file("flink");
	gnome_config_private_set_int("flink/version/cfg_version", 3);
	gnome_config_push_prefix("flink/general/");
	/* sets general prefs */
	gnome_config_private_set_int("boxes", 0);
	gnome_config_private_set_int("themes", 3);
	gnome_config_private_set_int("selected_theme", 1);
	gnome_config_private_set_string("layout", "horisontal");
	gnome_config_private_set_int("bell", 0);
	gnome_config_private_set_bool("sound", FALSE);
	gnome_config_private_set_string("soundfile", "");
	gnome_config_private_set_bool("program", FALSE);
	gnome_config_private_set_bool("autoprog", FALSE);
	gnome_config_private_set_string("programfile", "");
	/* inits standard themes */
	gnome_config_push_prefix("flink/theme1/");
	gnome_config_private_set_string("Name", "Small Icons");
	gnome_config_private_set_string("pixmap_yes", "flink/mail_yes.xpm");
	gnome_config_private_set_string("pixmap_no", "flink/mail_no.xpm");
	gnome_config_push_prefix("flink/theme2/");
	gnome_config_private_set_string("Name", "Big Icons");
	gnome_config_private_set_string("pixmap_yes", "flink/mail_yes2.xpm");
	gnome_config_private_set_string("pixmap_no", "flink/mail_no2.xpm");
	gnome_config_push_prefix("flink/theme3/");
	gnome_config_private_set_string("Name", "User Defined");
	gnome_config_private_set_string("pixmap_yes", "");
	gnome_config_private_set_string("pixmap_no", "");
	gnome_config_sync();
	read_conf(NULL, NULL);
	return;
}
