{
    $Id: cgenmath.inc,v 1.6 2005/02/14 17:13:22 peter Exp $
    This file is part of the Free Pascal run time library.
    Copyright (c) 1999-2001 by Several contributors

    Generic mathemtical routines in libc

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{ for 80x86, we can easily write the optimal inline code }
{$ifndef cpui386}

{$ifndef FPC_SYSTEM_HAS_INT}
{$define FPC_SYSTEM_HAS_INT}

{$ifdef SUPPORT_DOUBLE}
    function c_trunc(d: double): double; cdecl; external 'c' name 'trunc';

  {$ifdef INTERNCONSTINTF}
    function fpc_int_real(d: double): double;compilerproc; {$ifdef MATHINLINE}inline;{$endif}
  {$else}
    function int(d: double): double; {$ifdef MATHINLINE}inline;{$endif}[internconst:fpc_in_const_int];
  {$endif}
    begin
      result := c_trunc(d);
    end;


{$else SUPPORT_DOUBLE}

    function c_truncf(d: real): double; cdecl; external 'c' name 'truncf';

  {$ifdef INTERNCONSTINTF}
    function fpc_int_real(d: real): real;compilerproc; {$ifdef MATHINLINE}inline;{$endif}
  {$else}
    function int(d: real) : real;[internconst:fpc_in_const_int];
  {$endif}
      begin
        { this will be correct since real = single in the case of }
        { the motorola version of the compiler...                 }
        int:=c_truncf(d);
      end;
{$endif SUPPORT_DOUBLE}

{$endif}


{$ifndef SYSTEM_HAS_FREXP}
{$define SYSTEM_HAS_FREXP}
    function c_frexp(x: double; var e: longint): double; cdecl; external 'c' name 'frexp';

    function frexp(x:Real; var e:Integer ):Real; {$ifdef MATHINLINE}inline;{$endif}
    var
      l: longint;
    begin
      frexp := c_frexp(x,l);
      e := l;
    end;
{$endif not SYSTEM_HAS_FREXP}


{$ifndef SYSTEM_HAS_LDEXP}
{$define SYSTEM_HAS_LDEXP}
    function c_ldexp(x: double; n: longint): double; cdecl; external 'c' name 'ldexp';

    function ldexp( x: Real; N: Integer):Real;{$ifdef MATHINLINE}inline;{$endif}
    begin
      ldexp := c_ldexp(x,n);
    end;
{$endif not SYSTEM_HAS_LDEXP}


{$ifndef FPC_SYSTEM_HAS_SQRT}
{$define FPC_SYSTEM_HAS_SQRT}

    function c_sqrt(d: double): double; cdecl; external 'c' name 'sqrt';

  {$ifdef INTERNCONSTINTF}
    function fpc_sqrt_real(d:Real):Real;compilerproc; {$ifdef MATHINLINE}inline;{$endif}
  {$else}
    {$ifdef hascompilerproc}
    function fpc_sqrt_real(d:Real):Real;compilerproc; external name 'FPC_SQRT_REAL';
    {$endif hascompilerproc}
    function sqrt(d:Real):Real;[internconst:fpc_in_const_sqrt];[public, alias: 'FPC_SQRT_REAL']; {$ifdef MATHINLINE}inline;{$endif}
  {$endif}
    begin
      result := c_sqrt(d);
    end;

{$endif}


{$ifndef FPC_SYSTEM_HAS_EXP}
{$define FPC_SYSTEM_HAS_EXP}
    function c_exp(d: double): double; cdecl; external 'c' name 'exp';

  {$ifdef INTERNCONSTINTF}
    function fpc_Exp_real(d:Real):Real;compilerproc; {$ifdef MATHINLINE}inline;{$endif}
  {$else}
    function Exp(d:Real):Real;[internconst:fpc_in_const_exp]; {$ifdef MATHINLINE}inline;{$endif}
  {$endif}
    begin
      result := c_exp(d);
    end;
{$endif}

(*

Not supported on Mac OS X 10.1

{$ifndef FPC_SYSTEM_HAS_ROUND}
{$define FPC_SYSTEM_HAS_ROUND}

    function c_llround(d: double): int64; cdecl; external 'c' name 'llround';

{$ifdef hascompilerproc}
    function round(d : Real) : int64;{$ifndef INTERNCONSTINTF}[internconst:fpc_in_const_round];{$endif} external name 'FPC_ROUND';

    function fpc_round(d : Real) : int64;[public, alias:'FPC_ROUND'];{$ifdef hascompilerproc}compilerproc;{$endif hascompilerproc}
    begin
      fpc_round := c_llround(d);
    end;
{$else}
    function round(d : Real) : int64;{$ifndef INTERNCONSTINTF}[internconst:fpc_in_const_round];{$endif}
    begin
      round := c_llround(d);
    end;
{$endif hascompilerproc}
{$endif}
*)


{$ifndef FPC_SYSTEM_HAS_LN}
{$define FPC_SYSTEM_HAS_LN}

    function c_log(d: double): double; cdecl; external 'c' name 'log';

  {$ifdef INTERNCONSTINTF}
    function fpc_Ln_real(d:Real):Real;compilerproc;{$ifdef MATHINLINE}inline;{$endif}
  {$else}
    function Ln(d:Real):Real;[internconst:fpc_in_const_ln];{$ifdef MATHINLINE}inline;{$endif}
  {$endif}
    begin
      result := c_log(d);
    end;
{$endif}


{$ifndef FPC_SYSTEM_HAS_SIN}
{$define FPC_SYSTEM_HAS_SIN}
    function c_sin(d: double): double; cdecl; external 'c' name 'sin';

  {$ifdef INTERNCONSTINTF}
    function fpc_Sin_real(d:Real):Real;compilerproc; {$ifdef MATHINLINE}inline;{$endif}
  {$else}
    function Sin(d:Real):Real;[internconst:fpc_in_const_sin]; {$ifdef MATHINLINE}inline;{$endif}
  {$endif}
    begin
      result := c_sin(d);
    end;
{$endif}



{$ifndef FPC_SYSTEM_HAS_COS}
{$define FPC_SYSTEM_HAS_COS}
    function c_cos(d: double): double; cdecl; external 'c' name 'cos';

  {$ifdef INTERNCONSTINTF}
    function fpc_Cos_real(d:Real):Real;compilerproc; {$ifdef MATHINLINE}inline;{$endif}
  {$else}
    function Cos(d:Real):Real;[internconst:fpc_in_const_cos];{$ifdef MATHINLINE}inline;{$endif}
  {$endif}
    begin
      result := c_cos(d);
    end;
{$endif}



{$ifndef FPC_SYSTEM_HAS_ARCTAN}
{$define FPC_SYSTEM_HAS_ARCTAN}
    function c_atan(d: double): double; cdecl; external 'c' name 'atan';

  {$ifdef INTERNCONSTINTF}
    function fpc_ArcTan_real(d:Real):Real;compilerproc; {$ifdef MATHINLINE}inline;{$endif}
  {$else}
    function ArcTan(d:Real):Real;[internconst:fpc_in_const_arctan];{$ifdef MATHINLINE}inline;{$endif}
  {$endif}
    begin
      result := c_atan(d);
    end;
{$endif}

{$endif not i386}

{
  $Log: cgenmath.inc,v $
  Revision 1.6  2005/02/14 17:13:22  peter
    * truncate log

}
