/* FIGARO'S PASSWORD MANAGER (FPM)
 * Copyright (C) 2000 John Conneely
 * 
 * FPM is open source / free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * FPM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * callbacks.c
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "fpm.h"
#include "fpm_gpw.h"
#include "passfile.h"
#include "fpm_crypt.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  fpm_prefs_init();
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *about_safe;
	
  about_safe = create_about_safe ();
  gtk_widget_show (about_safe);
}

void
on_app_safe_destroy                    (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_main_quit();
}

void
on_button_ok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  fpm_save_passitem(glb_win_edit, glb_edit_data);
  gtk_widget_destroy(glb_win_edit);
  gtk_widget_set_sensitive(glb_win_app, TRUE);
}


void
on_button_cancel_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(glb_win_edit);
  gtk_widget_set_sensitive(glb_win_app, TRUE);
}


void
on_button_new_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  fpm_new_passitem(&glb_win_edit, &glb_edit_data);
}



void
on_button_edit_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  if (glb_edit_data != NULL)
    fpm_edit_passitem(&glb_win_edit, glb_edit_data);
  else
    gnome_ok_dialog("Please select a row.\n");


}


gboolean
on_app_safe_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  fpm_quit();
  return TRUE;
}


gboolean
on_clist_main_button_press_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  

  /* I couldn't see a way to handle double clicks with a CList,
   * so I implemented my own using the button press and release events.
   * This is the press events.  We check to see how many clicks we get
   * within FPM_MAX_DOUBLE_CLICK_TIME seconds, currently set to 0.5.
   */
  if(g_timer_elapsed(glb_timer_click, NULL) < FPM_MAX_DOUBLE_CLICK_TIME)
  {
    glb_click_count++;
  }
  else
  {
    g_timer_reset(glb_timer_click);
    glb_click_count=1;
  }

  return FALSE;
}


gboolean
on_clist_main_button_release_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  /* Handle double clicks
   * Here we are potentially releasing from a double click.  If we've clicked
   * more than once in the time allowed, consider it a double click.
   */
  if((g_timer_elapsed(glb_timer_click, NULL) < FPM_MAX_DOUBLE_CLICK_TIME) &&
     (glb_click_count > 1) )
  {
    fpm_double_click(glb_edit_data);
  }

  return FALSE;
}

void
on_clist_main_select_row               (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  glb_cur_row=row;
  glb_edit_data = (fpm_data*)
  	gtk_clist_get_row_data(glb_clist_main, glb_cur_row);

}


void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  passfile_save(glb_filename);
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  fpm_quit();
}


void
on_button_save_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  passfile_save(glb_filename);
}


gboolean
on_dialog_edit_passitem_delete_event   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gnome_ok_dialog_parented
	("Please push 'OK' or 'Cancel' to close this window.", 
	 GTK_WINDOW(glb_win_edit));
  return TRUE;
}


void
on_dialog_edit_passitem_destroy        (GtkObject       *object,
                                        gpointer         user_data)
{  
  /* Make main window active again */
  gtk_widget_set_sensitive(glb_win_app, TRUE);
 
}


void
on_dialog_edit_passitem_show           (GtkWidget       *widget,
                                        gpointer         user_data)
{

  /* Make main window inactive to simulate a modal edit window. 
   * We don't want to make the edit window really modal because
   * then anoying things happen like confirmation dialog boxes'
   * buttons don't work.
   */
  gtk_widget_set_sensitive(glb_win_app, FALSE);

}


void
on_togglebutton_showpass_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkEntry* entry_password;
  
  entry_password=GTK_ENTRY(lookup_widget (glb_win_edit, "entry_password"));
  if (togglebutton->active)
  {
    gtk_entry_set_visibility (entry_password, TRUE);
  }
  else
  {
    gtk_entry_set_visibility (entry_password, FALSE);
  }


}

void
on_button_jump_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  if (glb_edit_data != NULL)
    fpm_jump(glb_edit_data);
  else
    gnome_ok_dialog("Please select a row.\n");

}


void
on_button_pass_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  if (glb_edit_data != NULL)
    fpm_select_password(glb_edit_data, TRUE);
  else
    gnome_ok_dialog("Please select a row.\n");
}


void
on_button_user_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  if (glb_edit_data != NULL)
    fpm_select(glb_edit_data->user, TRUE);
  else
    gnome_ok_dialog("Please select a row.\n");
}


void
on_button_password_ok_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  fpm_check_password();
}


void
on_button_password_cancel_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_main_quit();
}


void
on_gpw_toggled                         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* widget;
  
  widget=lookup_widget(glb_win_misc, "entry_bits");
  if(strcmp("", gtk_entry_get_text(GTK_ENTRY(widget))))
  {
	  fpm_gpw_set_from_dialog(glb_win_misc);
  }

}


void
on_button_generate_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{

  glb_win_misc = create_dialog_password_gen();
  fpm_gpw_start_screen(glb_win_misc);
  gtk_widget_show(glb_win_misc);

}

void
on_button_gen_generate_now_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
  fpm_gpw_fillin_password(glb_win_misc);
}


void
on_button_gen_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkEntry *entry1, *entry2;
  gchar* text;

  entry1 = GTK_ENTRY(lookup_widget(glb_win_misc, "entry_gen_password"));
  entry2 = GTK_ENTRY(lookup_widget(glb_win_edit, "entry_password"));

  text = gtk_entry_get_text(entry1);
  if (strcmp(text, "")) gtk_entry_set_text(entry2, text);

  gtk_widget_destroy(glb_win_misc);
}


void
on_button_gen_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(glb_win_misc);
}


void
on_entry_password_activate             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  fpm_check_password();
}


void
on_button_cpw_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  fpm_set_password();
}


void
on_button_cpw_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  if(old_context == NULL)
  {
    /* We must be running for the first time.  Cancel quits. */
    gtk_main_quit();
  }
  else
  {
    /* User is canceling from changing a password.  Just close the screen. */
    gtk_widget_destroy(glb_win_misc);
  }
}



void
on_copy_pass_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (glb_edit_data != NULL)
    fpm_select_password(glb_edit_data, TRUE);
  else
    gnome_ok_dialog("Please select a row.\n");
}


void
on_copy_user_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (glb_edit_data != NULL)
    fpm_select(glb_edit_data->user, TRUE);
  else
    gnome_ok_dialog("Please select a row.\n");
}


void
on_item_password_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    glb_win_misc = create_dialog_cpw();
    gtk_widget_show(glb_win_misc);
}


void
on_button_prefs_ok_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  fpm_prefs_save_launcher();
}


void
on_button_prefs_cancel_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(glb_win_misc);
}

void
on_item_delete_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (glb_edit_data != NULL)
  {
    gnome_question_dialog_modal("Are you sure you want to delete this item?",
	fpm_dialog_answer_delete, NULL);
  }
  else
    gnome_ok_dialog("Please select a row.\n");

}

gboolean
on_dialog_prefs_destroy_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  
  return FALSE;
}


void
on_dialog_prefs_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_set_sensitive(glb_win_app, TRUE);
}

