/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DEFS_H
#define DEFS_H
#include <stdio.h>
#include "iostream"
#include <cassert>
#include <limits.h>
#include <float.h>

using std::cout;

template <class T>
inline void zap(T & x)
{
        {assert(x != NULL);}
        delete x;
        x = NULL;
}

template <class T>
inline void zaparr(T & x)
{
         {assert(x != NULL);}
     delete [] x;
     x = NULL;
}
#define RELEASE_NO "0.6.1.1alpha"
#define RELEASE_NAME "Freecycle 0.6.1.1alpha"
static const int RTTI_BEATLINE=1001;
static const int RTTI_BPMLINE=1002;
static const int RTTI_LOOPMARKER=1003;
static const int RTTI_MEASUREMARKER=1004;
static const int RTTI_VALUELINE=1005;
static const int RTTI_DRAWINGLINE=1006;
static const int RTTI_POLYLINE=1007;
static const int RTTI_SPLINELINE=1008;
static const int RTTI_LOCKEDBEATRECT=1009;
static const int RTTI_LADSPAVALUERECT=1010;
static const int RTTI_KEYBOARDRECT=1011;
static const int RTTI_PITCHSHIFTRECT=1012;


static const double BEAT_DISTANCE_TRESHOLD=128;

static const int MIDI_INPUT_EVENT=2000;
static const int PLAY_POSITION_CHANGED_EVENT=2001;


#endif


