/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MONOTOSTEREOSPLITTER_H
#define MONOTOSTEREOSPLITTER_H

#include <qobject.h>
#include "defs.h"
#include "customeffect.h"

/**
@author Predrag Viceic
*/
class MonoToStereoSplitter : public CustomEffect
{
Q_OBJECT
public:
    MonoToStereoSplitter(QObject *parent = 0, const char *name = 0);

    ~MonoToStereoSplitter();
    void process(long _length);
    void init(long _bufferLength);
    void setOutputL_P(float* _outL);
    void setOutputR_P(float* _outR);
    float* getInput_P();
    void advancePosition(long length);
    void setPosition(long position);
    void setInput_P(float*);
    float* getOutputL_P();
    float* getOutputR_P();
    QString getName();

protected:
    float* input;
    float* beginInput;
    float* outL;
    float* outR;
    float* beginOutL;
    float* beginOutR;
};

#endif
