% ATANH ATANH Inverse Hyperbolic Tangent Function
% 
% Usage
% 
% Computes the inverse hyperbolic tangent of its argument.  The general
% syntax for its use is
% 
%   y = atanh(x)
% 
% where x is an n-dimensional array of numerical type.


% Copyright (c) 2002-2007 Samit Basu
% Licensed under the GPL

function y = atanh(x)
  if (nargin == 0 || ~isnumeric(x))
    error('atanh expects a single, numeric input');
  end
  if (isinf(x))
    y = pi/2*i;
  else
    y = 0.5*log((1+x)./(1-x));
  end

  
