% SINH SINH Hyperbolic Sine Function
% 
% Usage
% 
% Computes the hyperbolic sine of the argument.
% The syntax for its use is
% 
%    y = sinh(x)
% 

% Copyright (c) 2002-2007 Samit Basu
% Licensed under the GPL

function y = sinh(x)
  if (nargin == 0 || ~isnumeric(x))
    error('sinh expects a numeric input');
  end
  y = (exp(x)-exp(-x))/2;
  
