@echo off
Rem #$Id: windowsNT-2K.bat,v 1.7 2001/05/16 23:48:15 rdesmeul Exp $
Rem 
Rem **************************************
Rem * Tunnel Server Protocol version 1.0 *
Rem * Host configuration script          *
Rem * Windows NT 4.0 is supported        *
Rem * Windows 2000 is supported          *
Rem * Script for IPv6 stack MSRipv6      *
Rem **************************************
Rem * The script suppose you have installed ../ipv6kit/*.exe to %windir%/system32
Rem * This script keeps a log

set LOG=NUL
set LOG2=NUL
if     %TSP_VERBOSE% == 2 set LOG2=CON
if not %TSP_VERBOSE% == 0 set LOG=CON

date /T > %LOG%
time /T > %LOG%

Rem ***** Script an IPv6 tunnel "on-line" **********

:begin
echo IPv4 tunnel server address configured : %TSP_SERVER_ADDRESS_IPV4% > %LOG%
ipv6.exe rtu ::/0 2/::%TSP_SERVER_ADDRESS_IPV4% pub > %LOG2%
if errorlevel 1 goto fail1
  
:second
echo IPv6 host address configured : %TSP_CLIENT_ADDRESS_IPV6% > %LOG%
ipv6.exe adu 2/%TSP_CLIENT_ADDRESS_IPV6% > %LOG2%
if errorlevel 1 goto fail2
if %TSP_HOST_TYPE% == router GOTO router_config
goto success

:router_config
echo This computer will be configured as IPv6 router and it will do router advertisements for autoconfiguration > %LOG%
echo Configuring IPv6_forwading on every internal interfaces > %LOG%
ipv6.exe ifc 2 forwards > %LOG2%
ipv6.exe ifc 3 forwards > %LOG2%
ipv6.exe ifc 4 forwards > %LOG2%
ipv6.exe ifc 5 forwards > %LOG2%
ipv6.exe ifc 6 forwards > %LOG2%
ipv6.exe ifc 7 forwards > %LOG2%
ipv6.exe ifc 8 forwards > %LOG2%

echo Configuring routing advertisement on the specified interface > %LOG%
ipv6.exe ifc %TSP_HOME_INTERFACE% advertises > %LOG2% 

echo You got the IPv6 prefix : %TSP_PREFIX%::/%TSP_PREFIXLEN% > %LOG%
echo Your network interface %TSP_HOME_INTERFACE% will advertise %TSP_PREFIX%:0001::/64 > %LOG%
ipv6.exe rtu %TSP_PREFIX%:0001::/64 %TSP_HOME_INTERFACE% publish life 86400 spl 64 > %LOG2%
if errorlevel 1 goto fail4
goto success

:fail1
Echo Failed : not possible to use IPv4 tunnel server address > %LOG%
goto end

:fail2
Echo Failed : not possible to use IPv6 host address > %LOG%
goto end

:fail4
Echo Failed : not possible to advertise the prefix %TSP_PREFIX%:0001::/64 on interface %TSP_HOME_INTERFACE% > %LOG%
goto end

:success
Echo Success ! Now, you're ready to use IPv6 connectivity to Internet IPv6
Echo Your host is configured to use this IPv6 address : %TSP_CLIENT_ADDRESS_IPV6%
if %TSP_HOST_TYPE% == router GOTO success2
goto end

:success2
Echo The tunnel server uses this IPv6 address : %TSP_SERVER_ADDRESS_IPV6%
Echo The prefix advertised is %TSP_PREFIX%:0001::/64 on interface %TSP_HOME_INTERFACE%
goto end


:end

Echo End of the script

