;;; shell.scm: provides basic shell like facility
;;; author: Anand Babu <ab@zresearch.com>
;;; copyright 2005 FreeTalk Core Team

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; this shell.scm extension will be automatically loaded thru
;;; init.scm

(define (/quit args)
  "exit freetalk"
  (ft-disconnect)
  (exit 0))
(add-command! /quit "/quit" "quit" "quit this messenger")

(define (/shell args)
  "dynamic command interface to shell facility"
  (if (= (string-length args) 0)
      (begin
	(display "Press \"C-d\" to get back to freehoo")
	(newline)
	(system "sh"))
      (system args)))

(add-command! /shell "/shell" "/shell [COMMAND] [ARGS]" "shell mode")

(define (/restart args)
  "dynamic command interface to /restart facility"
  (ft-disconnect)
  (apply execlp "freetalk" "freetalk" '()))

(add-command! /restart "/restart" "/restart" "restart freetalk")

(define (/date args)
  "dynamic command interface to /date facility"
  (if (= (string-length args) 0)
      (system "date")
      (system (string-append "date " args))))

(add-command! /date "/date" "/date [OPTIONS]" "print current date with all date OPTIONS")

