<!--
   Filename :     xml2prolog.xslt
   Author   :       Vadim Kurland
   Id       :   $Id: xml2prolog.xslt,v 1.10 2001/09/26 02:38:30 vkurland Exp $
   Description:  Converts XML representation into Prolog predicates

-->

<xsl:stylesheet version="1.0"
       xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

<xsl:output method="text"/>
<xsl:strip-space elements="*"/>

<!-- ******** Auxiliary templates *********************** -->

<xsl:template name="convert-bool">
<xsl:param name="b"/>
<xsl:choose>
 <xsl:when test="$b='False'">false</xsl:when>
 <xsl:when test="$b='True'">true</xsl:when>
 <xsl:otherwise>'<xsl:value-of select="$b"/>'</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="convert-action">
<xsl:param name="b"/>
<xsl:choose>
 <xsl:when test="$b='Accept'">accept</xsl:when>
 <xsl:when test="$b='Deny'">deny</xsl:when>
 <xsl:when test="$b='Reject'">reject</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template name="convert-direction">
<xsl:param name="b"/>
<xsl:choose>
 <xsl:when test="$b='Inbound'">inbound</xsl:when>
 <xsl:when test="$b='Outbound'">outbound</xsl:when>
 <xsl:when test="$b='Both'">both</xsl:when>
</xsl:choose>
</xsl:template>

<!-- ******** Interface ******************************** -->
<xsl:template match="Interface">
<xsl:variable name="fw_id" select="../@id"/>
<xsl:variable name="dyn">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@dyn"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="ext">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@ext"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="addr" select="@address"/>
<xsl:variable name="a">
<xsl:choose>
  <xsl:when test="$dyn='true'">0,0,0,0</xsl:when>
  <xsl:otherwise><xsl:value-of select="translate($addr,'.',',')"/></xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="nm" select="@netmask"/>
<xsl:variable name="n">
<xsl:choose>
  <xsl:when test="$dyn='true'">0,0,0,0</xsl:when>
  <xsl:otherwise><xsl:value-of select="translate($nm,'.',',')"/></xsl:otherwise>
</xsl:choose>
</xsl:variable>
interface('<xsl:value-of select="@id"/>',  '<xsl:value-of select="@name"/>',  '<xsl:value-of select="$fw_id"/>',  [<xsl:value-of select="$a"/>],  [<xsl:value-of select="$n"/>],  <xsl:value-of select="$dyn"/>,  <xsl:value-of select="$ext"/> ).<xsl:apply-templates/></xsl:template>

<!-- ******** FirewallOption  *************************** -->
<xsl:template match="Firewall/FirewallOptions/Option">
<xsl:variable name="fw_id" select="../../@id"/>
<xsl:variable name="val">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="node()"/>
  </xsl:call-template>
</xsl:variable>
firewalloption('<xsl:value-of select="@name"/>','<xsl:value-of select="$fw_id"/>',<xsl:value-of select="$val"/> ).</xsl:template>

<!-- ******** PolicyRuleOption  ************************* -->
<xsl:template match="Firewall/Policy/PolicyRule/PolicyRuleOptions/Option">
<xsl:variable name="rule_id" select="../../@id"/>
<xsl:variable name="val">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="node()"/>
  </xsl:call-template>
</xsl:variable>
policyruleoption('<xsl:value-of select="@name"/>','<xsl:value-of select="$rule_id"/>',<xsl:value-of select="$val"/> ).</xsl:template>

<!-- ******** PolicyRuleOption  ************************* -->
<xsl:template match="Firewall/Interface/InterfacePolicy/PolicyRule/PolicyRuleOptions/Option">
<xsl:variable name="rule_id" select="../../@id"/>
<xsl:variable name="val">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="node()"/>
  </xsl:call-template>
</xsl:variable>
policyruleoption('<xsl:value-of select="@name"/>','<xsl:value-of select="$rule_id"/>',<xsl:value-of select="$val"/> ).</xsl:template>


<!-- ******** Src, Dst, Srv  **************************** -->
<xsl:template name="src">
<xsl:variable name="neg">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@neg"/>
  </xsl:call-template>
</xsl:variable>[ <xsl:for-each select="ObjectRef">'<xsl:value-of select="@ref"/>'<xsl:if test="position()!=last()">, </xsl:if></xsl:for-each> ], <xsl:value-of select="$neg"/>, </xsl:template>

<xsl:template name="dst">
<xsl:variable name="neg">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@neg"/>
  </xsl:call-template>
</xsl:variable>[ <xsl:for-each select="ObjectRef">'<xsl:value-of select="@ref"/>'<xsl:if test="position()!=last()">, </xsl:if></xsl:for-each> ], <xsl:value-of select="$neg"/>, </xsl:template>

<xsl:template name="srv">
<xsl:variable name="neg">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@neg"/>
  </xsl:call-template>
</xsl:variable>[ <xsl:for-each select="ServiceRef">'<xsl:value-of select="@ref"/>'<xsl:if test="position()!=last()">, </xsl:if></xsl:for-each> ], <xsl:value-of select="$neg"/>, </xsl:template>


<!-- ******** PolicyRule  ****************************** -->
<!--
 PolicyRule:           id, fw_id, num, src, src_neg, dst, dst_neg, srv, srv_neg, action, log
-->
<xsl:template match="Firewall/Policy/PolicyRule">
<xsl:variable name="log">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@log"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="act">
  <xsl:call-template name="convert-action">
    <xsl:with-param name="b" select="@action"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="fw_id" select="../../@id"/>
policyRule('<xsl:value-of select="@id"/>','<xsl:value-of select="$fw_id"/>', '<xsl:value-of select="@position"/>',<xsl:for-each select="Src"><xsl:call-template name="src"/></xsl:for-each><xsl:for-each select="Dst"><xsl:call-template name="dst"/></xsl:for-each><xsl:for-each select="Srv"><xsl:call-template name="srv"/></xsl:for-each><xsl:value-of select="$act"/>, <xsl:value-of select="$log"/> ).</xsl:template>

<!-- ******** InterfacePolicyRule  ********************* -->
<!--
 InterfacePolicyRule:  id, iface_id, num, src, src_neg, dst, dst_neg, srv, srv_neg, action, log
-->

<xsl:template match="Firewall/Interface/InterfacePolicy/PolicyRule">
<xsl:variable name="log">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@log"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="act">
  <xsl:call-template name="convert-action">
    <xsl:with-param name="b" select="@action"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="dir">
  <xsl:call-template name="convert-direction">
    <xsl:with-param name="b" select="@direction"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="iface_id" select="../../@id"/>
interfacepolicyrule('<xsl:value-of select="@id"/>', '<xsl:value-of select="$iface_id"/>', '<xsl:value-of select="@position"/>', <xsl:value-of select="$dir"/>,<xsl:for-each select="Src"><xsl:call-template name="src"/></xsl:for-each><xsl:for-each select="Dst"><xsl:call-template name="dst"/></xsl:for-each><xsl:for-each select="Srv"><xsl:call-template name="srv"/></xsl:for-each><xsl:value-of select="$act"/>, <xsl:value-of select="$log"/> ).</xsl:template>

<!-- ******** AnyNetwork  ***************************** -->
<xsl:template match="AnyNetwork">
anynetwork('<xsl:value-of select="@id"/>', '<xsl:value-of select="@name"/>' ).</xsl:template>

<!-- ******** AnyIPService  *************************** -->
<xsl:template match="AnyIPService">
anyipservice('<xsl:value-of select="@id"/>', '<xsl:value-of select="@name"/>' ).</xsl:template>

<!-- ******** AnyInterval  **************************** -->
<xsl:template match="AnyInterval">
anyinterval('<xsl:value-of select="@id"/>', '<xsl:value-of select="@name"/>' ).</xsl:template>

<xsl:template match="Option"></xsl:template>

<!-- ******** Firewall     **************************** -->
<xsl:template match="Firewall">
<xsl:variable name="addr" select="@address"/>
<xsl:variable name="a" select="translate($addr,'.',',')"/>
firewall('<xsl:value-of select="@id"/>', '<xsl:value-of select="@name"/>', [<xsl:value-of select="$a"/>] ).<xsl:apply-templates/></xsl:template>

<!-- ******** Host         **************************** -->
<xsl:template match="ObjectGroup/Host">
<xsl:variable name="addr" select="@address"/>
<xsl:variable name="a" select="translate($addr,'.',',')"/>
host('<xsl:value-of select="@id"/>', '<xsl:value-of select="@name"/>', [<xsl:value-of select="$a"/>] ).</xsl:template>

<!-- ******** Network      **************************** -->
<xsl:template match="ObjectGroup/Network">
<xsl:variable name="addr" select="@address"/>
<xsl:variable name="a" select="translate($addr,'.',',')"/>
<xsl:variable name="nm" select="@netmask"/>
<xsl:variable name="n" select="translate($nm,'.',',')"/>
network('<xsl:value-of select="@id"/>','<xsl:value-of select="@name"/>', [<xsl:value-of select="$a"/>], [<xsl:value-of select="$n"/>] ).</xsl:template>

<!-- ******** ICMPService  **************************** -->
<xsl:template match="ICMPService">
icmpservice('<xsl:value-of select="@id"/>', '<xsl:value-of select="@name"/>', '<xsl:value-of select="@code"/>', '<xsl:value-of select="@type"/>' ).</xsl:template>

<!-- ******** IPService    **************************** -->
<xsl:template match="IPService">
<xsl:variable name="fragm">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@fragm"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="lsrr">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@lsrr"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="rr">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@rr"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="short_fragm">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@short_fragm"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="ssrr">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@ssrr"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="ts">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@ts"/>
  </xsl:call-template>
</xsl:variable>
ipservice('<xsl:value-of select="@id"/>', '<xsl:value-of select="@name"/>', '<xsl:value-of select="@protocol_num"/>', <xsl:value-of select="$fragm"/>, <xsl:value-of select="$lsrr"/>, <xsl:value-of select="$rr"/>, <xsl:value-of select="$short_fragm"/>, <xsl:value-of select="$ssrr"/>, <xsl:value-of select="$ts"/> ).</xsl:template>

<!-- ******** TCPService   **************************** -->
<xsl:template match="TCPService">
<xsl:variable name="syn_flag">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@syn_flag"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="ack_flag">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@ack_flag"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="fin_flag">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@fin_flag"/>
  </xsl:call-template>
</xsl:variable>
<xsl:variable name="rst_flag">
  <xsl:call-template name="convert-bool">
    <xsl:with-param name="b" select="@rst_flag"/>
  </xsl:call-template>
</xsl:variable>
tcpservice('<xsl:value-of select="@id"/>',  '<xsl:value-of select="@name"/>',  '<xsl:value-of select="@src_range_start"/>',  '<xsl:value-of select="@src_range_end"/>',  '<xsl:value-of select="@dst_range_start"/>',  '<xsl:value-of select="@dst_range_end"/>',  <xsl:value-of select="$syn_flag"/>, <xsl:value-of select="$ack_flag"/>, <xsl:value-of select="$fin_flag"/>, <xsl:value-of select="$rst_flag"/> ).</xsl:template>

<!-- ******** UDPService   **************************** -->
<xsl:template match="UDPService">
udpservice('<xsl:value-of select="@id"/>', '<xsl:value-of select="@name"/>', '<xsl:value-of select="@src_range_start"/>', '<xsl:value-of select="@src_range_end"/>', '<xsl:value-of select="@dst_range_start"/>', '<xsl:value-of select="@dst_range_end"/>' ).</xsl:template>

<!-- ******** CustomService  ************************** -->
<xsl:template match="CustomService/CustomServiceCommand">
<xsl:choose>
<xsl:when test="@platform='Undefined'"/>
<xsl:otherwise>
customservice('<xsl:value-of select="../@id"/>', '<xsl:value-of select="../@name"/>', '<xsl:value-of select="@platform"/>','<xsl:value-of select="node()"/>' ).</xsl:otherwise>
</xsl:choose></xsl:template>


<!-- ******** ObjectGroup   *************************** -->
<xsl:template match="ObjectGroup/ObjectRef">
objectgroup('<xsl:value-of select="../@id"/>', '<xsl:value-of select="../@name"/>', '<xsl:value-of select="@ref"/>' ).</xsl:template>

<!-- ******** ServiceGroup   ************************** -->
<xsl:template match="ServiceGroup/ServiceRef">
servicegroup('<xsl:value-of select="../@id"/>', '<xsl:value-of select="../@name"/>', '<xsl:value-of select="@ref"/>' ).</xsl:template>

<!-- ******** IntervalGroup   ************************* -->
<xsl:template match="IntervalGroup/IntervalRef">
servicegroup('<xsl:value-of select="../@id"/>', '<xsl:value-of select="../@name"/>', '<xsl:value-of select="@ref"/>' ).</xsl:template>

<xsl:template match="FWObjectDatabase">
<xsl:text>
%
% Predicates:
%
% AnyNetwork:       id, name
% AnyIPService:     id, name
% AnyInterval:      id, name
%
% Host:             id, name, address
% Firewall:         id, name, address
% Network:          id, name, address, netmask
%
% ObjectGroup:      id, name, ref
% ServiceGroup:     id, name, ref
% IntervalGroup:    id, name, ref
%
%  ICMPService:     id, name, code, type
%  IPService:       id, name, protocol_num, fragm, lsrr, rr, short_fragm, ssrr, ts
%  TCPService:      id, name, src_range_start, src_range_end, dst_range_start, dst_range_end, syn_flag, ack_flag, fin_flag, rst_flag
%  UDPService:      id, name, src_range_start, src_range_end, dst_range_start, dst_range_end
%  CustomService:   id, name, platform, command
%
% Interface:        id, name, fw_id, address, netmask, dyn, ext
% FirewallOption:       name, fw_id, value
%
% PolicyRule:            id, fw_id   , num,            src, src_neg, dst, dst_neg, srv, srv_neg, action, log
% InterfacePolicyRule:   id, iface_id, num, direction, src, src_neg, dst, dst_neg, srv, srv_neg, action, log
%
</xsl:text>


<xsl:apply-templates/>

<!--
<xsl:apply-templates mode="firewall"/>
<xsl:apply-templates mode="interface"/>
<xsl:apply-templates mode="firewalloption"/>
<xsl:apply-templates mode="policyruleoption"/>
<xsl:apply-templates mode="policyrule"/>
<xsl:apply-templates mode="interfacepolicyrule"/>
-->


<!--
<xsl:for-each select="ObjectGroup">
  <xsl:apply-templates mode="firewall"/>
</xsl:for-each>

<xsl:for-each select="ObjectGroup/Firewall">
  <xsl:apply-templates mode="interface"/>
</xsl:for-each>

<xsl:for-each select="ObjectGroup/Firewall/FirewallOptions/Option">
  <xsl:apply-template mode="firewalloption"/>
</xsl:for-each>
-->

</xsl:template>

</xsl:stylesheet>


