/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP40Dialog.hh,v 1.16 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _DISCOVERYDRUIDP40DIALOG_HH
#  include "DiscoveryDruidP40Dialog_glade.hh"
#  define _DISCOVERYDRUIDP40DIALOG_HH
#include "glademm_support.hh"

#include "fwbuilder/IPAddress.hh"

#include "TableOfObjectsWithTypeChoice.hh"

#include "ObjectDescriptor.hh"

#include <vector>

class DiscoveryDruidP40Dialog : public DiscoveryDruidP40Dialog_glade
{   
        
    friend class DiscoveryDruidP40Dialog_glade;

    void on_select_all_clicked();
    void on_unselect_all_clicked();
    void on_filter_clicked();
    void on_remove_filter_clicked();
    void on_selection_changed();

    TableOfObjectsWithTypeChoice *tbl;

    vector<ObjectDescriptor>   all_hosts;

    vector<string>             type_choices;

//    void newObject( const string& where_id , const string& type, 
//		    const ObjectDescriptor& od);

    public:

    DiscoveryDruidP40Dialog();

    void prepare();

    void fillListOfObjects(const vector<ObjectDescriptor>& ,
			   const string& domain,bool fqdn=true);
    void clearList();

    void createObjects();
    void addTypeChoice(const string& _type);

};
#endif
