/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP70Dialog.cc,v 1.20 2001/12/19 06:47:43 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "DiscoveryDruidP70Dialog.hh"

#include "FWObjectDatabaseGUI.hh"
#include "fwbuilder/Network.hh"
#include "fwbuilder/Group.hh"

#include "main_window.hh"

#include "FilterDialog.hh"

#include "SimpleProgressDialog.hh"

#include "glademm_support.hh"

#include <unistd.h>


using namespace libfwbuilder;


DiscoveryDruidP70Dialog::DiscoveryDruidP70Dialog()
{
    p70_txt_1->set_line_wrap(true);
    tbl=NULL;

    on_selection_changed();
}

void DiscoveryDruidP70Dialog::prepare()
{
    scrolledwindow->grab_focus();
}

void DiscoveryDruidP70Dialog::on_selection_changed()
{
    int   n;

    n=(tbl)?tbl->getNumOfSelected():0;
    char  s[80];
    sprintf(s,"Selected:\n  %d object",n);
    if (n==0 || n>1) strcat(s,"s");

    table38->remove( *number_of_selected_objects );

    number_of_selected_objects=manage( new Gtk::Label(s) );
    number_of_selected_objects->set_alignment(0, 0);
    number_of_selected_objects->set_padding(0, 10);
    widgetModifyFont (number_of_selected_objects,
		      "-*-helvetica-bold-o-*-*-14-*-*-*-*-*-*-*");

    table38->attach(*number_of_selected_objects, 1, 2, 8, 9, GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);

    number_of_selected_objects->show();
}


void DiscoveryDruidP70Dialog::clearList()
{
    scrolledwindow->remove();
    tbl=NULL;

    all_nets.clear();
}

void  DiscoveryDruidP70Dialog::fillListOfNetworks( const vector<IPNetwork>& nets )
{
    int               row;

    clearList();

    tbl   = manage( new TableOfObjects( nets.size() ) );

    SimpleProgressDialog* progr=new SimpleProgressDialog();

    progr->setTitle("Filling the table... ");
    progr->setProgressBarRange(0.0 , gfloat(nets.size()) );

    progr->show();

    while ( gtk_events_pending() )
	gtk_main_iteration();

    vector<IPNetwork>::const_iterator m;
    for (row=0,m=nets.begin(); m!=nets.end(); ++row,++m) {

	progr->setProgressBarValue( gfloat(row) );

	all_nets.push_back( (*m) );

	IPAddress  a    = (*m).getAddress();
	Netmask    nm   = (*m).getNetmask();
	string     name = "n-"+a.toString();
	string     addr = a.toString() + "/" + nm.toString();

/* using address as unique ID to reference object in the table widget */
	tbl->addObject(row , addr, name , addr );
    }

    progr->hide();
    delete progr;

    tbl->selectAll();

    scrolledwindow->add_with_viewport( *tbl );

    on_selection_changed();

    tbl->show_all();

    tbl->changed.connect(SigC::slot(this, 
			   &DiscoveryDruidP70Dialog::on_selection_changed));
}


void DiscoveryDruidP70Dialog::on_select_all_clicked()
{
    tbl->selectAll();
}

void DiscoveryDruidP70Dialog::on_unselect_all_clicked()
{
    tbl->unselectAll();
}

void DiscoveryDruidP70Dialog::on_filter_clicked()
{
    FilterDialog *fd=new FilterDialog( tbl->getAddressFilter(),
				       tbl->getNameFilter() );
    if ( fd->run() ) {
	    
	tbl->filter( fd->getAddressFilter() , fd->getNameFilter() );
    }
    delete fd;

    if (tbl->isFilterActive())
	tbl_frame->set_label("New Objects (Filter active):");
    else
	tbl_frame->set_label("New Objects: ");
}

void DiscoveryDruidP70Dialog::on_remove_filter_clicked()
{
    tbl->filter("","");
    tbl_frame->set_label("New Objects: ");
}

void DiscoveryDruidP70Dialog::createObjects()
{
    SimpleProgressDialog* progr=new SimpleProgressDialog();

    progr->setTitle("Creating Networks ");
    progr->setProgressBarRange(0.0 , gfloat(all_nets.size()) );

    progr->show();

    while ( gtk_events_pending() )
	gtk_main_iteration();

    for (unsigned row=0; row<all_nets.size(); ++row) {

	progr->setProgressBarValue( gfloat(row) );

	IPAddress  a    = all_nets[row].getAddress();
	Netmask    nm   = all_nets[row].getNetmask();
	string     addr = a.toString() + "/" + nm.toString();

	if (tbl->isObjectChecked(addr)) {
	    Network *net=dynamic_cast<Network*>( FWObjectDatabaseGUI::newNetwork() );
	    assert(net!=NULL);
	    net->setAddress(a);
	    net->setNetmask(nm);
	    net->setName( tbl->getObjectName(addr) );
	}
    }

//    sleep(1);

    progr->hide();

    delete progr;
}

void DiscoveryDruidP70Dialog::newNet(string name, IPNetwork& net )
{
/*
    FWObject *o=FWObjectDatabase::db->create(Network::TYPENAME);

    o->setName(name);
    ((Network*)o)->setData(net);

    FWObjectDatabase::db->addAt(FWObjectDatabase::db->std.NetworksId, o);

    FWObject *s=FWObjectDatabase::db->create(Network::TYPENAME);
    *s = *o;
    FWObjectDatabaseGUI::ScratchPad->addAt(FWObjectDatabase::db->std.NetworksId,
					s);

    FWObjectBook *book=(FWObjectBook*)glademm_get_Widget("FWObjectBook");
    assert (book!=NULL);
    book->build();
*/
}

