/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: execDialog.cpp,v 1.10 2006/02/18 05:26:30 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"

#include "execDialog.h"

#include <qdir.h>
#include <qregexp.h>
#include <qtimer.h>
#include <qtextbrowser.h>
#include <qpushbutton.h>
#include <qfile.h>
#include <qfiledialog.h>

#include "FWBSettings.h"

#if defined(Q_OS_WIN32)
#  include <stdio.h>
#  include <sys/timeb.h>
#  include <time.h>
#endif

#include <iostream>

using namespace std;

execDialog::execDialog(QWidget *parent,const QStringList &args, const QString &closeButtonText)
    : execDialog_q(parent), proc(parent)
{
    output->setWordWrap( QTextEdit::NoWrap );
    res=-1;

    if (! closeButtonText.isEmpty()) buttonOk->setText(closeButtonText);

    proc.setCommunication( QProcess::Stdout|QProcess::Stderr|QProcess::DupStderr);

    connect(&proc, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
    connect(&proc, SIGNAL(processExited()),   this, SLOT(processExited()) );

    proc.clearArguments();

    proc.setArguments( args );

    stopButton->hide();
    saveLogButton->hide();
}

void execDialog::readFromStdout()
{
//    output->append( proc.readStdout() );
    output->moveCursor( QTextEdit::MoveEnd , false );
    output->insert( proc.readStdout() );
}

void execDialog::stopProcess()
{
    proc.tryTerminate();
    QTimer::singleShot( 1000, &proc, SLOT( kill() ) );
}

void execDialog::processExited()
{
    stopButton->hide();
    saveLogButton->show();
    buttonOk->setEnabled( true );
    buttonOk->setFocus();
    res=proc.exitStatus();
}

int execDialog::run()
{
    output->append( proc.arguments().join(" ") );
    output->append("\n");

    if ( !proc.start() )
    {
        output->append( tr("Error: Failed to start program") );
        return exec();
    }
    saveLogButton->hide();
    stopButton->show();    
    stopButton->setFocus();
    buttonOk->setEnabled( false );
    exec();
    return res;
}
void execDialog::saveLog()
{
    QString dir;
    dir=st->getWDir();
    if (dir.isEmpty())  dir=st->getOpenFileDir();
    if (dir.isEmpty())  dir="~";
    
    QString s = QFileDialog::getSaveFileName(
                    dir,
                    "Text file (*.txt)",
                    this,
                    "save file dialog",
                    "Choose a file" );
    
    
    if (!s.isEmpty())
    {
        if (s.findRev(".txt",-1,false)==-1)
        {
            s+=".txt";
        }
        QFile f(s);
        if (f.open(IO_WriteOnly))
        {
            QTextStream (&f) << output->text();
            f.close();
        }
    }    
}
