/* 

                          Firewall Builder

                 Copyright (C) 2006 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: instOptionsDialog.cpp,v 1.6 2007/05/11 04:33:29 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"
#include "definitions.h"

#include "instOptionsDialog.h"
#include "instConf.h"

#include "fwbuilder/Firewall.h"

#include <qstring.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qspinbox.h>
#include <qframe.h>

#include <stdlib.h>

using namespace std;
using namespace libfwbuilder;

    
instOptionsDialog::instOptionsDialog(QWidget *parent, instConf *_cnf) :
    instOptionsDialog_q(parent)
{
    cnf = _cnf;

    QString platform = cnf->fwobj->getStr("platform").c_str();

    pwd->setEchoMode( QLineEdit::Password );
    epwd->setEchoMode( QLineEdit::Password );

    QString fwname = QString::fromUtf8(cnf->fwobj->getName().c_str());
    if (!cnf->batchInstall)
        dialogTitleLine->setText(
            QString("<p align=\"center\"><b><font size=\"+2\">")+
            tr("Install options for firewall '%1'").arg(fwname)+
            QString("</font></b></p>")
        );

    uname->setFocus();
    uname->setText( cnf->user );
    incr->setChecked( cnf->incremental );
    test->setChecked( cnf->dry_run );
    backupConfigFile->setText( cnf->backup_file );
    saveDiff->setChecked( cnf->save_diff );
    saveStandby->setChecked( cnf->saveStandby );
    altAddress->setText( cnf->maddr );
    quiet->setChecked( cnf->quiet );
    verbose->setChecked( cnf->verbose );
    stripComments->setChecked( cnf->stripComments );
    compressScript->setChecked( cnf->compressScript );
    copyFWB->setChecked( cnf->copyFWB );
    testRun->setChecked( cnf->testRun );
    rollback->setChecked( cnf->rollback );
    rollbackTime->setValue( cnf->rollbackTime );
    cancelRollbackIfSuccess->setChecked( cnf->cancelRollbackIfSuccess );
    
    if (platform=="pix" || platform=="fwsm" || platform=="iosacl")
    {
        copyFWB->hide();

        // Hide elements of installOptions dialog for which we do not have commands
        QString cmd = cnf->getCmdFromResource("schedule_rollback");
        // option "schedule_rollback" is currently used to control rollback
        // behavior only for pix, fwsm and ios
        if (cmd.isEmpty())
        {
            rollback->hide();
            rollbackTime->hide();
            rollbackTimeUnit->hide();
            cancelRollbackIfSuccess->hide();
        }

        if (platform=="iosacl")
        {
            PIXgroupBox->hide();
/*
            incr->hide();
            test->hide();
            saveStandby->hide();
            backupConfigFile->hide();
            backupConfigFileLbl->hide();
*/
        }

        if (cnf->batchInstall)
        {
            backupConfigFile->hide();
            backupConfigFileLbl->hide();
        }

    } else
    {
        epwd->hide();
        PIXgroupBox->hide();
        // cancelling rollback at the end of activation is currently
        // only supported on pix,fwsm and ios
        cancelRollbackIfSuccess->hide();
    }



/* hide anyway, diff does not work for pix 6.3(3) */
    //dlg->hideOption( dlg->saveDiff );
    saveDiff->hide();

    //progressBar->hide();
    //dlg->hideOption( dlg->stripComments );
    stripComments->hide(); 
    //dlg->compressScript->hide();

    //if (platform=="pix" || platform=="fwsm")
    //{
    //    progressBar->show();
    //    stripComments->show();
    //}

    if (cnf->fwobj->getStr("host_OS")!="linksys")
    {
        compressScript->hide();
        //dlg->hideOption( dlg->compressScript );
    }

    PIXgroupBox->adjustSize();
    generalOptionsBox->adjustSize();
    testOptionsBox->adjustSize();
    mainBox->adjustSize();

    adjustSize();

    if (fwbdebug)
    {
        QSize sz = sizeHint();
        qDebug(QString("instOptionsDialog:  sizeHint: %1x%2").arg(sz.width()).arg(sz.height()));
        sz = minimumSizeHint();
        qDebug(QString("instOptionsDialog:  minimumSizeHint: %1x%2").
               arg(sz.width()).arg(sz.height()));

        QRect bfr;

        bfr = titleFrame->geometry();
        qDebug(QString("instOptionsDialog:  titleFrame: top=%1 bottom=%2").
               arg(bfr.top()).arg(bfr.bottom()));
        bfr = buttonsFrame->geometry();
        qDebug(QString("instOptionsDialog:  buttonsFrame: top=%1 bottom=%2").
               arg(bfr.top()).arg(bfr.bottom()));
    }

    //resize( minimumSizeHint() );
    
    //adjustSize();

    //dlg->setFixedHeight( dlg->minimumSizeHint().height() );
}


QString instOptionsDialog::getUName() { return uname->text(); }
QString instOptionsDialog::getPWD()   { return pwd->text();   }
QString instOptionsDialog::getEPWD()  { return epwd->text();  }

