/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/wait.h>
#include <unistd.h>
#include "gettext.h"
#include "widgets.h"
#include "allocate.h"
#include "show_info.h"

extern int MAX_READ_POPEN;


void run_command_show_err(gchar *command)
{
    FILE *fp;
    char *line, *info;
    int once=0;
    
    if((fp=popen(command, "r"))==NULL)
    {
	perror("popen");
	return;
    }
    else
      {
	  line = allocate(MAX_READ_POPEN+2);
	  info = allocate(MAX_READ_POPEN+2);
	  while(fgets(line, MAX_READ_POPEN, fp)!=NULL)
	  {
	     strcat(info, line);
	     /* Show the error line a bit more clearly */
	     if( strstr(line, "visit") && ! once )
	     {
	        once = 1;
		strcat(info, "\n");
	     }
	  }
	  pclose(fp);
	  show_info(info);
	  free(info);
	  free(line);
      }
}

int run_command(gchar *command)
{
    FILE *fp;
    int status=0, exit_status=0;
    
    if((fp=popen(command, "w"))==NULL)
    {
	perror("popen");
	return 0;
    }
    status = pclose(fp);

    exit_status = WEXITSTATUS(status);
    
    if( exit_status == 1 )
      exit_status = 0;
    else
      exit_status = 1;

    return exit_status;
}

void init_start(struct w *widgets)
{
    gchar *cmd;
    cmd = g_strdup_printf("%s", SYSINIT_START_CMD);

    if( strlen(cmd) > 4 )
    {
	if( ! run_command(cmd) )
	{
	    run_command_show_err(cmd);
	}
    }
    if( cmd!=NULL )
      g_free(cmd);
}

void init_stop(struct w *widgets)
{
    gchar *cmd;
    cmd = g_strdup_printf("%s", SYSINIT_STOP_CMD);

    if( strlen(cmd) > 4 )
    {
	if( ! run_command(cmd) )
	{
	    run_command_show_err(cmd);
	}
    }
    if( cmd!=NULL )
      g_free(cmd);
}

int file_exists(char *infile)
{
    FILE *fp;
    if((fp=fopen(infile, "r"))==NULL)
      return 0;

    fclose(fp);
    return 1;
}


char * remove_semicolon(char *input)
{
    int y;
    gchar *info;
    if( strlen(input)>1000 )
    {
        info = g_strdup_printf(_("This settings value is too long:\n%s\n"), input);
        show_info(info);
        g_free(info);
	return input; /* Itll never'tm get here */
    }
    /* Delete any ; (semicolon) and everything behind it */
    for(y=0; y<strlen(input)-1; y++)
    if( input[y]==';' )
        input[y]='\0';
    
    return input;
}


char * isolate_setting(char *input)
{
    int y, z, begin=0, end=0, isolated=0;
    char *isol;
    gchar *info;
    
    if( strlen(input)>1000 )
    {
        info = g_strdup_printf(_("This settings value is too long:\n%s\n"), input);
        show_info(info);
        g_free(info);
	return input;
    }

    isol = allocate(strlen(input)+3);
    
    /* If it has a " char get everything in between */    
    for(y=0; y<strlen(input)-1; y++)
    if( input[y]=='"' )
    {
        begin=y+1;

        for(z=strlen(input)-1; z>y; z--)
	if( input[z]=='"' )
	{
	    end=z-1; isolated=1;
	    break;
	}
    
	if( isolated )
	  break;
    }

    if( isolated )
    {
	strncat(isol, &input[begin], end-begin+1);
	/* This is a shorter string */
	sprintf(input, "%s", isol);
    }

    free(isol);

    return input;
}


void add_missing_values(gchar *conf)
{
    /* Adds missing values to dhcpd.conf. If dhcpd.conf
       is missing itll create it and add the values. */

    FILE *fp;
    long conf_size;
    char *line, *orig_conf;
    int global_end = 0;

    gchar *value1, *value2, *value3, *value4, *value5, *value6;
    int ddns_update_style = 0;
    int ddns_updates = 0;
    int opt_t150 = 0;
    int client_updates = 0;
    int one_lease_per_client = 0;
    int bootp = 0;
    
    /* Length of 'dhcpd.conf' */
    if( strlen(conf) < 10 )
    {
       printf("Add missing values: conf path too short.\n");
       return;
    }

    if( file_exists(conf) )
    {
	if((fp=fopen(conf, "r"))==NULL)
	{
    	    printf("Error opening: %s\n", conf);  
    	    return;
	}
    }
    else
      {
	  if((fp=fopen(conf, "w+"))==NULL)
	  {
    	      printf("Error opening: %s\n", conf);  
    	      return;
	  }
      }

    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);
    
    line = allocate(conf_size+1);
    orig_conf = allocate(conf_size+1);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	strcat(orig_conf, line);

	/* We only care about the global values */
	if( strstr(line, "subnet") || strstr(line, "host") )
	  global_end = 1;

	if( ! global_end && strstr(line, "ddns-update-style") && ! strstr(line, "#") )
	  ddns_update_style = 1;

	if( ! global_end && strstr(line, "ddns-updates") && ! strstr(line, "#") )
	  ddns_updates = 1;

	if( ! global_end && strstr(line, "option T150 code 150 = string;") && ! strstr(line, "#") )
	  opt_t150 = 1;

	if( ! global_end && strstr(line, "client-updates;") && ! strstr(line, "#") )
	  client_updates = 1;

	if( ! global_end && strstr(line, "one-lease-per-client") && ! strstr(line, "#") )
	  one_lease_per_client = 1;

	if( ! global_end && strstr(line, "bootp;") && ! strstr(line, "#") )
	  bootp = 1;
    }
    fclose(fp);

    free(line);

    /* We have everyting required, return */
    if( ddns_update_style && opt_t150 && client_updates 
    &&  one_lease_per_client && bootp && ddns_updates )
    {
	free(orig_conf);
        return;
    }
      
    if((fp=fopen(conf, "w+"))==NULL)
    {
       printf("Error opening: %s\n", conf);  
       return;
    }

    value1 = g_strdup_printf("ddns-update-style none;\n");
    value2 = g_strdup_printf("ddns-updates off;\n");
    value3 = g_strdup_printf("option T150 code 150 = string;\n");
    value4 = g_strdup_printf("deny client-updates;\n");
    value5 = g_strdup_printf("one-lease-per-client false;\n");
    value6 = g_strdup_printf("allow bootp;\n");

    if( ! ddns_update_style )
      fputs(value1, fp);

    if( ! ddns_updates )
      fputs(value2, fp);

    if( ! opt_t150 )
      fputs(value3, fp);

    if( ! client_updates )
      fputs(value4, fp);

    if( ! one_lease_per_client )
      fputs(value5, fp);

    if( ! bootp )
      fputs(value6, fp);

    fputs(orig_conf, fp);

    fclose(fp);
    free(orig_conf);
    g_free(value1); g_free(value2); g_free(value3);
    g_free(value4); g_free(value5); g_free(value6);
}
