// ---------------------------------------------------------------------
// $Id: BruteForce.hh 149 2008-06-03 09:09:19Z daaugusto $
//
//   BruteForce.hh (created on Fri Nov 18 20:47:35 BRT 2005)
// 
//   Genetic Algorithm File Fitter (gaffitter)
//
//   Copyright (C) 2005-2008 Douglas A. Augusto
// 
// This file is part of gaffitter.
// 
// gaffitter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
// 
// gaffitter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with gaffitter; if not, see <http://www.gnu.org/licenses/>.
//
// ---------------------------------------------------------------------

#ifndef BruteForce_hh
#define BruteForce_hh

#include "../Optimizer.hh"

using namespace std;

// ---------------------------------------------------------------------
/**
 * Optimization via Brute Force search.
 */
class BruteForce: public Optimizer {
public:
   /**
    * Calls the base constructor and print some information if needed.
    */
   BruteForce(vector<SizeName>& sn, Params& p):Optimizer(sn,p) {}
   /** 
    * "Evolve" via Brute Force search.
    *
    * This search algorithm tries all possible combinations. Exponential
    * complexity (2^n, where n=|input|). This algorithm produces
    * guaranteed globally optimal solutions, but it becomes very very slow
    * when 'n' grows. Use carefully!
    */
   void Evolve();

protected:
   /** 
    * Writes some information (like algorithm name and parameters) in
    * ostream object (usually cout).
    */
   ostream& Write(ostream& s) const;

private:
   /**
    * Interface to EnumerateAndTest(int). This function initialize/reset
    * all variables used by the recursive EnumerateAndTest(int).
    */
   void EnumerateAndTest();
   /**
    * Recursively enumerate (generate) all possible candidate solutions
    * and returns the best solution.
    */
   void EnumerateAndTest(int);


   /**
    * Temporary variables used by EnumerateAndTest(int).
    */
   bool m_stop;
   Params::Size_t m_best_score;
   vector<bool> m_candidate;
};

// ---------------------------------------------------------------------

#endif
