/*
 * Gnome-biff program
 * Version:  2.6
 * Copyright (C) 2000-2001  Nicolas Rougier
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 *
 * WARNING : - Modified for getting biff argument in widget creation
 *           - Modified create_Popup function
 *           - Modified Pixmap creation in mailbox
 *
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#ifdef USE_GNOME
#  include <gnome.h>
#  include <applet-widget.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "gbiff.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <libintl.h>

GtkWidget *
create_Mailbox (Biff *biff) {
  GtkWidget *Mailbox;
  GtkWidget *MainVBox;
  GtkWidget *MailboxFrame;
  GtkWidget *MailboxTable;
  GtkWidget *TitleLabel;
  GtkWidget *ProtocolLabel;
  GtkWidget *AddressLabel;
  GtkWidget *UserLabel;
  GtkWidget *PasswordLabel;
  GtkWidget *UserEntry;
  GtkWidget *PasswordEntry;
  GtkWidget *TitleEntry;
  GtkWidget *AddressHBox;
  GtkWidget *AddressEntry;
  GtkWidget *AddressButton;
  GtkWidget *ProtocolTable;
  GSList *ProtocolTable_group = NULL;
  GtkWidget *ProtocolRadioFile;
  GtkWidget *ProtocolRadioMaildir;
  GtkWidget *ProtocolRadioPop3;
  GtkWidget *ProtocolRadioImap4;
  GtkWidget *ProtocolRadioMh;
  GtkWidget *OptionsFrame;
  GtkWidget *OptionsTable;
  GtkWidget *SoundLabel;
  GtkWidget *FontLabel;
  GtkWidget *PopupGeometryLabel;
  GtkWidget *PopTimeLabel;
  GtkWidget *PollTimeLabel;
  GtkWidget *PopupGeometryHBox;
  GtkWidget *PopupGeometryXLabel;
  GtkObject *PopupGeometryXSpin_adj;
  GtkWidget *PopupGeometryXSpin;
  GtkWidget *PopupGeometryYLabel;
  GtkObject *PopupGeometryYSpin_adj;
  GtkWidget *PopupGeometryYSpin;
  GtkWidget *OptionsLabel;
  GtkWidget *SubOptionsTable;
  GtkWidget *OptionsNoSoundCheck;
  GtkWidget *OptionsNoPopupCheck;
  GtkWidget *OptionsNoTitleCheck;
  GtkWidget *OptionsNoDateCheck;
  GtkWidget *MailPixmapLabel;
  GtkWidget *NoMailPixmapLabel;
  GtkWidget *MailEventBox;
  GtkWidget *MailPixmapFrame;
  GtkWidget *MailPixmap;
  GtkWidget *NoMailEventBox;
  GtkWidget *NoMailPixmapFrame;
  GtkWidget *NoMailPixmap;
  GtkWidget *FontButton;
  GtkObject *PollTimeSpin_adj;
  GtkWidget *PollTimeSpin;
  GtkObject *PopTimeSpin_adj;
  GtkWidget *PopTimeSpin;
  GtkWidget *SoundHBox;
  GtkWidget *SoundButton;
  GtkWidget *SoundPlayButton;
#ifndef USE_GNOME
  GtkWidget *WindowGeometryHBox;
  GtkWidget *WindowGeometryXLabel;
  GtkObject *WindowGeometryXSpin_adj;
  GtkWidget *WindowGeometryXSpin;
  GtkWidget *WindowGeometryYLabel;
  GtkObject *WindowGeometryYSpin_adj;
  GtkWidget *WindowGeometryYSpin;
  GtkWidget *WindowGeometryLabel;
#endif
  GtkWidget *ConfirmationHBox;
  GtkWidget *OkButton;
  GtkWidget *SuspendButton;
  GtkWidget *QuitButton;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  Mailbox = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (Mailbox, "Mailbox");
  gtk_object_set_data (GTK_OBJECT (Mailbox), "Mailbox", Mailbox);
  gtk_window_set_title (GTK_WINDOW (Mailbox), _("Mailbox"));
  gtk_window_set_position (GTK_WINDOW (Mailbox), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (Mailbox), FALSE, FALSE, FALSE);

  MainVBox = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (MainVBox, "MainVBox");
  gtk_widget_ref (MainVBox);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "MainVBox", MainVBox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (MainVBox);
  gtk_container_add (GTK_CONTAINER (Mailbox), MainVBox);

  MailboxFrame = gtk_frame_new (_("Mailbox"));
  gtk_widget_set_name (MailboxFrame, "MailboxFrame");
  gtk_widget_ref (MailboxFrame);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "MailboxFrame", MailboxFrame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (MailboxFrame);
  gtk_box_pack_start (GTK_BOX (MainVBox), MailboxFrame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (MailboxFrame), 3);

  MailboxTable = gtk_table_new (5, 2, FALSE);
  gtk_widget_set_name (MailboxTable, "MailboxTable");
  gtk_widget_ref (MailboxTable);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "MailboxTable", MailboxTable,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (MailboxTable);
  gtk_container_add (GTK_CONTAINER (MailboxFrame), MailboxTable);
  gtk_container_set_border_width (GTK_CONTAINER (MailboxTable), 3);
  gtk_table_set_row_spacings (GTK_TABLE (MailboxTable), 2);
  gtk_table_set_col_spacings (GTK_TABLE (MailboxTable), 5);

  TitleLabel = gtk_label_new (_("Title"));
  gtk_widget_set_name (TitleLabel, "TitleLabel");
  gtk_widget_ref (TitleLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "TitleLabel", TitleLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (TitleLabel);
  gtk_table_attach (GTK_TABLE (MailboxTable), TitleLabel, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (TitleLabel), 0, 0.5);

  ProtocolLabel = gtk_label_new (_("Protocol"));
  gtk_widget_set_name (ProtocolLabel, "ProtocolLabel");
  gtk_widget_ref (ProtocolLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "ProtocolLabel", ProtocolLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ProtocolLabel);
  gtk_table_attach (GTK_TABLE (MailboxTable), ProtocolLabel, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (ProtocolLabel), 0, 0.5);

  AddressLabel = gtk_label_new (_("Address"));
  gtk_widget_set_name (AddressLabel, "AddressLabel");
  gtk_widget_ref (AddressLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "AddressLabel", AddressLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (AddressLabel);
  gtk_table_attach (GTK_TABLE (MailboxTable), AddressLabel, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (AddressLabel), 0, 0.5);

  UserLabel = gtk_label_new (_("User"));
  gtk_widget_set_name (UserLabel, "UserLabel");
  gtk_widget_ref (UserLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "UserLabel", UserLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (UserLabel);
  gtk_table_attach (GTK_TABLE (MailboxTable), UserLabel, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (UserLabel, FALSE);
  gtk_misc_set_alignment (GTK_MISC (UserLabel), 0, 0.5);

  PasswordLabel = gtk_label_new (_("Password"));
  gtk_widget_set_name (PasswordLabel, "PasswordLabel");
  gtk_widget_ref (PasswordLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PasswordLabel", PasswordLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PasswordLabel);
  gtk_table_attach (GTK_TABLE (MailboxTable), PasswordLabel, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (PasswordLabel, FALSE);
  gtk_misc_set_alignment (GTK_MISC (PasswordLabel), 0, 0.5);

  UserEntry = gtk_entry_new ();
  gtk_widget_set_name (UserEntry, "UserEntry");
  gtk_widget_ref (UserEntry);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "UserEntry", UserEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (UserEntry);
  gtk_table_attach (GTK_TABLE (MailboxTable), UserEntry, 1, 2, 3, 4,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (UserEntry, FALSE);
  gtk_tooltips_set_tip (tooltips, UserEntry, _("User account name"), NULL);

  PasswordEntry = gtk_entry_new ();
  gtk_widget_set_name (PasswordEntry, "PasswordEntry");
  gtk_widget_ref (PasswordEntry);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PasswordEntry", PasswordEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PasswordEntry);
  gtk_table_attach (GTK_TABLE (MailboxTable), PasswordEntry, 1, 2, 4, 5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (PasswordEntry, FALSE);
  gtk_tooltips_set_tip (tooltips, PasswordEntry, _("User account password"), NULL);
  gtk_entry_set_visibility (GTK_ENTRY (PasswordEntry), FALSE);

  TitleEntry = gtk_entry_new_with_max_length (8);
  gtk_widget_set_name (TitleEntry, "TitleEntry");
  gtk_widget_ref (TitleEntry);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "TitleEntry", TitleEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (TitleEntry);
  gtk_table_attach (GTK_TABLE (MailboxTable), TitleEntry, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, TitleEntry, _("Title of the mailbox to be displayed in gnome panel and popup window"), NULL);

  AddressHBox = gtk_hbox_new (FALSE, 5);
  gtk_widget_set_name (AddressHBox, "AddressHBox");
  gtk_widget_ref (AddressHBox);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "AddressHBox", AddressHBox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (AddressHBox);
  gtk_table_attach (GTK_TABLE (MailboxTable), AddressHBox, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (AddressHBox, 158, -2);

  AddressEntry = gtk_entry_new ();
  gtk_widget_set_name (AddressEntry, "AddressEntry");
  gtk_widget_ref (AddressEntry);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "AddressEntry", AddressEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (AddressEntry);
  gtk_box_pack_start (GTK_BOX (AddressHBox), AddressEntry, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, AddressEntry, _("Address of mailbox"), NULL);

  AddressButton = gtk_button_new_with_label (_(" ... "));
  gtk_widget_set_name (AddressButton, "AddressButton");
  gtk_widget_ref (AddressButton);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "AddressButton", AddressButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (AddressButton);
  gtk_box_pack_start (GTK_BOX (AddressHBox), AddressButton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, AddressButton, _("Browse for file"), NULL);

  ProtocolTable = gtk_table_new (2, 3, FALSE);
  gtk_widget_set_name (ProtocolTable, "ProtocolTable");
  gtk_widget_ref (ProtocolTable);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "ProtocolTable", ProtocolTable,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ProtocolTable);
  gtk_table_attach (GTK_TABLE (MailboxTable), ProtocolTable, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  ProtocolRadioFile = gtk_radio_button_new_with_label (ProtocolTable_group, _("file"));
  ProtocolTable_group = gtk_radio_button_group (GTK_RADIO_BUTTON (ProtocolRadioFile));
  gtk_widget_set_name (ProtocolRadioFile, "ProtocolRadioFile");
  gtk_widget_ref (ProtocolRadioFile);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "ProtocolRadioFile", ProtocolRadioFile,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ProtocolRadioFile);
  gtk_table_attach (GTK_TABLE (ProtocolTable), ProtocolRadioFile, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, ProtocolRadioFile, _("Check if your mail is held within a local unix mail file"), NULL);

  ProtocolRadioMaildir = gtk_radio_button_new_with_label (ProtocolTable_group, _("qmail"));
  ProtocolTable_group = gtk_radio_button_group (GTK_RADIO_BUTTON (ProtocolRadioMaildir));
  gtk_widget_set_name (ProtocolRadioMaildir, "ProtocolRadioMaildir");
  gtk_widget_ref (ProtocolRadioMaildir);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "ProtocolRadioMaildir", ProtocolRadioMaildir,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ProtocolRadioMaildir);
  gtk_table_attach (GTK_TABLE (ProtocolTable), ProtocolRadioMaildir, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, ProtocolRadioMaildir, _("Check if your mail is held within a qmail-style directory"), NULL);

  ProtocolRadioPop3 = gtk_radio_button_new_with_label (ProtocolTable_group, _("pop3"));
  ProtocolTable_group = gtk_radio_button_group (GTK_RADIO_BUTTON (ProtocolRadioPop3));
  gtk_widget_set_name (ProtocolRadioPop3, "ProtocolRadioPop3");
  gtk_widget_ref (ProtocolRadioPop3);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "ProtocolRadioPop3", ProtocolRadioPop3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ProtocolRadioPop3);
  gtk_table_attach (GTK_TABLE (ProtocolTable), ProtocolRadioPop3, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, ProtocolRadioPop3, _("Check if your mail is held on a pop3 server"), NULL);

  ProtocolRadioImap4 = gtk_radio_button_new_with_label (ProtocolTable_group, _("imap4"));
  ProtocolTable_group = gtk_radio_button_group (GTK_RADIO_BUTTON (ProtocolRadioImap4));
  gtk_widget_set_name (ProtocolRadioImap4, "ProtocolRadioImap4");
  gtk_widget_ref (ProtocolRadioImap4);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "ProtocolRadioImap4", ProtocolRadioImap4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ProtocolRadioImap4);
  gtk_table_attach (GTK_TABLE (ProtocolTable), ProtocolRadioImap4, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, ProtocolRadioImap4, _("Check if your mail is held on a imap4 server"), NULL);

  ProtocolRadioMh = gtk_radio_button_new_with_label (ProtocolTable_group, _("mh"));
  ProtocolTable_group = gtk_radio_button_group (GTK_RADIO_BUTTON (ProtocolRadioMh));
  gtk_widget_set_name (ProtocolRadioMh, "ProtocolRadioMh");
  gtk_widget_ref (ProtocolRadioMh);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "ProtocolRadioMh", ProtocolRadioMh,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ProtocolRadioMh);
  gtk_table_attach (GTK_TABLE (ProtocolTable), ProtocolRadioMh, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, ProtocolRadioMh, _("Check if your mail is held within an mh-style directory"), NULL);

  OptionsFrame = gtk_frame_new (_("Options"));
  gtk_widget_set_name (OptionsFrame, "OptionsFrame");
  gtk_widget_ref (OptionsFrame);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "OptionsFrame", OptionsFrame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (OptionsFrame);
  gtk_box_pack_start (GTK_BOX (MainVBox), OptionsFrame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (OptionsFrame), 3);

  OptionsTable = gtk_table_new (9, 2, FALSE);
  gtk_widget_set_name (OptionsTable, "OptionsTable");
  gtk_widget_ref (OptionsTable);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "OptionsTable", OptionsTable,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (OptionsTable);
  gtk_container_add (GTK_CONTAINER (OptionsFrame), OptionsTable);
  gtk_container_set_border_width (GTK_CONTAINER (OptionsTable), 3);
  gtk_table_set_row_spacings (GTK_TABLE (OptionsTable), 3);
  gtk_table_set_col_spacings (GTK_TABLE (OptionsTable), 5);

  SoundLabel = gtk_label_new (_("Sound"));
  gtk_widget_set_name (SoundLabel, "SoundLabel");
  gtk_widget_ref (SoundLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "SoundLabel", SoundLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SoundLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), SoundLabel, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (SoundLabel), 0, 0.5);

  FontLabel = gtk_label_new (_("Popup Font"));
  gtk_widget_set_name (FontLabel, "FontLabel");
  gtk_widget_ref (FontLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "FontLabel", FontLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (FontLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), FontLabel, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (FontLabel), 0, 0.5);

  PopupGeometryLabel = gtk_label_new (_("Pop. geom."));
  gtk_widget_set_name (PopupGeometryLabel, "PopupGeometryLabel");
  gtk_widget_ref (PopupGeometryLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PopupGeometryLabel", PopupGeometryLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupGeometryLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), PopupGeometryLabel, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PopupGeometryLabel), 0, 0.5);

  PopTimeLabel = gtk_label_new (_("Pop time"));
  gtk_widget_set_name (PopTimeLabel, "PopTimeLabel");
  gtk_widget_ref (PopTimeLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PopTimeLabel", PopTimeLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopTimeLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), PopTimeLabel, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PopTimeLabel), 0, 0.5);

  PollTimeLabel = gtk_label_new (_("Poll time"));
  gtk_widget_set_name (PollTimeLabel, "PollTimeLabel");
  gtk_widget_ref (PollTimeLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PollTimeLabel", PollTimeLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PollTimeLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), PollTimeLabel, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PollTimeLabel), 0, 0.5);

  PopupGeometryHBox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (PopupGeometryHBox, "PopupGeometryHBox");
  gtk_widget_ref (PopupGeometryHBox);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PopupGeometryHBox", PopupGeometryHBox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupGeometryHBox);
  gtk_table_attach (GTK_TABLE (OptionsTable), PopupGeometryHBox, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  PopupGeometryXLabel = gtk_label_new (_("X "));
  gtk_widget_set_name (PopupGeometryXLabel, "PopupGeometryXLabel");
  gtk_widget_ref (PopupGeometryXLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PopupGeometryXLabel", PopupGeometryXLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupGeometryXLabel);
  gtk_box_pack_start (GTK_BOX (PopupGeometryHBox), PopupGeometryXLabel, FALSE, FALSE, 0);

  PopupGeometryXSpin_adj = gtk_adjustment_new (-1, -1600, 1600, 1, 10, 10);
  PopupGeometryXSpin = gtk_spin_button_new (GTK_ADJUSTMENT (PopupGeometryXSpin_adj), 1, 0);
  gtk_widget_set_name (PopupGeometryXSpin, "PopupGeometryXSpin");
  gtk_widget_ref (PopupGeometryXSpin);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PopupGeometryXSpin", PopupGeometryXSpin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupGeometryXSpin);
  gtk_box_pack_start (GTK_BOX (PopupGeometryHBox), PopupGeometryXSpin, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, PopupGeometryXSpin, _("X coordinate of the popup window (negative number refer to the right border of the screen)"), NULL);

  PopupGeometryYLabel = gtk_label_new (_("Y "));
  gtk_widget_set_name (PopupGeometryYLabel, "PopupGeometryYLabel");
  gtk_widget_ref (PopupGeometryYLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PopupGeometryYLabel", PopupGeometryYLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupGeometryYLabel);
  gtk_box_pack_start (GTK_BOX (PopupGeometryHBox), PopupGeometryYLabel, FALSE, FALSE, 0);

  PopupGeometryYSpin_adj = gtk_adjustment_new (0, -1200, 1200, 1, 10, 10);
  PopupGeometryYSpin = gtk_spin_button_new (GTK_ADJUSTMENT (PopupGeometryYSpin_adj), 1, 0);
  gtk_widget_set_name (PopupGeometryYSpin, "PopupGeometryYSpin");
  gtk_widget_ref (PopupGeometryYSpin);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PopupGeometryYSpin", PopupGeometryYSpin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupGeometryYSpin);
  gtk_box_pack_start (GTK_BOX (PopupGeometryHBox), PopupGeometryYSpin, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, PopupGeometryYSpin, _("Y coordinate of the popup window (negative number refer to the bottom border of the screen)"), NULL);

  OptionsLabel = gtk_label_new (_("Options"));
  gtk_widget_set_name (OptionsLabel, "OptionsLabel");
  gtk_widget_ref (OptionsLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "OptionsLabel", OptionsLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (OptionsLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), OptionsLabel, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (OptionsLabel), 0, 0.5);

  SubOptionsTable = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (SubOptionsTable, "SubOptionsTable");
  gtk_widget_ref (SubOptionsTable);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "SubOptionsTable", SubOptionsTable,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SubOptionsTable);
  gtk_table_attach (GTK_TABLE (OptionsTable), SubOptionsTable, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  OptionsNoSoundCheck = gtk_check_button_new_with_label (_("No sound"));
  gtk_widget_set_name (OptionsNoSoundCheck, "OptionsNoSoundCheck");
  gtk_widget_ref (OptionsNoSoundCheck);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "OptionsNoSoundCheck", OptionsNoSoundCheck,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (OptionsNoSoundCheck);
  gtk_table_attach (GTK_TABLE (SubOptionsTable), OptionsNoSoundCheck, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, OptionsNoSoundCheck, _("Check if you do not want sound when new mail has arrived"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (OptionsNoSoundCheck), TRUE);

  OptionsNoPopupCheck = gtk_check_button_new_with_label (_("No popup"));
  gtk_widget_set_name (OptionsNoPopupCheck, "OptionsNoPopupCheck");
  gtk_widget_ref (OptionsNoPopupCheck);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "OptionsNoPopupCheck", OptionsNoPopupCheck,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (OptionsNoPopupCheck);
  gtk_table_attach (GTK_TABLE (SubOptionsTable), OptionsNoPopupCheck, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, OptionsNoPopupCheck, _("Check if you do not want popup when new mail has arrived"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (OptionsNoPopupCheck), TRUE);

  OptionsNoTitleCheck = gtk_check_button_new_with_label (_("No title"));
  gtk_widget_set_name (OptionsNoTitleCheck, "OptionsNoTitleCheck");
  gtk_widget_ref (OptionsNoTitleCheck);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "OptionsNoTitleCheck", OptionsNoTitleCheck,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (OptionsNoTitleCheck);
  gtk_table_attach (GTK_TABLE (SubOptionsTable), OptionsNoTitleCheck, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, OptionsNoTitleCheck, _("Check if you do not want title in popup window"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (OptionsNoTitleCheck), TRUE);

  OptionsNoDateCheck = gtk_check_button_new_with_label (_("No date"));
  gtk_widget_set_name (OptionsNoDateCheck, "OptionsNoDateCheck");
  gtk_widget_ref (OptionsNoDateCheck);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "OptionsNoDateCheck", OptionsNoDateCheck,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (OptionsNoDateCheck);
  gtk_table_attach (GTK_TABLE (SubOptionsTable), OptionsNoDateCheck, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, OptionsNoDateCheck, _("Check if you do not want date in popup window"), NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (OptionsNoDateCheck), TRUE);

  MailPixmapLabel = gtk_label_new (_("Mail pic"));
  gtk_widget_set_name (MailPixmapLabel, "MailPixmapLabel");
  gtk_widget_ref (MailPixmapLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "MailPixmapLabel", MailPixmapLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (MailPixmapLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), MailPixmapLabel, 0, 1, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (MailPixmapLabel), 0, 0.5);

  NoMailPixmapLabel = gtk_label_new (_("No mail pic   "));
  gtk_widget_set_name (NoMailPixmapLabel, "NoMailPixmapLabel");
  gtk_widget_ref (NoMailPixmapLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "NoMailPixmapLabel", NoMailPixmapLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (NoMailPixmapLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), NoMailPixmapLabel, 0, 1, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (NoMailPixmapLabel), 0, 0.5);

  MailEventBox = gtk_event_box_new ();
  gtk_widget_set_name (MailEventBox, "MailEventBox");
  gtk_widget_ref (MailEventBox);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "MailEventBox", MailEventBox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (MailEventBox);
  gtk_table_attach (GTK_TABLE (OptionsTable), MailEventBox, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_tooltips_set_tip (tooltips, MailEventBox, _("Pixmap to use when new mail"), NULL);

  MailPixmapFrame = gtk_frame_new (NULL);
  gtk_widget_set_name (MailPixmapFrame, "MailPixmapFrame");
  gtk_widget_ref (MailPixmapFrame);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "MailPixmapFrame", MailPixmapFrame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (MailPixmapFrame);
  gtk_container_add (GTK_CONTAINER (MailEventBox), MailPixmapFrame);

  MailPixmap = create_pixmap (Mailbox, biff->mailPixmapFilename);
  gtk_widget_set_name (MailPixmap, "MailPixmap");
  gtk_widget_ref (MailPixmap);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "MailPixmap", MailPixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (MailPixmap);
  gtk_container_add (GTK_CONTAINER (MailPixmapFrame), MailPixmap);
  gtk_misc_set_padding (GTK_MISC (MailPixmap), 0, 3);

  NoMailEventBox = gtk_event_box_new ();
  gtk_widget_set_name (NoMailEventBox, "NoMailEventBox");
  gtk_widget_ref (NoMailEventBox);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "NoMailEventBox", NoMailEventBox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (NoMailEventBox);
  gtk_table_attach (GTK_TABLE (OptionsTable), NoMailEventBox, 1, 2, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_tooltips_set_tip (tooltips, NoMailEventBox, _("Pixmap to use when no mail"), NULL);

  NoMailPixmapFrame = gtk_frame_new (NULL);
  gtk_widget_set_name (NoMailPixmapFrame, "NoMailPixmapFrame");
  gtk_widget_ref (NoMailPixmapFrame);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "NoMailPixmapFrame", NoMailPixmapFrame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (NoMailPixmapFrame);
  gtk_container_add (GTK_CONTAINER (NoMailEventBox), NoMailPixmapFrame);

  NoMailPixmap = create_pixmap (Mailbox, biff->nomailPixmapFilename);
  gtk_widget_set_name (NoMailPixmap, "NoMailPixmap");
  gtk_widget_ref (NoMailPixmap);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "NoMailPixmap", NoMailPixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (NoMailPixmap);
  gtk_container_add (GTK_CONTAINER (NoMailPixmapFrame), NoMailPixmap);
  gtk_misc_set_padding (GTK_MISC (NoMailPixmap), 0, 3);

  FontButton = gtk_button_new_with_label (_("..."));
  gtk_widget_set_name (FontButton, "FontButton");
  gtk_widget_ref (FontButton);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "FontButton", FontButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (FontButton);
  gtk_table_attach (GTK_TABLE (OptionsTable), FontButton, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, FontButton, _("Font to use in popup window"), NULL);

  PollTimeSpin_adj = gtk_adjustment_new (5, 5, 3600, 1, 10, 10);
  PollTimeSpin = gtk_spin_button_new (GTK_ADJUSTMENT (PollTimeSpin_adj), 1, 0);
  gtk_widget_set_name (PollTimeSpin, "PollTimeSpin");
  gtk_widget_ref (PollTimeSpin);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PollTimeSpin", PollTimeSpin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PollTimeSpin);
  gtk_table_attach (GTK_TABLE (OptionsTable), PollTimeSpin, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, PollTimeSpin, _("Check mail every POLLTIME seconds"), NULL);

  PopTimeSpin_adj = gtk_adjustment_new (2, 2, 30, 1, 10, 10);
  PopTimeSpin = gtk_spin_button_new (GTK_ADJUSTMENT (PopTimeSpin_adj), 1, 0);
  gtk_widget_set_name (PopTimeSpin, "PopTimeSpin");
  gtk_widget_ref (PopTimeSpin);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "PopTimeSpin", PopTimeSpin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopTimeSpin);
  gtk_table_attach (GTK_TABLE (OptionsTable), PopTimeSpin, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, PopTimeSpin, _("Display popup windows for POPTIME seconds"), NULL);

  SoundHBox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (SoundHBox, "SoundHBox");
  gtk_widget_ref (SoundHBox);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "SoundHBox", SoundHBox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SoundHBox);
  gtk_table_attach (GTK_TABLE (OptionsTable), SoundHBox, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  SoundButton = gtk_button_new_with_label (_("mail.wav"));
  gtk_widget_set_name (SoundButton, "SoundButton");
  gtk_widget_ref (SoundButton);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "SoundButton", SoundButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SoundButton);
  gtk_box_pack_start (GTK_BOX (SoundHBox), SoundButton, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, SoundButton, _("Sound to play when new mail has arrived"), NULL);

  SoundPlayButton = gtk_button_new_with_label (_("play"));
  gtk_widget_set_name (SoundPlayButton, "SoundPlayButton");
  gtk_widget_ref (SoundPlayButton);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "SoundPlayButton", SoundPlayButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SoundPlayButton);
  gtk_box_pack_start (GTK_BOX (SoundHBox), SoundPlayButton, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, SoundPlayButton, _("Play current sound"), NULL);

#ifndef USE_GNOME
  WindowGeometryHBox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (WindowGeometryHBox, "WindowGeometryHBox");
  gtk_widget_ref (WindowGeometryHBox);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "WindowGeometryHBox", WindowGeometryHBox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (WindowGeometryHBox);
  gtk_table_attach (GTK_TABLE (OptionsTable), WindowGeometryHBox, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  WindowGeometryXLabel = gtk_label_new (_("X "));
  gtk_widget_set_name (WindowGeometryXLabel, "WindowGeometryXLabel");
  gtk_widget_ref (WindowGeometryXLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "WindowGeometryXLabel", WindowGeometryXLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (WindowGeometryXLabel);
  gtk_box_pack_start (GTK_BOX (WindowGeometryHBox), WindowGeometryXLabel, FALSE, FALSE, 0);

  WindowGeometryXSpin_adj = gtk_adjustment_new (-1, -1600, 1600, 1, 10, 10);
  WindowGeometryXSpin = gtk_spin_button_new (GTK_ADJUSTMENT (WindowGeometryXSpin_adj), 1, 0);
  gtk_widget_set_name (WindowGeometryXSpin, "WindowGeometryXSpin");
  gtk_widget_ref (WindowGeometryXSpin);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "WindowGeometryXSpin", WindowGeometryXSpin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (WindowGeometryXSpin);
  gtk_box_pack_start (GTK_BOX (WindowGeometryHBox), WindowGeometryXSpin, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, WindowGeometryXSpin, _("X coordinate of the main window (negative number refer to the right border of the screen)"), NULL);

  WindowGeometryYLabel = gtk_label_new (_("Y "));
  gtk_widget_set_name (WindowGeometryYLabel, "WindowGeometryYLabel");
  gtk_widget_ref (WindowGeometryYLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "WindowGeometryYLabel", WindowGeometryYLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (WindowGeometryYLabel);
  gtk_box_pack_start (GTK_BOX (WindowGeometryHBox), WindowGeometryYLabel, FALSE, FALSE, 0);

  WindowGeometryYSpin_adj = gtk_adjustment_new (-1, -1200, 1200, 1, 10, 10);
  WindowGeometryYSpin = gtk_spin_button_new (GTK_ADJUSTMENT (WindowGeometryYSpin_adj), 1, 0);
  gtk_widget_set_name (WindowGeometryYSpin, "WindowGeometryYSpin");
  gtk_widget_ref (WindowGeometryYSpin);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "WindowGeometryYSpin", WindowGeometryYSpin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (WindowGeometryYSpin);
  gtk_box_pack_start (GTK_BOX (WindowGeometryHBox), WindowGeometryYSpin, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, WindowGeometryYSpin, _("Y coordinate of the main window (negative number refer to the bottom border of the screen)"), NULL);

  WindowGeometryLabel = gtk_label_new (_("Win. geom."));
  gtk_widget_set_name (WindowGeometryLabel, "WindowGeometryLabel");
  gtk_widget_ref (WindowGeometryLabel);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "WindowGeometryLabel", WindowGeometryLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (WindowGeometryLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), WindowGeometryLabel, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (WindowGeometryLabel), 0, 0.5);
#endif

  ConfirmationHBox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (ConfirmationHBox, "ConfirmationHBox");
  gtk_widget_ref (ConfirmationHBox);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "ConfirmationHBox", ConfirmationHBox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ConfirmationHBox);
  gtk_box_pack_start (GTK_BOX (MainVBox), ConfirmationHBox, TRUE, FALSE, 0);

  OkButton = gtk_button_new_with_label (_("OK"));
  gtk_widget_set_name (OkButton, "OkButton");
  gtk_widget_ref (OkButton);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "OkButton", OkButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (OkButton);
  gtk_box_pack_end (GTK_BOX (ConfirmationHBox), OkButton, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (OkButton), 3);

  SuspendButton = gtk_button_new_with_label (_("  Suspend   "));
  gtk_widget_set_name (SuspendButton, "SuspendButton");
  gtk_widget_ref (SuspendButton);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "SuspendButton", SuspendButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SuspendButton);
  gtk_box_pack_end (GTK_BOX (ConfirmationHBox), SuspendButton, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (SuspendButton), 3);

  QuitButton = gtk_button_new_with_label (_("  Quit   "));
  gtk_widget_set_name (QuitButton, "QuitButton");
  gtk_widget_ref (QuitButton);
  gtk_object_set_data_full (GTK_OBJECT (Mailbox), "QuitButton", QuitButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (QuitButton);
  gtk_box_pack_end (GTK_BOX (ConfirmationHBox), QuitButton, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (QuitButton), 3);


  gtk_signal_connect (GTK_OBJECT (Mailbox), "delete_event",
                      GTK_SIGNAL_FUNC (on_Mailbox_delete),
                      biff);
  gtk_signal_connect (GTK_OBJECT (UserEntry), "changed",
                      GTK_SIGNAL_FUNC (on_UserEntry_changed),
                      biff);
  gtk_signal_connect (GTK_OBJECT (PasswordEntry), "changed",
                      GTK_SIGNAL_FUNC (on_PasswordEntry_changed),
                      biff);
  gtk_signal_connect (GTK_OBJECT (TitleEntry), "changed",
                      GTK_SIGNAL_FUNC (on_TitleEntry_changed),
                      biff);
  gtk_signal_connect (GTK_OBJECT (AddressEntry), "changed",
                      GTK_SIGNAL_FUNC (on_AddressEntry_changed),
                      biff);
  gtk_signal_connect (GTK_OBJECT (AddressButton), "clicked",
                      GTK_SIGNAL_FUNC (on_AddressButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (ProtocolRadioFile), "toggled",
                      GTK_SIGNAL_FUNC (on_ProtocolRadioFile_toggled),
                      biff);
  gtk_signal_connect (GTK_OBJECT (ProtocolRadioMaildir), "toggled",
                      GTK_SIGNAL_FUNC (on_ProtocolRadioMaildir_toggled),
                      biff);
  gtk_signal_connect (GTK_OBJECT (ProtocolRadioPop3), "toggled",
                      GTK_SIGNAL_FUNC (on_ProtocolRadioPop3_toggled),
                      biff);
  gtk_signal_connect (GTK_OBJECT (ProtocolRadioImap4), "toggled",
                      GTK_SIGNAL_FUNC (on_ProtocolRadioImap4_toggled),
                      biff);
  gtk_signal_connect (GTK_OBJECT (ProtocolRadioMh), "toggled",
                      GTK_SIGNAL_FUNC (on_ProtocolRadioMh_toggled),
                      biff);
  gtk_signal_connect (GTK_OBJECT (PopupGeometryXSpin), "changed",
                      GTK_SIGNAL_FUNC (on_PopupGeometryXSpin_changed),
                      biff);
  gtk_signal_connect (GTK_OBJECT (PopupGeometryYSpin), "changed",
                      GTK_SIGNAL_FUNC (on_PopupGeometryYSpin_changed),
                      biff);
  gtk_signal_connect (GTK_OBJECT (OptionsNoSoundCheck), "toggled",
                      GTK_SIGNAL_FUNC (on_OptionsNoSoundCheck_toggled),
                      biff);
  gtk_signal_connect (GTK_OBJECT (OptionsNoPopupCheck), "toggled",
                      GTK_SIGNAL_FUNC (on_OptionsNoPopupCheck_toggled),
                      biff);
  gtk_signal_connect (GTK_OBJECT (OptionsNoTitleCheck), "toggled",
                      GTK_SIGNAL_FUNC (on_OptionsNoTitleCheck_toggled),
                      biff);
  gtk_signal_connect (GTK_OBJECT (OptionsNoDateCheck), "toggled",
                      GTK_SIGNAL_FUNC (on_OptionsNoDateCheck_toggled),
                      biff);
  gtk_signal_connect (GTK_OBJECT (MailEventBox), "button_press_event",
                      GTK_SIGNAL_FUNC (on_MailEventBox_button_press_event),
                      biff);
  gtk_signal_connect (GTK_OBJECT (NoMailEventBox), "button_press_event",
                      GTK_SIGNAL_FUNC (on_NoMailEventBox_button_press_event),
                      biff);
  gtk_signal_connect (GTK_OBJECT (FontButton), "clicked",
                      GTK_SIGNAL_FUNC (on_FontButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (PollTimeSpin), "changed",
                      GTK_SIGNAL_FUNC (on_PollTimeSpin_changed),
                      biff);
  gtk_signal_connect (GTK_OBJECT (PopTimeSpin), "changed",
                      GTK_SIGNAL_FUNC (on_PopTimeSpin_changed),
                      biff);
  gtk_signal_connect (GTK_OBJECT (SoundButton), "clicked",
                      GTK_SIGNAL_FUNC (on_SoundButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (SoundPlayButton), "clicked",
                      GTK_SIGNAL_FUNC (on_SoundPlayButton_clicked),
                      biff);

#ifndef USE_GNOME
  gtk_signal_connect (GTK_OBJECT (WindowGeometryXSpin), "changed",
                      GTK_SIGNAL_FUNC (on_WindowGeometryXSpin_changed),
                      biff);
  gtk_signal_connect (GTK_OBJECT (WindowGeometryYSpin), "changed",
                      GTK_SIGNAL_FUNC (on_WindowGeometryYSpin_changed),
                      biff);
#endif

  gtk_signal_connect (GTK_OBJECT (OkButton), "clicked",
                      GTK_SIGNAL_FUNC (on_OkButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (QuitButton), "clicked",
                      GTK_SIGNAL_FUNC (on_QuitButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (SuspendButton), "clicked",
                      GTK_SIGNAL_FUNC (on_SuspendButton_clicked),
                      biff);
  gtk_object_set_data (GTK_OBJECT (Mailbox), "tooltips", tooltips);

  return Mailbox;
}

GtkWidget *create_FontSelectionDialog (Biff *biff) {
  GtkWidget *FontSelectionDialog;
  GtkWidget *FontSelectionDialogOkButton;
  GtkWidget *FontSelectionDialogCancelButton;
  GtkWidget *FontSelectionDialogApplyButton;

  FontSelectionDialog = gtk_font_selection_dialog_new ("Select Font");
  gtk_widget_set_name (FontSelectionDialog, "FontSelectionDialog");
  gtk_object_set_data (GTK_OBJECT (FontSelectionDialog), "FontSelectionDialog", FontSelectionDialog);
  gtk_container_set_border_width (GTK_CONTAINER (FontSelectionDialog), 4);
  gtk_window_set_position (GTK_WINDOW (FontSelectionDialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (FontSelectionDialog), FALSE, TRUE, TRUE);

  FontSelectionDialogOkButton = GTK_FONT_SELECTION_DIALOG (FontSelectionDialog)->ok_button;
  gtk_widget_set_name (FontSelectionDialogOkButton, "FontSelectionDialogOkButton");
  gtk_object_set_data (GTK_OBJECT (FontSelectionDialog), "FontSelectionDialogOkButton", FontSelectionDialogOkButton);
  gtk_widget_show (FontSelectionDialogOkButton);
  GTK_WIDGET_SET_FLAGS (FontSelectionDialogOkButton, GTK_CAN_DEFAULT);

  FontSelectionDialogCancelButton = GTK_FONT_SELECTION_DIALOG (FontSelectionDialog)->cancel_button;
  gtk_widget_set_name (FontSelectionDialogCancelButton, "FontSelectionDialogCancelButton");
  gtk_object_set_data (GTK_OBJECT (FontSelectionDialog), "FontSelectionDialogCancelButton", FontSelectionDialogCancelButton);
  gtk_widget_show (FontSelectionDialogCancelButton);
  GTK_WIDGET_SET_FLAGS (FontSelectionDialogCancelButton, GTK_CAN_DEFAULT);

  FontSelectionDialogApplyButton = GTK_FONT_SELECTION_DIALOG (FontSelectionDialog)->apply_button;
  gtk_widget_set_name (FontSelectionDialogApplyButton, "FontSelectionDialogApplyButton");
  gtk_object_set_data (GTK_OBJECT (FontSelectionDialog), "FontSelectionDialogApplyButton", FontSelectionDialogApplyButton);
  gtk_widget_show (FontSelectionDialogApplyButton);
  GTK_WIDGET_SET_FLAGS (FontSelectionDialogApplyButton, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (FontSelectionDialogOkButton), "clicked",
                      GTK_SIGNAL_FUNC (on_FontSelectionDialogOkButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (FontSelectionDialogCancelButton), "clicked",
                      GTK_SIGNAL_FUNC (on_FontSelectionDialogCancelButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (FontSelectionDialogApplyButton), "clicked",
                      GTK_SIGNAL_FUNC (on_FontSelectionDialogApplyButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (FontSelectionDialog), "delete_event",
                      GTK_SIGNAL_FUNC (on_FontSelectionDialog_delete),
                      biff);

  return FontSelectionDialog;
}

GtkWidget *create_FileSelectionDialog (Biff *biff) {
  GtkWidget *FileSelectionDialog;
  GtkWidget *FileSelectionDialogOkButton;
  GtkWidget *FileSelectionDialogCancelButton;

  FileSelectionDialog = gtk_file_selection_new ("Select File");
  gtk_widget_set_name (FileSelectionDialog, "FileSelectionDialog");
  gtk_object_set_data (GTK_OBJECT (FileSelectionDialog), "FileSelectionDialog", FileSelectionDialog);
  gtk_container_set_border_width (GTK_CONTAINER (FileSelectionDialog), 10);
  gtk_window_set_position (GTK_WINDOW (FileSelectionDialog), GTK_WIN_POS_CENTER);

  FileSelectionDialogOkButton = GTK_FILE_SELECTION (FileSelectionDialog)->ok_button;
  gtk_widget_set_name (FileSelectionDialogOkButton, "FileSelectionDialogOkButton");
  gtk_object_set_data (GTK_OBJECT (FileSelectionDialog), "FileSelectionDialogOkButton", FileSelectionDialogOkButton);
  gtk_widget_show (FileSelectionDialogOkButton);
  GTK_WIDGET_SET_FLAGS (FileSelectionDialogOkButton, GTK_CAN_DEFAULT);

  FileSelectionDialogCancelButton = GTK_FILE_SELECTION (FileSelectionDialog)->cancel_button;
  gtk_widget_set_name (FileSelectionDialogCancelButton, "FileSelectionDialogCancelButton");
  gtk_object_set_data (GTK_OBJECT (FileSelectionDialog), "FileSelectionDialogCancelButton", FileSelectionDialogCancelButton);
  gtk_widget_show (FileSelectionDialogCancelButton);
  GTK_WIDGET_SET_FLAGS (FileSelectionDialogCancelButton, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (FileSelectionDialogOkButton), "clicked",
                      GTK_SIGNAL_FUNC (on_FileSelectionDialogOkButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (FileSelectionDialogCancelButton), "clicked",
                      GTK_SIGNAL_FUNC (on_FileSelectionDialogCancelButton_clicked),
                      biff);
  gtk_signal_connect (GTK_OBJECT (FileSelectionDialog), "delete_event",
                      GTK_SIGNAL_FUNC (on_FileSelectionDialog_delete),
                      biff);

  return FileSelectionDialog;
}

GtkWidget *create_Popup (Biff *biff) {
  GtkWidget *Popup;
  GtkWidget *PopupVBox;
  GtkWidget *PopupTitle;
  GtkWidget *PopupList;
  GtkWidget *PopupListNumber;
  GtkWidget *PopupListFrom;
  GtkWidget *PopupListSubject;
  GtkWidget *PopupListDate;
  int nbColumns = 3;
  GtkStyle * style;
  GdkFont *  font;

  Popup = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_set_events (Popup, GDK_ALL_EVENTS_MASK);  
  gtk_widget_set_name (Popup, "Popup");
  gtk_object_set_data (GTK_OBJECT (Popup), "Popup", Popup);
  gtk_container_set_border_width (GTK_CONTAINER (Popup), 1);
  gtk_window_set_title (GTK_WINDOW (Popup), "Popup");

  style = gtk_style_copy (gtk_widget_get_style (Popup));
  if ((font = gdk_font_load (biff->font)) == 0) {
    g_warning ("Cannot load %s font\n", biff->font);
  }
  else {
    style->font = font;
  }

  PopupVBox = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (PopupVBox, "PopupVBox");
  gtk_widget_ref (PopupVBox);
  gtk_object_set_data_full (GTK_OBJECT (Popup), "PopupVBox", PopupVBox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupVBox);
  gtk_container_add (GTK_CONTAINER (Popup), PopupVBox);

  if (biff->optNoTitle == 0) {
    PopupTitle = gtk_label_new (biff->title);
    gtk_widget_set_name (PopupTitle, "PopupTitle");
    gtk_widget_ref (PopupTitle);
    gtk_object_set_data_full (GTK_OBJECT (Popup), "PopupTitle", PopupTitle,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (PopupTitle);
    gtk_box_pack_start (GTK_BOX (PopupVBox), PopupTitle, FALSE, FALSE, 0);
  }

  if (biff->optNoDate == 0)
    nbColumns++;  

  PopupList = gtk_clist_new (nbColumns);
  gtk_widget_set_name (PopupList, "PopupList");
  gtk_widget_ref (PopupList);
  gtk_object_set_data_full (GTK_OBJECT (Popup), "PopupList", PopupList,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupList);
  gtk_box_pack_start (GTK_BOX (PopupVBox), PopupList, TRUE, TRUE, 0);
  gtk_clist_column_titles_show (GTK_CLIST (PopupList));
  gtk_clist_set_shadow_type (GTK_CLIST (PopupList), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_set_style (PopupList, style);

  PopupListNumber = gtk_label_new ("#");
  gtk_widget_set_name (PopupListNumber, "PopupListNumber");
  gtk_widget_ref (PopupListNumber);
  gtk_object_set_data_full (GTK_OBJECT (Popup), "PopupListNumber", PopupListNumber,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupListNumber);
  gtk_clist_set_column_widget (GTK_CLIST (PopupList), 0, PopupListNumber);
  gtk_widget_set_style (PopupListNumber, style);

  PopupListFrom = gtk_label_new (_("From"));
  gtk_widget_set_name (PopupListFrom, "PopupListFrom");
  gtk_widget_ref (PopupListFrom);
  gtk_object_set_data_full (GTK_OBJECT (Popup), "PopupListFrom", PopupListFrom,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupListFrom);
  gtk_clist_set_column_widget (GTK_CLIST (PopupList), 1, PopupListFrom);
  gtk_label_set_justify (GTK_LABEL (PopupListFrom), GTK_JUSTIFY_LEFT);
  gtk_widget_set_style (PopupListFrom, style);

  PopupListSubject = gtk_label_new (_("Subject"));
  gtk_widget_set_name (PopupListSubject, "PopupListSubject");
  gtk_widget_ref (PopupListSubject);
  gtk_object_set_data_full (GTK_OBJECT (Popup), "PopupListSubject", PopupListSubject,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (PopupListSubject);
  gtk_clist_set_column_widget (GTK_CLIST (PopupList), 2, PopupListSubject);
  gtk_widget_set_style (PopupListSubject, style);

  if (biff->optNoDate == 0) {
    PopupListDate = gtk_label_new (_("Date"));
    gtk_widget_set_name (PopupListDate, "PopupListDate");
    gtk_widget_ref (PopupListDate);
    gtk_object_set_data_full (GTK_OBJECT (Popup), "PopupListDate", PopupListDate,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (PopupListDate);
    gtk_clist_set_column_widget (GTK_CLIST (PopupList), 3, PopupListDate);
    gtk_widget_set_style (PopupListDate, style);
  }
  
  gtk_signal_connect (GTK_OBJECT (PopupList), "button_press_event",
		      GTK_SIGNAL_FUNC (on_Popup_button_press_event),
		      biff);
  gtk_signal_connect (GTK_OBJECT (Popup), "enter_notify_event",
		      GTK_SIGNAL_FUNC (on_Popup_enter_notify_event),
                      biff);
  gtk_signal_connect (GTK_OBJECT (Popup), "leave_notify_event",
		      GTK_SIGNAL_FUNC (on_Popup_leave_notify_event),
                      biff);

  return Popup;
}

