{
GPC demo program for the FileLock and FileUnlock routines.

Copyright (C) 1999-2000 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING. If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

As a special exception, if you incorporate even large parts of the
code of this demo program into another program with substantially
different functionality, this does not cause the other program to
be covered by the GNU General Public License. This exception does
not however invalidate any other reasons why it might be covered
by the GNU General Public License.
}

program FileLockDemo;

uses GPC;

var
  f : File;
  Res : Boolean;
  TempFileName : TString;

{ The program calls itself recursively, so the instances can try
  file locks against each other }
procedure DoExecute (const Msg, Parameter : String);
var Dummy : Integer;
begin
  Write (Msg);
  Flush (Output);
  Dummy := Execute (ParamStr (0) + ' --recursive ' + Parameter + ' ' + TempFileName)
end;

procedure TimerHandler (Signal : Integer);
begin
  Writeln ('Received signal `', StrSignal (Signal), '''.')
end;

begin
  { Recursive call }
  if ParamStr (1) = '--recursive' then
    begin
      Reset (f, ParamStr (3), 1);
      if ParamStr (2) = '--read' then
        Writeln (FileLock ((*@@*)AnyFile( f), False, False))
      else if ParamStr (2) = '--write' then
        Writeln (FileLock ((*@@*)AnyFile( f), True, False))
      else if ParamStr (2) = '--block' then
        begin
          Writeln ('Subprocess write lock, should fail:                  ', FileLock ((*@@*)AnyFile( f), True, False));
          Writeln ('Setting an alarm to 5 seconds, should succeed:       ', Alarm (5) >= 0);
          Writeln ('Install timer handler, should succeed:               ', InstallSignalHandler (SigAlrm, TimerHandler, False, False, null, null));
          Writeln ('A write lock with blocking, should block the program.');
          Writeln ('However, in 5 seconds, the program should get an `Alarm clock'' signal...');
          Res := FileLock ((*@@*)AnyFile( f), True, True);
          Writeln ('The write lock should have failed,');
          Writeln ('because it was interrupted:                          ', Res)
        end
      else
        Writeln (ParamStr (0), ': invalid recursive call.');
      Close (f);
      Halt
    end;

  { Non-recursive call. Execution normally starts here. }

  TempFileName := GetTempFileName;
  Rewrite (f, TempFileName, 1);

  Writeln   ('`True'' means success, `False'' means failure.');

  DoExecute ('Subprocess read lock, should succeed:                ', '--read');
  DoExecute ('Subprocess write lock, should succeed:               ', '--write');

  Writeln   ('Read lock, should succeed:                           ', FileLock ((*@@*)AnyFile( f), False, False));
  DoExecute ('Subprocess read lock, should succeed:                ', '--read');
  DoExecute ('Subprocess write lock, should fail:                  ', '--write');
  Writeln   ('Remove lock, should succeed:                         ', FileUnLock ((*@@*)AnyFile( f)));

  Writeln   ('Write lock, should succeed:                          ', FileLock ((*@@*)AnyFile( f), True, False));
  DoExecute ('Subprocess read lock, should fail:                   ', '--read');
  DoExecute ('Subprocess write lock, should fail:                  ', '--write');
  DoExecute ('Subprocess write lock with blocking...' + NewLine     , '--block');
  Writeln   ('Remove lock, should succeed:                         ', FileUnLock ((*@@*)AnyFile( f)));

  DoExecute ('Subprocess read lock, should succeed:                ', '--read');
  DoExecute ('Subprocess write lock, should succeed:               ', '--write');

  Close (f);
  Erase (f)
end.
