// -*- C++ -*-

/* 
 * GChemPaint library
 * text.h 
 *
 * Copyright (C) 2002-2004 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_TEXT_H
#define GCHEMPAINT_TEXT_H

#include <gcu/object.h>
#include <libxml/tree.h>
#include <gtk/gtk.h>
#include <libgcpcanvas/gcp-canvas-rich-text.h>
#include "text-object.h"

typedef struct _GnomeCanvasRichTextGCP           GnomeCanvasRichTextGCP;
typedef struct _GnomeCanvasRichTextGCPClass      GnomeCanvasRichTextGCPClass;

#define GNOME_TYPE_CANVAS_RICH_TEXT_GCP            (gnome_canvas_rich_text_gcp_get_type ())
#define GNOME_CANVAS_RICH_TEXT_GCP(obj)            (GTK_CHECK_CAST ((obj), GNOME_TYPE_CANVAS_RICH_TEXT_GCP, GnomeCanvasRichTextGCP))
#define GNOME_CANVAS_CLASS_RICH_TEXT_GCP(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_CANVAS_RICH_TEXT_GCP, GnomeCanvasRichTextGCPClass))
#define GNOME_IS_CANVAS_RICH_TEXT_GCP(obj)         (GTK_CHECK_TYPE ((obj), GNOME_TYPE_CANVAS_RICH_TEXT_GCP))
#define GNOME_IS_CANVAS_RICH_TEXT_GCP_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_CANVAS_RICH_TEXT_GCP))
#define GNOME_CANVAS_RICH_TEXT_GCP_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GNOME_TYPE_CANVAS_RICH_TEXT_GCP, GnomeCanvasRichTextGCPClass))

struct _GnomeCanvasRichTextGCP {
	GnomeCanvasRichTextExt canvas;
};

struct _GnomeCanvasRichTextGCPClass {
	GnomeCanvasRichTextExtClass parent_class;
};


GType gnome_canvas_rich_text_gcp_get_type (void) G_GNUC_CONST;

using namespace gcu;

class gcpText: public gcpTextObject
{
public:
	gcpText();
	gcpText(double x, double y);
	virtual ~gcpText();
	
	void GetCoords(double *x, double *y);
	void SetCoords(double x, double y);
	virtual xmlNodePtr Save(xmlDocPtr xml);
	xmlNodePtr SaveSelection(xmlDocPtr xml);
	virtual bool SaveNode(xmlDocPtr xml, xmlNodePtr node, GtkTextIter *iter, GtkTextIter *end, GSList*& TagList, GSList*& OtherTagList);
	virtual bool Load(xmlNodePtr);
	bool LoadSelection(xmlNodePtr node, GtkTextIter *iter);
	bool LoadNode(xmlNodePtr, GtkTextIter* CurIter, int level = 0);
	bool LoadTaggedNode(xmlNodePtr, GtkTextIter* CurIter, const char* TagName);
	virtual void Add(GtkWidget* w);
	virtual void Update(GtkWidget* w);
	virtual void SetSelected(GtkWidget* w, int state);
	virtual bool OnChanged(GtkTextBuffer *textbuffer);
	virtual bool OnMarkSet(GtkTextBuffer *textbuffer, GtkTextIter *iter, GtkTextMark *mark);
	virtual bool OnInsertText(GtkTextBuffer *textbuffer, GtkTextIter *iter, gchar* newtext, gint length);
	virtual bool OnEndUserAction(GtkTextBuffer *textbuffer);
	virtual void Transform2D(Matrix2D& m, double x, double y);
	bool OnEvent(GdkEvent *event);
	void GetSize(double& x, double& y) {x = m_length; y = m_height;}
	static void InitTags(const char* FontName);
	virtual double GetYAlign ();
};

#endif	//GCHEMPAINT_TEXT_H
