/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

extern GladeXML *xml;
extern GString *GLADE_FILE;

/* preferences - START */
extern gboolean auto_fill_issue;

extern gboolean show_number_title;
extern gboolean show_location_title;
extern gboolean show_condition_title;
extern gboolean show_cover_price_title;
extern gboolean show_current_price_title;
extern gboolean show_purchase_price_title;
/* preferences - END */

/* function prototypes - START */
void gtk_clist_set_columns (GtkCList *clist);
/* function prototypes - END */


void on_preferences_dialog_cancel_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *preferences_dialog;
  GladeXML *temp_xml = user_data;

  preferences_dialog = glade_xml_get_widget (temp_xml, "preferences_dialog");
  gtk_widget_destroy(preferences_dialog);
}

gboolean on_preferences_dialog_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  GtkWidget *preferences_dialog;
  GladeXML *temp_xml = user_data;

  preferences_dialog = glade_xml_get_widget (temp_xml, "preferences_dialog");
  gtk_widget_destroy(preferences_dialog);

  return FALSE;
}

void on_preferences_dialog_ok_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *preferences_dialog;
  GtkWidget *auto_fill_checkbutton, *show_number_title_checkbutton, *show_location_title_checkbutton, 
    *show_condition_title_checkbutton, *show_cover_price_title_checkbutton, *show_current_price_title_checkbutton,
    *show_purchase_price_title_checkbutton;
  GtkWidget *issues_clist;
  GladeXML *temp_xml = user_data;

  preferences_dialog = glade_xml_get_widget (temp_xml, "preferences_dialog");
  auto_fill_checkbutton = glade_xml_get_widget (temp_xml, "auto_fill_checkbutton");
  show_number_title_checkbutton = glade_xml_get_widget (temp_xml, "show_number_title_checkbutton");
  show_location_title_checkbutton = glade_xml_get_widget (temp_xml, "show_location_title_checkbutton");
  show_condition_title_checkbutton = glade_xml_get_widget (temp_xml, "show_condition_title_checkbutton");
  show_cover_price_title_checkbutton = glade_xml_get_widget (temp_xml, "show_cover_price_title_checkbutton");
  show_current_price_title_checkbutton = glade_xml_get_widget (temp_xml, "show_current_price_title_checkbutton");
  show_purchase_price_title_checkbutton = glade_xml_get_widget (temp_xml, "show_purchase_price_title_checkbutton");

  auto_fill_issue = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(auto_fill_checkbutton));
  show_number_title = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(show_number_title_checkbutton));
  show_location_title = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(show_location_title_checkbutton));
  show_condition_title = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(show_condition_title_checkbutton));
  show_cover_price_title = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(show_cover_price_title_checkbutton));
  show_current_price_title = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(show_current_price_title_checkbutton));
  show_purchase_price_title = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(show_purchase_price_title_checkbutton));

  issues_clist = glade_xml_get_widget (xml, "issues_clist");
  gtk_clist_set_columns (GTK_CLIST(issues_clist));

  gtk_widget_destroy(preferences_dialog);
}

/* exported functions - START */
void gtk_clist_set_columns (GtkCList *clist)
{
  gtk_clist_set_column_visibility (clist, 0, show_number_title);
  gtk_clist_set_column_visibility (clist, 1, show_location_title);
  gtk_clist_set_column_visibility (clist, 2, show_condition_title);
  gtk_clist_set_column_visibility (clist, 3, show_cover_price_title);
  gtk_clist_set_column_visibility (clist, 4, show_current_price_title);
  gtk_clist_set_column_visibility (clist, 5, show_purchase_price_title);
}

void create_preferences_dialog ()
{
  GladeXML *temp_xml;
  GtkWidget *preferences_dialog;
  GtkWidget *auto_fill_checkbutton, *show_number_title_checkbutton, *show_location_title_checkbutton, 
    *show_condition_title_checkbutton, *show_cover_price_title_checkbutton, *show_current_price_title_checkbutton,
    *show_purchase_price_title_checkbutton;

  temp_xml = glade_xml_new (GLADE_FILE->str, "preferences_dialog");
  preferences_dialog = glade_xml_get_widget (temp_xml, "preferences_dialog");
  auto_fill_checkbutton = glade_xml_get_widget (temp_xml, "auto_fill_checkbutton");
  show_number_title_checkbutton = glade_xml_get_widget (temp_xml, "show_number_title_checkbutton");
  show_location_title_checkbutton = glade_xml_get_widget (temp_xml, "show_location_title_checkbutton");
  show_condition_title_checkbutton = glade_xml_get_widget (temp_xml, "show_condition_title_checkbutton");
  show_cover_price_title_checkbutton = glade_xml_get_widget (temp_xml, "show_cover_price_title_checkbutton");
  show_current_price_title_checkbutton = glade_xml_get_widget (temp_xml, "show_current_price_title_checkbutton");
  show_purchase_price_title_checkbutton = glade_xml_get_widget (temp_xml, "show_purchase_price_title_checkbutton");

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(auto_fill_checkbutton), auto_fill_issue);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(show_number_title_checkbutton), show_number_title);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(show_location_title_checkbutton), show_location_title);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(show_condition_title_checkbutton), show_condition_title);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(show_cover_price_title_checkbutton), show_cover_price_title);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(show_current_price_title_checkbutton), show_current_price_title);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(show_purchase_price_title_checkbutton), show_purchase_price_title);
 
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "ok_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_preferences_dialog_ok_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "cancel_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_preferences_dialog_cancel_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "preferences_dialog")), "delete_event",
			   GTK_SIGNAL_FUNC(on_preferences_dialog_delete_event), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
}
/* exported functions - END */
