/*
** Copyright (C) 10 Feb 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>

#include "globals.h"
#include "linebuffer.h"

/* concatenates two strings
 * returns pointer to newly allocated memory with the new string
 * if second parameter is NULL, it doesn't free any memory
 * if second parameter != NULL, it frees the first
 * first parameter must be != NULL
 */

char *string_append(char *start, const char *end) {
	char *newstring;

	g_assert(NULL != start);

	if (NULL == end) {
		newstring = strdup(start);
	} else {
		newstring = realloc(start, strlen(start) + strlen(end) + 1);
		strcat(newstring, end);
	}
	return newstring;
}

/* takes a pointer to linebuffer struct, and an end-of-line string
 * free's linebuffer->newline
 * extracts the next line from buffer and reallocates the rest of the buffer
 * to the buffer pointer
 * newline is allocted and points to the extracted line
 * returns TRUE if there was a new line, FALSE otherwise
 * if there was no new line, lineb is left untouched
 * TODO:  maybe a version of extract_line() that takes char eofl instead
 *	    for efficiency
 */

int extract_line(linebuffer *lineb, char *eofl) {
	char *end, *start;
	char tmp;

	g_assert(lineb != NULL);
	g_assert(lineb->buffer != NULL);
	g_assert(lineb->newline != NULL);
	g_assert(eofl != NULL);

	if ((end = strstr(lineb->buffer, eofl)) == NULL)
		return FALSE;

	free(lineb->newline);

	end += strlen(eofl);
	tmp = *end;
	*end = 0;
	lineb->newline = strdup(lineb->buffer);
	*end = tmp;

	start = strdup(end);
	free(lineb->buffer);
	lineb->buffer = start;

	return TRUE;
}

/* takes a pointer to a linebuffer and a new char string to add to it
 * adds the new string to the end of lineb->buffer
 */

void add_to_buffer(linebuffer *lineb, char *buf) {

	g_assert(lineb != NULL);
	g_assert(lineb->buffer != NULL);
	g_assert(lineb->newline != NULL);
	g_assert(buf != NULL);

	if ((lineb->buffer = realloc(lineb->buffer, strlen(lineb->buffer) + strlen(buf) + 1)) == NULL)
		g_error("add_to_buffer: can't realloc");
	strncat(lineb->buffer, buf, strlen(buf));
}

void init_buffer(linebuffer *lbuf) {
	if ((lbuf->buffer = malloc(1)) == NULL || /* FIXME: potential memory leak if malloc fails */
			(lbuf->newline = malloc(1)) == NULL)
	   	g_error("create_buffer failed to allocate zero-size memory!");
	bzero(lbuf->buffer, 1);
	bzero(lbuf->newline, 1);
}

void destroy_buffer(linebuffer *lbuf) {
	if (*(lbuf->buffer) != 0)
		g_warning("%s::%i: buffer not empty: %s", __FILE__, __LINE__, lbuf->buffer);
	free(lbuf->buffer);
	free(lbuf->newline);
	lbuf->buffer = NULL;
	lbuf->newline = NULL;
}
