#include <gtk/gtk.h>
#include <xmms/plugin.h>

#include "../config.h"

#if USE_PIXBUF
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#define PROGNAME "GDancer"
#define DEFAULT_THEME "space_ghost"

typedef struct _frame frame;
typedef struct _GDancer GDancer;
typedef struct _GDconf GDconf;

extern GList *gdancers; /* list of pointers to dancers */
extern VisPlugin gdancer_vp; /* xmms visplugin structure */ 
extern GDconf gdconfig; /* global config structure */

extern enum gd_freq_type {
	BASS,
	MIDRANGE,
	NEUTRAL,
	TREBLE,
	SEMI_NEUTRAL,
	SEMI_BASS,
	SEMI_TREBLE,
	SEMI_MIDRANGE };

struct _frame
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
#if USE_PIXBUF
	GdkPixbuf *pixbuf;
#endif
};

struct _GDconf
{
	// This is the structure for global config options
	// but there are no global config options so its blank
};

struct _GDancer
{
	GtkWidget *window;		/* window for dancer */
	GtkWidget *event_box;		/* event box for dancer */
	GtkWidget *pixmap;		/* pixmap widget */
	gchar theme[32];		/* theme of dancer */
	gint width, height;		/* width and height of dancer */
	gint x, y;			/* X and Y location */
	gint press_x, press_y;		/* X and Y coords of mouse press */
	gboolean move_window;		/* OK to move window? */
	gint hadlast;			/* frame that dancer had last */
	gint skip_count;
	gint skip_frames;
	gboolean move_dancer;
	
	struct config_stuff
	{
		GtkWidget *window;
		GtkWidget *vbox;
		GtkWidget *theme_label;
		GtkWidget *theme_combo;
		
		GtkAdjustment *adjustment;
		GtkWidget *skiplabel;
		GtkWidget *skipslider;
		GtkWidget *movetoggle;
		
		GtkWidget *close_button;
	} config;
	
	struct gdancer_menu
	{
		GtkWidget *mainmenu;
		GtkWidget *gblconfig;
		GtkWidget *config;
		GtkWidget *about;
		GtkWidget *raise;
		GtkWidget *lower;
		GtkWidget *delete;
		GtkWidget *add;
		GtkWidget *exit;
	} menu;

	frame treble;
	frame neutral;
	frame midrange;
	frame bass;
	frame bn;
	frame nt;
	frame mn;
	frame bt;
	frame bm;
	frame mt;
};

