#
# Registry for DataTargets. To add a new target just add an appropriate entry
# to _REGISTRY.
#

__all__ = ("create", "get_target_class")


from TargetAlignment     import TargetAlignment
from TargetArray         import TargetArray
from TargetBonoboControl import TargetBonoboControl
from TargetCanvas        import TargetCanvas
from TargetEntry         import TargetEntry
from TargetExpander      import TargetExpander
from TargetFrame         import TargetFrame
from TargetGauge         import TargetGauge
from TargetGroup         import TargetGroup
from TargetHTML          import TargetHTML
from TargetImage         import TargetImage
from TargetLabel         import TargetLabel
from TargetMenu          import TargetMenu
from TargetMenuItem      import TargetMenuItem
from TargetPlotter       import TargetPlotter


_targets = {
    "alignment" : TargetAlignment,
    "array"     : TargetArray,
    "canvas"    : TargetCanvas,
    "display"   : TargetGroup,
    "embed"     : TargetBonoboControl,
    "entry"     : TargetEntry,
    "expander"  : TargetExpander,
    "frame"     : TargetFrame,
    "gauge"     : TargetGauge,
    "group"     : TargetGroup,
    "html"      : TargetHTML,
    "image"     : TargetImage,
    "label"     : TargetLabel,
    "menu"      : TargetMenu,
    "menu-item" : TargetMenuItem,
    "plotter"   : TargetPlotter,
}



#
# Creates and returns the given target.
#
def create(name, parent):

    try:
        clss = _targets[name]
        obj = clss(parent)
        obj.set_name(name)
        return obj
    except KeyError:
        raise KeyError("Unknown target type \"%s\"." % name)


#
# Returns the class for the given target name.
#
def get_target_class(name):

    return _targets[name]

