//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/
/* graphics for upi's simulation of second messengers in LTP
*/

function do_inform
end

function do_run
	step {MAXTIME} -time
end

function set_runtime
	MAXTIME = {getfield /control/runtime value}
	setfield /#graphs/#[TYPE=xgraph] xmax {MAXTIME}
	// TABLEDT = MAXTIME/TABLESIZE
	// setclock {TABLECLOCK} {TABLEDT}
end

function update_time
	setfield /control/simtime value {getstat -time}
end

function do_reset
	str name

	/*
	foreach name ({el /kinetics/##[TYPE=xtab]})
		setfield {name} input 0
	end
	*/

 	reset
end

function make_xcontrol
	create xform /control [1,1,{TW},{TH}]
	ce /control
	create xtoggle file [0,0,16%,30] \
		-script "xshow.d /file; xhide.u /file" -label "File"
	create xtoggle edit [0:last,0,17%,30] \
		-script "xshow.d /editcontrol; xhide.u /editcontrol" -label "Edit"
	create xtoggle tools [0:last,0,17%,30] \
		-script "xshow.d /toolcontrol; xhide.u /toolcontrol" -label "Tools"
	create xtoggle simctl [0:last,0,17%,30] \
		-script "do_simctl_update.d; xshow.d /simcontrol; xhide.u /simcontrol" \
		-label "Options"
	create xtoggle graph [0:last,0,17%,30] \
		-script "xshow.d /plotcontrol; xhide.u /plotcontrol" -label "Graphs"
	create xtoggle simhelp [0:last,0,16%,30] \
		-script "xshow.d /simhelp; xhide.u /simhelp" \
		-label "Help"
	create xbutton start  [0,0:file,33%,30] -script "do_run" -offbg green
	create xbutton stop  [0:last,0:file,34%,30] -script "stop" -offbg yellow
	create xbutton reset  [0:last,0:file,33%,30] \
		 -script "do_reset" -offbg red
	create xdialog runtime -title "Runtime (sec)" -value {MAXTIME} \
		-script set_runtime [0,0:start,40%,30]
	create xdialog simtime -title "Current time" -value 0 \
		[0:last,0:start,60%,30]
	addaction simtime PROCESS update_time
	useclock simtime {CONTROLCLOCK}
	disable /control/runtime
	disable /control/file
	disable /control/tools
	disable /control/graph
	disable /control/start
	disable /control/reset
	disable /control/edit
	disable /control/simctl
	disable /control/simhelp
	disable /control/stop
	// xshow /control
end

function do_clear
	str name
	foreach name ({el /#graphs/#/#[TYPE=xplot]})
		delete name
	end
	delete /kinetics
	create group /kinetics
	call /edit/draw/tree RESET
	reset
end


function make_xfile
	create xform /quit [1,450,500,70]
	ce /quit
	create xlabel label -title "Did you save your work ?"
	create xbutton yes [0,0:label,33%,30] -title "Yes, Quit" -script quit
	create xbutton no [0:last,0:label,34%,30] -title "Oops! Dont quit" \
		-script "xhide /quit; xhide /file"
	create xbutton save [0:last,0:label,33%,30] -title "Save & Quit" \
		-script "do_save; quit"
	create xform /file [1,{TB},300,275]
	addfield /file is_visible -description "flag for visibility"
	setfield /file is_visible 0
	ce /file
	// see file save.g for open_reac and save_sim
	create xbutton open -label "Open file..." -script "xhide /file; xshow /opencontrol"
	/*
	create xdialog open -value dumpreac.g
		setfield open script "load_sim <v>"
	*/
	create xdialog save -value dumpreac.g
		setfield save script "do_save <v>"
	create xlabel notelab -label "NOTES"
	create xtext notes -hgeom 100 -editable 1
	create xbutton clear  -script do_clear \
		-label "Clear entire simulation"
	create xbutton quit  -script "xshow /quit"
	disable /file
	disable /quit
end

function make_opencontrol
	create xform /opencontrol [50,{TB},400,330]
	pushe /opencontrol
	create xtoggle allow_duplicated_msgs
	create xtoggle no_plots
	create xtoggle no_editcoords
	create xtoggle no_tab_or_stims
	create xtoggle dont_set_plotscales
	create xtoggle dont_set_drawscales
	create xtext instr_text -hgeom 100
	xtextload instr_text \
	"		Instructions:" \
	"In this version of Genesis, the parser cannot load" \
	"files specified in a dialog, so you must type the filename" \
	"at the command prompt and hit 'return' to load" \
	"in a script or dump file. Set the flags above" \
	"to control how the optional portions of a dumpfile" \
	"will be handled."
	create xbutton cancel  -script "xhide /opencontrol"
	pope
end


function do_set_all_graph_xmax(value)
	setfield /#graphs/#[TYPE=xgraph] xmax {value}
end

function do_set_all_graph_xmin(value)
	setfield /#graphs/#[TYPE=xgraph] xmin {value}
end

function do_set_all_graph_overlay(value)
	setfield /#graphs/#[TYPE=xgraph] overlay {value}
end

/*
function do_set_auto_plot(value)
	int value
	auto_plot = value
end
*/

function do_delete_all_plots
	str name
	foreach name ({el /#graphs/conc#[]/##[TYPE=xplot] })
		delete {name}
	end
	call /#graphs/conc#[] RESET
end

function plotsave(filename)
	str filename
	do_save_all_plots {filename}
	do_inform "Plots saved in "{filename}
end

function make_plotcontrol
	create xform /plotcontrol [360,{TB},300,320]
	addfield /plotcontrol is_visible -description "flag for visibility"
	setfield /plotcontrol is_visible 0
	ce /plotcontrol
	create xtoggle moregraphs -label "Show more graphs" \
		-script "xshow.d /moregraphs; xhide.u /moregraphs"
	create xdialog plotxmax -label "X-axis Max:" -value {MAXTIME} \
		-script "do_set_all_graph_xmax <v>"
	create xdialog plotxmin -label "X-axis Min:" -value 0 \
		-script "do_set_all_graph_xmin <v>"
	create xdialog plotymax -label "Y-axis Max:" -value 1 \
		-script "setfield /#graphs/# ymax <v>"
	create xdialog plotymin -label "Y-axis Min:" -value 0 \
		-script "setfield /#graphs/# ymin <v>"
	create xdialog graphdt -label "Clock dt for plots" -value 0.2 \
		-script "do_set_graph_dt <v>"
	create xtoggle plotoverlay -onlabel "Overlay all plots" \
		-offlabel "Do not overlay plots" \
		-script "do_set_all_graph_overlay <v>"
/*
	create xtoggle auto_plot -onlabel "Create plots automatically" \
		-offlabel "Create plots manually" \
		-script "do_set_auto_plot <v>"
*/
	create xtoggle disable -offlabel "Plots enabled" \
		-onlabel "Plots disabled" \
		-script "disable.d /graphs; disable.d /moregraphs; enable.u /graphs; enable.u /moregraphs"
	create xbutton delplot -label "Delete all plots" \
		-script "do_delete_all_plots"
	create xdialog saveplots -label "Save all plots to file:" \
		-script "plotsave <v>"
	create xbutton Cancel -script "xhide /plotcontrol"
	disable /plotcontrol
end

function do_munge_colors
	str name
	str color
	foreach name ({el /kinetics/##[]})
		if ({exists {name} xtree_fg_req})
			color = {getfield {name} xtree_fg_req}
			if ({strcmp {color} "white"} == 0)
				setfield {name} xtree_fg_req seagreen
			end
		end
	end
	call /edit/draw/tree RESET
end

function do_total_munge_colors
	str name
	str color
	int ncol
	foreach name ({el /kinetics/##[]})
		if ({exists {name} xtree_fg_req})
			ncol = 35 + {rand 0 20}
			setfield {name} xtree_fg_req {ncol}
			setfield {name} xtree_textfg_req black
		end
	end
	call /edit/draw/tree RESET
end

function make_pscontrol
	create xform /pscontrol [80,{TB},300,270]
	addfield /pscontrol is_visible -description "flag for visibility"
	setfield /pscontrol is_visible 0
	ce /pscontrol
	create xdialog maxgray -label "Max grayscale value:" -value 256 \
		-script "setpostscript -maxgray <v>"
	create xdialog mingray -label "Min grayscale value:" -value 0 \
		-script "setpostscript -mingray <v>"
	create xtoggle inverse -offlabel "Output not inverted" \
		-onlabel "Output inverted" \
		-script "setpostscript -inverse <v>"
	create xdialog psfile -label "File for postscript output:" \
		-value "display.ps" \
		-script "setpostscript -filename <v>"
	create xdialog gs -label "Preview file:" -value "display.ps" \
		-script "gs <v>"
	create xbutton munge -label "Replace white with green for output" \
		-script "do_munge_colors"
	create xbutton total_munge -label "Replace all colors for output " \
		-script "do_total_munge_colors"
	create xbutton Cancel -script "xhide /pscontrol"
	disable /pscontrol
end

function do_set_fastdt(dt)
	float dt
	FASTDT = dt
	setclock {FASTCLOCK} {FASTDT}
end

function do_set_simdt(dt)
	float dt
	SIMDT = dt
	setclock {SIMCLOCK} {SIMDT}
end

function do_set_controldt(dt)
	float dt
	CONTROLDT = dt
	setclock {CONTROLCLOCK} {CONTROLDT}
end

function do_set_graph_dt(dt)
	float dt
	PLOTDT = dt
	setclock {PLOTCLOCK} {PLOTDT}
end

function do_start_psearch
	if (!{exists /psearch})
		pbegin
	end
	xshow /pedit
end

function do_simctl_update
	setfield /simcontrol/fastdt value {FASTDT}
	setfield /simcontrol/simdt value {SIMDT}
	setfield /simcontrol/graphdt value {PLOTDT}
	setfield /simcontrol/controldt value {CONTROLDT}
end

function do_add_solver
	echo solver is currently disabled
	/*
	if ({exists  /solve})
		delete /solve
	end
	create ksolve /solve
	setfield /solve \
		path /kinetics/##[] \
		method 20
	call /solve SETUP
	xhide /simcontrol
	*/
end

function make_editcontrol
	create xform /editcontrol [60,{TB},300,200]
	ce /editcontrol
	create xlabel dummy -label "I do not yet know what to put here"
end

function make_toolcontrol
	create xform /toolcontrol [120,{TB},300,100]
	ce /toolcontrol
	create xbutton ps -label "Postscript..." \
		-script "xhide /toolcontrol; xshow /pscontrol"
	create xbutton plot -label "Plot..." \
		-script "xhide /toolcontrol; xshow /plotcontrol"
	create xbutton compare -label "Compare models..." \
		-script "xhide /toolcontrol; xshow /comparecontrol"
end

function make_simcontrol
	create xform /simcontrol [240,{TB},300,350]
	addfield /simcontrol is_visible -description "flag for visibility"
	setfield /simcontrol is_visible 0
	ce /simcontrol
	create xdialog fastdt -label "Clock 0 dt for simulation" \
		-value {FASTDT} \
		-script "do_set_fastdt <v>"
	create xdialog simdt -label "Clock 1 dt for simulation" \
		-value {SIMDT} \
		-script "do_set_simdt <v>"
	create xdialog graphdt -label "Clock dt for plots" \
		-value {PLOTDT} \
		-script "do_set_graph_dt <v>"
	create xdialog controldt -label "Clock dt for control" \
		-value {CONTROLDT} \
		-script "do_set_controldt <v>"
	create xtoggle high_order -onlabel "Higher order reacs enabled" \
		-offlabel "Higher order reacs disabled"

	create xtoggle poolsumtot -onlabel "pool-to-pool uses SUMTOTAL" \
		-offlabel "pool-to-pool uses CONSERVE"

	create xtoggle enzconsv -onlabel "Enz-to-pool uses nComplex for CONSERVE" \
		-offlabel "Normal Enz-to-pool : not CONSERVE"

	create xtoggle enzsumtot -onlabel "Enz-to-pool uses nComplex for SUMTOTAL" \
		-offlabel "Normal Enz-to-pool : not SUMTOTAL"

	create xtoggle enzintramol -onlabel "pool-to-enz uses n for INTRAMOL" \
		-offlabel "Normal pool-to-enz : not INTRAMOL"
	create xtoggle kf -onlabel "pool-to-reac uses Co for kf" \
		-offlabel "Normal pool-to-reac : not KF" \
		-script "setfield /simcontrol/kb state 0"
	create xtoggle kb -onlabel "pool-to-reac uses Co for kb" \
		-offlabel "Normal pool-to-reac : not KB" \
		-script "setfield /simcontrol/kf state 0"


	// create xbutton add_solver -label "Add solver" -script do_add_solver

	create xbutton Cancel -script "xhide /simcontrol"

	disable /simcontrol
end

function make_simhelp
	create xform /simhelp [{EX},0,{EW},{WINHT}]
	create xbutton /simhelp/about -label "About kkit" \
		-script "xshow /about; xhide /simhelp"
	create xtext /simhelp/text -hgeom {WINHT - 60} \
		-filename "Kkit.help"
	create xbutton /simhelp/hide -script "xhide /simhelp"
	disable /simhelp
end
