static char rcsid[] = "$Id: shell_debug.c,v 1.3 1997/07/18 02:55:46 dhb Exp $";

/*
** $Log: shell_debug.c,v $
** Revision 1.3  1997/07/18 02:55:46  dhb
** Fix to getopt problem.  getopt(), optopt and optind are now
** G_getopt(), G_optopt and G_optind.
**
** Revision 1.2  1993/02/26 22:08:59  dhb
** 1.4 to 2.0 command argument changes.
**
** Revision 1.1  1992/12/11  19:04:24  dhb
** Initial revision
**
*/

#include "shell_ext.h"

int do_debug(argc,argv)
int	argc;
char	**argv;
{
    initopt(argc, argv, "[level]");
    if (G_getopt(argc, argv) != 0 || optargc > 2)
      {
	printoptusage(argc, argv);
	return 0;
      }

    if (optargc == 2)
	debug = atoi(argv[1]);

    if(IsSilent()<1)
	printf("debug level %d\n",debug);
    return(debug);
}

int do_debug_func(argc,argv)
int	argc;
char	**argv;
{
char	debug_name[100];
int	*debug_ptr;

    initopt(argc, argv, "function [level]");
    if (G_getopt(argc, argv) != 0 || optargc > 3)
      {
	printoptusage(argc, argv);
	return 0;
      }

    sprintf(debug_name,"DEBUG_%s",optargv[1]);
    /* LATER look up global vars more safely */
    if((debug_ptr = (int *)GetFuncAddress(debug_name)) == NULL){
	printf("unable to selectively debug function '%s'\n",optargv[1]);
	return(0);
    }

    if(optargc == 3)
	*debug_ptr = atoi(optargv[2]);

    /*
    ** locate the debug variable for the function
    */
    if(IsSilent()<1){
	printf("debug level %d\n",debug + *debug_ptr);
    }
    return(debug + *debug_ptr);
}

