//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/
/* graphics for upi's simulation of second messengers in LTP
*/

function do_inform
end

// Dummy function, defined later.
function	do_save_all_plots
end

function do_run
	setfield /#graphs/#[TYPE=xgraph] xmax {{getstat -time} + MAXTIME}
	if (VARIABLE_DT_FLAG)
		setfield /control/dt label "dt = "{FASTDT}
		setclock {SIMCLOCK} {FASTDT}
		step {TRANSIENT_TIME} -time
		setfield /control/dt label "dt = "{SIMDT}
		setclock {SIMCLOCK} {SIMDT}
		setclock {DUMMYCLOCK} {SIMDT}
		step {MAXTIME - TRANSIENT_TIME} -time
	else
		setfield /control/dt label "dt = "{SIMDT}
		step {MAXTIME} -time
	end
end

function set_runtime
	MAXTIME = {getfield /control/runtime value}
	// setfield /#graphs/#[TYPE=xgraph] xmax {MAXTIME}
	// TABLEDT = MAXTIME/TABLESIZE
	// setclock {TABLECLOCK} {TABLEDT}
end

function update_time
	setfield /control/simtime value {getstat -time}
end

function do_reset
	str name

	/*
	foreach name ({el /kinetics/##[TYPE=xtab]})
		setfield {name} input 0
	end
	*/

	resetfastmsg
 	reset
end

function make_xcontrol
	create xform /control [1,1,{TW},{TH}]
	ce /control
	create xtoggle file [0,0,16%,30] \
		-script "xshow.d /file; xhide.u /file" -label "File"
	create xtoggle edit [0:last,0,17%,30] \
		-script "xshow.d /editcontrol; xhide.u /editcontrol" -label "Units"
	create xtoggle tools [0:last,0,17%,30] \
		-script "xshow.d /toolcontrol; xhide.u /toolcontrol" -label "Tools"
	create xtoggle simctl [0:last,0,17%,30] \
		-script "do_simctl_update.d; xshow.d /simcontrol; xhide.u /simcontrol" \
		-label "Options"
	create xtoggle graph [0:last,0,17%,30] \
		-script "xshow.d /plotcontrol; xhide.u /plotcontrol" -label "Graphs"
	create xtoggle simhelp [0:last,0,16%,30] \
		-script "xshow.d /simhelp; xhide.u /simhelp" \
		-label "Help"
	create xbutton start  [0,0:file,33%,30] -script "do_run" -offbg green
	create xbutton stop  [0:last,0:file,34%,30] -script "stop" -offbg yellow
	create xbutton reset  [0:last,0:file,33%,30] \
		 -script "do_reset" -offbg red
	create xdialog runtime -title "Runtime (sec)" -value {MAXTIME} \
		-script set_runtime [0,0:start,40%,30]
	create xlabel dt [0:last,0:start,20%,30] -title "dt = "{SIMDT}
	create xdialog simtime -title "Current time" -value 0 \
		[0:last,0:start,40%,30]
	addaction simtime PROCESS update_time
	useclock simtime {CONTROLCLOCK}
	disable /control/runtime
	disable /control/file
	disable /control/tools
	disable /control/graph
	disable /control/start
	disable /control/reset
	disable /control/edit
	disable /control/simctl
	disable /control/simhelp
	disable /control/stop
	// xshow /control
end

function do_clear
	str name
	foreach name ({el /#graphs/#/#[TYPE=xplot]})
		delete name
	end
	delete /kinetics
	create group /kinetics
	call /edit/draw/tree RESET
	reset
end


function make_xfile
	create xform /quit [1,450,500,70]
	ce /quit
	create xlabel label -title "Did you save your work ?"
	create xbutton yes [0,0:label,33%,30] -title "Yes, Quit" -script quit
	create xbutton no [0:last,0:label,34%,30] -title "Oops! Dont quit" \
		-script "xhide /quit; xhide /file"
	create xbutton save [0:last,0:label,33%,30] -title "Save & Quit" \
		-script "do_save; quit"
	create xform /file [1,{TB},300,275]
	addfield /file is_visible -description "flag for visibility"
	setfield /file is_visible 0
	ce /file
	// see file save.g for open_reac and save_sim
	create xbutton open -label "Open file..." -script "xhide /file; xshow /opencontrol"
	/*
	create xdialog open -value dumpreac.g
		setfield open script "load_sim <v>"
	*/
	create xdialog save -label "Save model to file:" -value dumpreac.g
		setfield save script "do_save <v>"
	create xlabel notelab -label "NOTES"
	create xtext notes -hgeom 100 -editable 1
	create xbutton clear  -script do_clear \
		-label "Clear entire simulation"
	create xbutton quit  -script "xshow /quit"
	disable /file
	disable /quit
end

function make_opencontrol
	create xform /opencontrol [50,{TB},400,330]
	pushe /opencontrol
	create xtoggle allow_duplicated_msgs
	create xtoggle no_plots
	create xtoggle no_editcoords
	create xtoggle no_tab_or_stims
	create xtoggle dont_set_plotscales
	create xtoggle dont_set_drawscales
	create xtext instr_text -hgeom 100
	xtextload instr_text \
	"		Instructions:" \
	"In this version of Genesis, the parser cannot load" \
	"files specified in a dialog, so you must type the filename" \
	"at the command prompt and hit 'return' to load" \
	"in a script or dump file. Set the flags above" \
	"to control how the optional portions of a dumpfile" \
	"will be handled."
	create xbutton cancel  -script "xhide /opencontrol"
	pope
end


function do_set_all_graph_field(field,value)
	setfield /#graphs/#[TYPE=xgraph] {field} {value}
end

function do_delete_all_plots
	str name
	foreach name ({el /#graphs/conc#[]/##[TYPE=xplot] })
		delete {name}
	end
	call /#graphs/conc#[] RESET
end

function plotsave(filename)
	str filename
	do_save_all_plots {filename}
	do_inform "Plots saved in "{filename}
end

function do_convert_plots_to_tabs
	str name
	str src
	str field
	str srcname
	str tabname
	int xdivs = {MAXTIME / PLOTDT}

	if (!{exists /tabs})
		create neutral /tabs
	end

	foreach name ({el /#graphs/conc#[]/##[TYPE=xplot] })
		src = {getmsg {name} -source 0}
		srcname = {getpath {src} -tail}
		field = {getfield {src} plotfield}
		tabname = "/tabs/" @ {srcname} @ "_" @ {field}
		create xtab {tabname}
		setfield {tabname} step_mode 3
		call {tabname} TABCREATE {xdivs} 0 {xdivs}
		addmsg {src} {tabname} INPUT {field}
		useclock {tabname} {PLOTCLOCK}

		delete {name}
	end

	call /#graphs/conc#[] RESET
	call /tabs/# RESET
end

function make_plotcontrol
	create xform /plotcontrol [360,{TB},320,405]
	addfield /plotcontrol is_visible -description "flag for visibility"
	setfield /plotcontrol is_visible 0
	ce /plotcontrol
	create xlabel limits -label "Graph Axis Limits" -bg cyan
	create xdialog plotxmax -label "X-axis Max:" -value {MAXTIME} \
		-script "do_set_all_graph_field xmax <v>"
	create xdialog plotxmin -label "X-axis Min:" -value 0 \
		-script "do_set_all_graph_field xmin <v>"
	create xdialog plotymax -label "Y-axis Max:" -value 1 \
		-script "do_set_all_graph_field ymax <v>"
	create xdialog plotymin -label "Y-axis Min:" -value 0 \
		-script "do_set_all_graph_field ymin <v>"
	create xlabel plotdisp -label "Plot Display Options" -bg cyan
	create xtoggle moregraphs -label "Show more graphs" \
		-script "xshow.d /moregraphs; xhide.u /moregraphs"
	create xtoggle plotoverlay -onlabel "Overlay all plots" \
		-offlabel "Do not overlay plots" \
		-script "do_set_all_graph_field overlay <v>"
	create xtoggle disable -offlabel "Plots enabled" \
		-onlabel "Plots disabled" \
		-script "disable.d /graphs; disable.d /moregraphs; enable.u /graphs; enable.u /moregraphs"
	create xbutton delplot -label "Delete all plots" \
		-script "do_delete_all_plots"
	create xlabel plotopt -label "Other Graph Options" -bg cyan
	// create xbutton tabplot -label "Convert all plots to tables" \
		// -script "do_convert_plots_to_tabs"
	create xdialog saveplots -label "Save all plots to file:" \
		-script "plotsave <v>" -value "data.plot"
	create xbutton Cancel -script "xhide /plotcontrol"
	disable /plotcontrol
end

function do_munge_colors
	str name
	str color
	foreach name ({el /kinetics/##[]})
		if ({exists {name} xtree_fg_req})
			color = {getfield {name} xtree_fg_req}
			if ({strcmp {color} "white"} == 0)
				setfield {name} xtree_fg_req seagreen
			end
		end
	end
	call /edit/draw/tree RESET
end

function do_total_munge_colors
	str name
	str color
	int ncol
	foreach name ({el /kinetics/##[]})
		if ({exists {name} xtree_fg_req})
			ncol = 35 + {rand 0 20}
			setfield {name} xtree_fg_req {ncol}
			setfield {name} xtree_textfg_req black
		end
	end
	call /edit/draw/tree RESET
end

function do_bw_colors
	str name
	str color
	int ncol
	foreach name ({el /kinetics/##[]})
		if ({exists {name} xtree_fg_req})
			if ({isa pool {name}})
				setfield {name} xtree_fg_req cyan
			else
				setfield {name} xtree_fg_req black
			end
			setfield {name} xtree_textfg_req black
		end
	end
	setdefault kpool xtree_fg_req cyan
	setdefault kreac xtree_fg_req black
	setdefault xtab xtree_fg_req black
	setdefault xtab xtree_textfg_req black
	setdefault group xtree_fg_req black
	setdefault transport xtree_fg_req black
	setdefault kchan xtree_textfg_req black
	setdefault stim xtree_textfg_req black
	setdefault stim xtree_fg_req black

	setfield /graphs/conc1 bg gray90
	setfield /graphs/conc2 bg gray90
	setfield /moregraphs/conc3 bg gray90
	setfield /moregraphs/conc4 bg gray90
	setfield /graphs/conc#/# fg black
	setfield /moregraphs/conc#/# fg black

	setfield /control/#[TYPE=xtoggle] offbg gray90
	setfield /control/#[TYPE=xdialog] bg gray90
	setfield /control/#[TYPE=xlabel] bg gray90
	setfield /control/reset offbg pink

	setfield /parmedit/pool/#[TYPE=xdialog] bg gray90
	setfield /parmedit/pool/#[TYPE=xtoggle] offbg gray90
	setfield /parmedit/pool/#[TYPE=xbutton] offbg gray90
	setfield /parmedit/pool/#[TYPE=xtext] bg gray90

	setfield /edit/draw bg gray90
	setfield /control/lib bg gray90

	call /edit/draw/tree RESET
	call /control/lib/tree RESET
end

function make_pscontrol
	create xform /pscontrol [80,{TB},300,270]
	addfield /pscontrol is_visible -description "flag for visibility"
	setfield /pscontrol is_visible 0
	ce /pscontrol
	create xdialog maxgray -label "Max grayscale value:" -value 256 \
		-script "setpostscript -maxgray <v>"
	create xdialog mingray -label "Min grayscale value:" -value 0 \
		-script "setpostscript -mingray <v>"
	create xtoggle inverse -offlabel "Output not inverted" \
		-onlabel "Output inverted" \
		-script "setpostscript -inverse <v>"
	create xdialog psfile -label "File for postscript output:" \
		-value "display.ps" \
		-script "setpostscript -filename <v>"
	create xdialog gs -label "Preview file:" -value "display.ps" \
		-script "gs <v>"
	create xbutton munge -label "Replace white with green for output" \
		-script "do_munge_colors"
	create xbutton total_munge -label "Replace all colors for output " \
		-script "do_total_munge_colors"
	create xbutton bw -label "Use B/W for output " \
		-script "do_bw_colors"
	create xbutton Cancel -script "xhide /pscontrol"
	disable /pscontrol
end


function do_set_controldt(dt)
	float dt
	CONTROLDT = dt
	setclock {CONTROLCLOCK} {CONTROLDT}
end

function do_set_graph_dt(dt)
	float dt
	PLOTDT = dt
	setclock {PLOTCLOCK} {PLOTDT}
end

function do_start_psearch
	if (!{exists /psearch})
		pbegin
	end
	xshow /pedit
end

// Enables/disables variable dt runs.
function do_set_vardt(v)
	int v
	VARIABLE_DT_FLAG = v
	if (v)
		setfield /simcontrol/fastdt fg black
		setfield /simcontrol/transient_time fg black
		setfield /control/start label "start (variable dt)"
		setfield /control/dt label "dt = "{FASTDT}
	else
		setfield /simcontrol/fastdt fg darkgray
		setfield /simcontrol/transient_time fg darkgray
		setfield /control/start label "start"
		setfield /control/dt label "dt = "{SIMDT}
	end
end

function do_simctl_update
	setfield /simcontrol/simdt value {SIMDT}
	setfield /simcontrol/fastdt value {FASTDT}
	setfield /simcontrol/graphdt value {PLOTDT}
	setfield /simcontrol/controldt value {CONTROLDT}
	setfield /simcontrol/vardt state {VARIABLE_DT_FLAG}
	do_set_vardt {VARIABLE_DT_FLAG}
end

function do_set_simdt(dt)
	float dt
	SIMDT = dt
	setclock {SIMCLOCK} {SIMDT}
	setclock {DUMMYCLOCK} {SIMDT}
	do_simctl_update
end

function do_add_solver
	echo solver is currently disabled
	/*
	if ({exists  /solve})
		delete /solve
	end
	create ksolve /solve
	setfield /solve \
		path /kinetics/##[] \
		method 20
	call /solve SETUP
	xhide /simcontrol
	*/
end

function do_set_markov(state)
	int state
	setfield /kinetics/##[ISA=reac] markof_flag {state}
	setfield /kinetics/##[ISA=enz] markof_flag {state}
	setfield /kinetics/##[ISA=pool] markof_flag {state}
end

function do_update_poolinfo
// dummy
end

function update_all_pool_realvol
// dummy
end

function update_all_pool_vol
// dummy
end

function do_update_reacinfo
// dummy
end

function do_update_transportinfo
// dummy
end

function do_update_enzinfo
// dummy
end

function update_all_enz_vol
// dummy
end

function select_conc_units(v)
	update_all_pool_realvol
	if (v == 2)
		setfield /editcontrol/mM state 1
		setfield /editcontrol/nM state 0
		setfield /editcontrol/uM state 0
		setfield /editcontrol/conc unitname mM	// mM is SI.
	else 
		setfield /editcontrol/nM state {1 - v}
		setfield /editcontrol/uM state {v}
		setfield /editcontrol/mM state 0
		if (v == 1)
			setfield /editcontrol/conc unitname uM
		else
			setfield /editcontrol/conc unitname nM
		end
	end
	setfield /editcontrol/conc units {v}
	setfield /editcontrol/conc scalefactor {pow 10 {(2 - v) * 3}}
	update_all_pool_vol
	update_all_enz_vol
	do_update_poolinfo
	do_update_enzinfo
	do_update_reacinfo
end

function select_time_units(v)
	setfield /editcontrol/Seconds state {1-v}
	setfield /editcontrol/Minutes state {v}
	setfield /editcontrol/time units {v}
	setfield /editcontrol/time scalefactor {v * 59 + 1} //1 and 60
	if (v)
		setfield /editcontrol/time unitname min
	else
		setfield /editcontrol/time unitname sec
	end
	do_update_enzinfo
	do_update_reacinfo
	do_update_transportinfo
end

function set_dia(dia)
	float dia
	setfield /editcontrol/vol value {dia * dia * dia * 1.5e-18 / 3.14159267}
end

function set_vol(vol)
	float vol
	setfield /editcontrol/dia value {pow {vol * 3.14159267e18 / 1.5} {1.0/3.0}}
end

function make_editcontrol
	create xform /editcontrol [60,{TB},300,220]
	ce /editcontrol
	create xlabel time [0,0:NULL,50%,] -label "Time units" -bg cyan
	addfield time units
	addfield time unitname
	addfield time scalefactor
	create xtoggle Seconds [0,0:last,50%,] -script "select_time_units 0"
	create xtoggle Minutes [0,0:last,50%,] -script "select_time_units 1"
	create xlabel conc [50%,0:NULL,50%,] -label "Concentration units" -bg cyan
	addfield conc units
	addfield conc unitname
	addfield conc scalefactor
	setfield conc scalefactor 1000 // The default conc is uM
	create xtoggle nM [50%,0:last,50%,] -script "select_conc_units 0"
	create xtoggle uM [50%,0:last,50%,] -script "select_conc_units 1"
	create xtoggle mM [50%,0:last,50%,] -script "select_conc_units 2"

	create xlabel l2 -label "Default pool size" -bg cyan
	create xdialog vol -label "Volume (m^3)" \
		-value {DEFAULT_VOL} -script "set_vol <v>"
	create xdialog dia -label "Diameter (um)" \
		-script "set_dia <v>"


	create xbutton HIDE -script "xhide /editcontrol"

	ce /

	set_vol {DEFAULT_VOL}
	select_time_units 0
	select_conc_units 1
end

function make_toolcontrol
	create xform /toolcontrol [120,{TB},300,150]
	ce /toolcontrol
	create xbutton ps -label "Postscript..." \
		-script "xhide /toolcontrol; xshow /pscontrol"
	create xbutton plot -label "Plot..." \
		-script "xhide /toolcontrol; xshow /plotcontrol"
	create xbutton compare -label "Compare models..." \
		-script "xhide /toolcontrol; xshow /comparecontrol"
	create xdialog tabulate -label "Tabulate model parms" \
		-value tabfile \
		-script "xhide /toolcontrol; do_tabulate_model <v>"
	create xbutton complex_copy -label "Copying tool..." \
		-script "xhide /toolcontrol; xshow /copy"
end


// Sets the fastclock for variable dt runs.
function do_set_fastdt(v)
	float v
	FASTDT = v
	do_simctl_update
end

// Sets the fastclock for variable dt runs.
function do_set_transient_time(v)
	float v
	TRANSIENT_TIME = v
end

function make_simcontrol
	create xform /simcontrol [240,{TB},300,500]
	addfield /simcontrol is_visible -description "flag for visibility"
	setfield /simcontrol is_visible 0
	ce /simcontrol
	create xlabel clocklabel -label "Timestep Control" -bg cyan
	create xdialog simdt -label "Clock dt for simulation" \
		-value {SIMDT} \
		-script "do_set_simdt <v>"
	create xdialog graphdt -label "Clock dt for plots" \
		-value {PLOTDT} \
		-script "do_set_graph_dt <v>"
	create xdialog controldt -label "Clock dt for control" \
		-value {CONTROLDT} \
		-script "do_set_controldt <v>"
	create xtoggle vardt -offlabel "Uniform dt" \
		-onlabel "Variable dt" \
		-script "do_set_vardt <v>"
	create xdialog fastdt -label "dt for transients" \
		-value {FASTDT} -fg darkgray \
		-script "do_set_fastdt <v>"
	create xdialog transient_time -label "Transient settling time" \
		-value {TRANSIENT_TIME} -fg darkgray \
		-script "do_set_transient_time <v>"
	create xlabel reaclabel -label "Reaction Options" -bg cyan
	create xtoggle high_order -onlabel "Higher order reacs enabled" \
		-offlabel "Higher order reacs disabled"

	create xtoggle poolsumtot -onlabel "pool-to-pool uses SUMTOTAL" \
		-offlabel "pool-to-pool uses CONSERVE"

	create xtoggle enzconsv -onlabel "Enz-to-pool uses nComplex for CONSERVE" \
		-offlabel "Normal Enz-to-pool : not CONSERVE"

	create xtoggle enzsumtot -onlabel "Enz-to-pool uses nComplex for SUMTOTAL" \
		-offlabel "Normal Enz-to-pool : not SUMTOTAL"

	create xtoggle enzintramol -onlabel "pool-to-enz uses n for INTRAMOL" \
		-offlabel "Normal pool-to-enz : not INTRAMOL"
	create xtoggle kf -onlabel "pool-to-reac uses Co for kf" \
		-offlabel "Normal pool-to-reac : not KF" \
		-script "setfield /simcontrol/kb state 0"
	create xtoggle kb -onlabel "pool-to-reac uses Co for kb" \
		-offlabel "Normal pool-to-reac : not KB" \
		-script "setfield /simcontrol/kf state 0"


	// create xbutton add_solver -label "Add solver" -script do_add_solver
	create xtoggle markov -onlabel "Stochastic Markov processes ON" \
		-offlabel "Continuous integration ON" \
		-script "do_set_markov <v>"

	create xbutton Cancel -script "xhide /simcontrol"

	disable /simcontrol
end

function make_simhelp
	create xform /simhelp [{EX},0,{EW},{WINHT}]
	create xbutton /simhelp/about -label "About kkit" \
		-script "xshow /about; xhide /simhelp"
	create xtext /simhelp/text -hgeom {WINHT - 60} \
		-filename "Kkit.help"
	create xbutton /simhelp/hide -script "xhide /simhelp"
	disable /simhelp
end
