//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/
// xsave.g : implements the save/restore capabilities of kkit
int dump_x = 1

function save_sim(filename, group)
	str filename
	str group
	int group_only
	if ({exists {group}} == 1)
		group_only = 1
	else
		group_only = 0
	end

	do_inform {"Saving file" @ {filename}}
	openfile {filename} "w"
	writefile {filename} "//genesis"
	writefile {filename} "// kkit Version 7 dumpfile"
	writefile {filename} " "
	writefile {filename} {"// Saved on " @ {getdate}}
	writefile {filename} " "
	writefile {filename} "include kkit {argv 1}"
	writefile {filename} " "

	// Note that in kkit7 FASTDT is now used for transient calculations
	writefile {filename} "FASTDT = "{FASTDT}
	writefile {filename} "SIMDT = "{SIMDT}
	writefile {filename} "CONTROLDT = "{CONTROLDT}
	writefile {filename} "PLOTDT = "{PLOTDT}
	// writefile {filename} "TABLEDT = "{TABLEDT}
	writefile {filename} "MAXTIME = "{MAXTIME}

	// Below here, the parms are post-version 6. For bc,
	// I set them up including their type definitions.
	// In post-version 7 kkits I will clean this up.
	writefile {filename} "float TRANSIENT_TIME = "{TRANSIENT_TIME}
	writefile {filename} "int VARIABLE_DT_FLAG = "{VARIABLE_DT_FLAG}
	writefile {filename} "float DEFAULT_VOL = "{getfield /editcontrol/vol value}
	writefile {filename} "kparms"
	writefile {filename} " "

	closefile {filename}

	/* We have moved initdump to the kbegin function in ksim,
	** since we want to let each object init its own fields.
	*/
	// initdump 

	// swap in the current simulation context for dumps
	swapdump
	if (dump_x)
		if (group_only)
			simdump {filename} -path {group} \
				-path {group}/##[] \
				-path /kinetics/#[TYPE=kpool] \
				-path /kinetics/#[]/#[TYPE=kenz] \
				-path /edit/draw \
				-path /edit/draw/tree \
				-path /file/notes
		else
			simdump {filename} -path /kinetics/##[] \
				-path /psearch/##[] \
				-path /graphs/#[TYPE=xgraph] \
				-path /graphs/#[]/#[TYPE=xplot] \
				-path /moregraphs/#[TYPE=xgraph] \
				-path /moregraphs/#[]/#[TYPE=xplot] \
				-path /edit/draw \
				-path /edit/draw/tree \
				-path /file/notes
		end
	else
		if (group_only)
			simdump {filename} -path {group} \
				-path {group}/##[] \
				-path /kinetics/#[TYPE=kpool] \
				-path /kinetics/#[]/#[TYPE=kenz]
		else
			simdump {filename} -path /kinetics/##[] \
				-path /psearch/##[]
		end
	end
	// swap out the current simulation context for dumps
	swapdump

	openfile {filename} "a"

	if (dump_x)
		writefile {filename} "call /edit/draw/tree RESET"
	end

	writefile {filename} "fix_transp_msgs"
	writefile {filename} "reset"
	closefile {filename}

	do_inform {"Finished saving file " @ {filename}}
	xflushevents
	xhide /inform
	xhide /file

/* need to figure out how to dump and restore connections to graphs
** also how to overlay an old sim onto a new one
*/

end

function load_sim(filename)
	str filename
	str foo = filename

	do_inform {"Loading file " @ {foo}}
	/*
	echo {filename}
	source {filename}
	*/

	do_inform {"Finished loading file " @ {filename}}
	xflushevents
	xhide /inform
	xhide /file
end

function do_save
    str dest = {getfield /file/save value}
    save_sim {dest} __nothere
end
