/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  treeviewcolumnsignals.cc - Gtk::TreeViewColumn virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "treeviewcolumn.hh"
#include "treeviewcolumnsignals.hh"
#include "private/treeviewcolumnclass.hh"

using namespace GFC;

/*  Gtk::TreeViewColumnSignals
 */

Gtk::TreeViewColumnSignals::TreeViewColumnSignals(TreeViewColumn *tree_column)
: ObjectSignals(tree_column)
{
	Gtk::TreeViewColumnClass::init(GTK_TREE_VIEW_COLUMN_GET_CLASS(tree_column->gtk_tree_view_column()));
}
	
Gtk::TreeViewColumnSignals::~TreeViewColumnSignals()
{
}

void
Gtk::TreeViewColumnSignals::on_clicked()
{
	GtkTreeViewColumnClass *g_class = TreeViewColumnClass::get_parent_class(instance_);
	if (g_class->clicked)
		g_class->clicked((GtkTreeViewColumn*)instance_);
}

/*  Gtk::TreeViewColumnClass
 */

void
Gtk::TreeViewColumnClass::init(GtkTreeViewColumnClass *g_class)
{
	g_class->clicked = &clicked_proxy;
}

GtkTreeViewColumnClass*
Gtk::TreeViewColumnClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TREE_VIEW_COLUMN_GET_CLASS(instance));
	return static_cast<GtkTreeViewColumnClass*>(ptr);
}

GType
Gtk::TreeViewColumnClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TREE_VIEW_COLUMN);
	}
	return type;
}

void*
Gtk::TreeViewColumnClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::TreeViewColumnClass::clicked_proxy(GtkTreeViewColumn *tree_column)
{
	void *ptr = g_object_get_qdata((GObject*)tree_column, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TreeViewColumnSignals*>(ptr)->on_clicked();
	else
	{
		GtkTreeViewColumnClass *g_class = TreeViewColumnClass::get_parent_class(tree_column);
		if (g_class->clicked)
			g_class->clicked(tree_column);
	}
}

