// T3PREFS.H: Handle user preferences/configuration 
//            with GNOME config and/or dialogues

// Copyright (C) 2001 Geoffrey Hutchison

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef T3PREFS_H
#define T3PREFS_H

/*################################################################################################*/

#include "config.h"
#include "prefs.h"

/*################################################################################################*/

/**	Various methods for setting or getting user prefs
	with the gnome_config* methods
*/

class gnome_prefs : public prefs
{
	protected:
	
	public:
	
	gnome_prefs(void);
	~gnome_prefs(void);

	void Add(const char *, const char *);
	void Add(const char *, const int);
	void Add(const char *, const double);
	void Add(const char *, const bool);
	void Add(const char *, const float, const float, const float);
	void Add(const char *, const float, const float, const float, const float);

	// Get preferences (key, default value)
	char * Find(const char *, const char *);
	int    Value(const char *, const int);
	double Double(const char *, const double);
	bool   Boolean(const char *, const bool);
	float *ColorRGB(const char *, const float[3]);
	float *ColorRGBA(const char *, const float[4]);

 private:
	char	keybuffer[1024];
};

/*################################################################################################*/

#endif	// T3PREFS_H

// eof
