// GAMESS_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "ghemicalconfig2.h"

#ifdef ENABLE_GAMESS

#include "gamess_dialog.h"
#include "filetrans.h"

#include <ghemical/eng1_mm.h>

#include <iostream>
#include <sstream>
#include <sstream>
#include <string>


#include <gtk/gtk.h>
using namespace std;


#define TYPE_NONE		-1
#define TYPE_MENU    	0
#define TYPE_CKBUTTON 	1
#define TYPE_RADIOBTN   2
#define TYPE_EDIT 	3


#define VALID   1
#define INVALID 0


#define CONFIG_FILTER  "*.inp"
#define INP_TYPE 15
#define GMS_EXE "gtk-gamess"

typedef struct UI_STRUCT 
{
	char* ui_name;
	int option_base;
	void* root;
	int value;
}UI_STRUCT;

typedef struct OPTION_STRING
{
	char* option;
	char* keyword;
	char* value;
};

const OPTION_STRING  option_string[] =
{
	/* general->calculate  option menu */
	{"", "",""},/* " $CONTRL RUNTYP=ENERGY $END\n" */
	{" $CONTRL RUNTYP=OPTIMIZE $END\n", "", ""},
	{" $CONTRL RUNTYP=SADPOINT $END\n $STATPT HESS=CALC $END\n", "", ""},
	{" $CONTRL RUNTYP=HESSIAN $END\n", "", ""},

	/* general->width.left option menu */
	{" $BASIS GBASIS=AM1 $END\n", "", ""},
	{" $BASIS GBASIS=PM3 $END\n", "", ""},
	{"", "", ""},
	{" $DFT DFTTYP=B3LYP $END\n", "", ""},
	{" $CONTRL MPLEVL=2 $END\n", "", ""},
	{" $CONTRL CCTYP=CCSD(T) $END\n", "", ""},

	/* general->width.right option menu */
	{" $BASIS GBASIS=STO NGAUSS=3 $END\n", "", ""},
	{" $BASIS GBASIS=MINI $END\n", "", ""},
	{" $BASIS GBASIS=N21 NGAUSS=3 $END\n", "", ""},
	{" $BASIS GBASIS=N31 NGAUSS=6 NDFUNC=1 $END\n", "", ""},
	{" $BASIS GBASIS=N31 NGAUSS=6 NDFUNC=1 NPFUNC=1 $END\n", "", ""},
	{" $BASIS GBASIS=N31 NGAUSS=6 NDFUNC=1 NPFUNC=1 DIFFSP=.T. $END\n", "", ""},
	{" $BASIS GBASIS=N31 NGAUSS=6 NDFUNC=2 NPFUNC=1 DIFFSP=.T. $END\n", "", ""},
	{" $BASIS GBASIS=N311 NGAUSS=6 NDFUNC=1 NPFUNC=1 DIFFSP=.T. DIFFS=.T. $END\n", "", ""},
	{" $BASIS GBASIS=SBKJC NDFUNC=1 $END\n $CONTRL ECP=SBKJC $END\n", "", ""},

	/* general->in option menu */
	{"", "", ""},
	{" $PCM SOLVNT=WATER $END\n", "", ""},

	/* general->on.left option menu */
	{"", "", ""},
	{" $CONTRL SCFTYP=ROHF MULT=2 $END\n", "", ""},
	{" $CONTRL SCFTYP=ROHF MULT=3 $END\n", "", ""},

	/* general->on.right option menu */
	{" $CONTRL ICHARG=2 $END\n", "ICHARG", "2"},
	{" $CONTRL ICHARG=1 $END\n", "ICHARG", "1"},
	{"", "", ""},
	{" $CONTRL ICHARG=-1 $END\n", "ICHARG", "-1"},
	{" $CONTRL ICHARG=-2 $END\n", "ICHARG", "-2"},

	/* basis->basis set option menu */
	{" $BASIS GBASIS=MINI $END\n", "", ""},
	{" $BASIS GBASIS=MIDI $END\n", "", ""},
	{" $BASIS GBASIS=STO NGAUSS=2 $END\n", "", ""},
	{" $BASIS GBASIS=STO NGAUSS=3 $END\n", "", ""},
	{" $BASIS GBASIS=STO NGAUSS=4 $END\n", "", ""},
	{" $BASIS GBASIS=STO NGAUSS=5 $END\n", "", ""},
	{" $BASIS GBASIS=STO NGAUSS=6 $END\n", "", ""},
	{" $BASIS GBASIS=N21 NGAUSS=3 $END\n", "", ""},
	{" $BASIS GBASIS=N21 NGAUSS=6 $END\n", "", ""},
	{" $BASIS GBASIS=N31 NGAUSS=4 $END\n", "", ""},
	{" $BASIS GBASIS=N31 NGAUSS=5 $END\n", "", ""},
	{" $BASIS GBASIS=N31 NGAUSS=6 $END\n", "", ""},
	{" $BASIS GBASIS=N311 NGAUSS=6 $END\n", "", ""},
	
	{" $BASIS GBASIS=DZV $END\n", "", ""},
	{" $BASIS GBASIS=DH $END\n", "", ""},
	{" $BASIS GBASIS=TZV $END\n", "", ""},
	{" $BASIS GBASIS=MC $END\n", "", ""},


	{" $BASIS GBASIS=SBKJC $END\n", "", ""},
	{" $BASIS GBASIS=HW $END\n", "", ""},

	{" $BASIS GBASIS=MNDO $END\n", "", ""},
	{" $BASIS GBASIS=AM1 $END\n", "", ""},
	{" $BASIS GBASIS=PM3 $END\n", "", ""},

	/* basis->ecp option menu */
	{"", "", ""}, /* " $CONTRL ECP=NONE $END\n" */
	{" $CONTRL ECP=READ $END\n", "ECP", "READ"},
	{" $CONTRL ECP=SBKJC $END\n", "ECP", "SBKJC"},
	{" $CONTRL ECP=HW $END\n", "ECP", "HW"},

	{"", "", ""},
	{" $BASIS NDFUNC=1 $END\n", "NDFUNC", "1"},
	{" $BASIS NDFUNC=2 $END\n", "NDFUNC", "2"},
	{" $BASIS NDFUNC=3 $END\n", "NDFUNC", "3"},

	{"", "", ""},
	{" $BASIS NFFUNC=1 $END\n", "NFFUNC", "1"},

	{"", "", ""},
	{" $BASIS NPFUNC=1 $END\n", "NPFUNC", "1"},
	{" $BASIS NPFUNC=2 $END\n", "NPFUNC", "2"},
	{" $BASIS NPFUNC=3 $END\n", "NPFUNC", "3"},

	/* basis->polar option menu */
	{"", "", ""},
	{" $BASIS POLAR=POPLE $END\n", "POLAR", "POPLE"},
	{" $BASIS POLAR=POPN311 $END\n", "POLAR", "POPN311"},
	{" $BASIS POLAR=DUNNING $END\n", "POLAR", "DUNNING"},
	{" $BASIS POLAR=HUZINAGA $END\n", "POLAR", "HUZINAGA"},
	{" $BASIS POLAR=HONDO7 $END\n", "POLAR", "HONDO7"},

	/* control->runtyp option menu */
	{"", "", ""}, /* " $CONTRL RUNTYP=ENERGY $END\n" */
	{" $CONTRL RUNTYP=GRADIENT $END\n", "RUNTYP", "GRADIENT"},
	{" $CONTRL RUNTYP=HESSIAN $END\n", "RUNTYP", "HESSIAN"},
	{" $CONTRL RUNTYP=OPTIMIZE $END\n", "RUNTYP", "OPTIMIZE"},
	{" $CONTRL RUNTYP=TRUDGE $END\n", "RUNTYP", "TRUDGE"},
	{" $CONTRL RUNTYP=SADPOINT $END\n", "RUNTYP", "SADPOINT"},
	{" $CONTRL RUNTYP=IRC $END\n", "RUNTYP", "IRC"},
	{" $CONTRL RUNTYP=VSCF $END\n", "RUNTYP", "VSCF"},
	{" $CONTRL RUNTYP=DRC $END\n", "RUNTYP", "DRC"},
	{" $CONTRL RUNTYP=GLOBOP $END\n", "RUNTYP", "GLOBOP"},
	{" $CONTRL RUNTYP=OPTFMO $END\n", "RUNTYP", "OPTFMO"},
	{" $CONTRL RUNTYP=GRADEXTR $END\n", "RUNTYP", "GRADEXTR"},
	{" $CONTRL RUNTYP=SURFACE $END\n", "RUNTYP", "SURFACE"},
	{" $CONTRL RUNTYP=PROP $END\n", "RUNTYP", "PROP"},
	{" $CONTRL RUNTYP=RAMAN $END\n", "RUNTYP", "RAMAN"},
	{" $CONTRL RUNTYP=NMR $END\n", "RUNTYP", "NMR"},
	{" $CONTRL RUNTYP=MOROKUMA $END\n", "RUNTYP", "MOROKUMA"},
	{" $CONTRL RUNTYP=TRANSITN $END\n", "RUNTYP", "TRANSITN"},
	{" $CONTRL RUNTYP=FFIELD $END\n", "RUNTYP", "FFIELD"},
	{" $CONTRL RUNTYP=TDHF $END\n", "RUNTYP", "TDHF"},
	{" $CONTRL RUNTYP=MAKEFP $END\n", "RUNTYP", "MAKEFP"},
	
	/* control->mp2 check button */
	{" $CONTRL MPLEVL=0 $END\n", "", ""},
	{" $CONTRL MPLEVL=2 $END\n", "", ""},

        /* control->scf option menu */
	{"", "", ""}, /*" $CONTRL SCFTYP=RHF $END\n" */
        {" $CONTRL SCFTYP=UHF $END\n", "SCFTYP", "UHF"},
        {" $CONTRL SCFTYP=ROHF $END\n", "SCFTYP", "ROHF"},
        {" $CONTRL SCFTYP=GVB $END\n", "SCFTYP", "GVB"},
        {" $CONTRL SCFTYP=MCSCF $END\n", "SCFTYP", "MCSCF"},
        {" $CONTRL SCFTYP=NONE $END\n", "SCFTYP", "NONE"},

	/* control->ci option menu */
	{"", "", ""}, /* " $CONTRL CITYP=NONE $END\n" */
	{" $CONTRL CITYP=GUGA $END\n", "CITYP", "GUGA"},
	{" $CONTRL CITYP=GENCI $END\n", "CITYP", "GENCI"},

	/* control->localized option menu */
	{"", "", ""}, /* " $CONTRL LOCAL=NONE $END\n" */
	{" $CONTRL LOCAL=BOYS $END\n", "LOCAL", "BOYS"},
	{" $CONTRL LOCAL=RUEDNBRG $END\n", "LOCAL", "RUEDNBRG"},
	{" $CONTRL LOCAL=POP $END\n", "LOCAL", "POP"},

	/* control-> ext opion menu */
	{"", "", ""},/* " $CONTRL EXETYP=RUN $END\n" */
	{" $CONTRL EXETYP=CHECK $END\n", "EXETYP", "CHECK"},
	{" $CONTRL EXETYP=DEBUG $END\n", "EXETYP", "DEBUG"},

	/* data-> coord option menu */
	{"", "", ""}, /* " $DATA COORD=UNIQUE $END\n" */
	{" $DATA COORD=HINT $END\n", "COORD", "HINT"},
	{" $DATA COORD=CART $END\n", "COORD", "CART"},
	{" $DATA COORD=ZMT $END\n",  "COORD", "ZMT"},
	{" $DATA COORD=ZMTMPC $END\n", "COORD", "ZMTMPC"},

	/* data-> unit option menu */
	{"", "", ""}, /* " $CONTRL UNIT=ANGS $END\n" */
	{" $CONTRL UNITS=BOHR $END\n", "UNITS", "BOHR"},

	/* data-> point group menu */
	{"C1\n", "", ""},
	{"CS\n\n", "", ""},
	{"CI\n\n", "", ""},
	{"CnH",  "", ""},
	{"CnV", "", ""},
	{"Cn", "", ""},
	{"S2n", "", ""},
	{"DnD", "", ""},
	{"DnH", "", ""},
	{"Dn", "", ""},
	{"TD\n\n", "", ""},
	{"TH\n\n", "", ""},
	{"T\n\n", "", ""},
	{"OH\n\n", "", ""},
	{"O\n\n", "", ""},
	
	/* data-> order menu */
	{" 2\n\n", "", ""},
	{" 3\n\n", "", ""},
	{" 4\n\n", "", ""},
	
	{"", "", ""},
	{"", "", ""},

	/* system->diagonalizatin method option menu */
	{"", "", ""}, /* " $SYSTEM KDIAG=0 $END\n" */
	{" $SYSTEM KDIAG=1 $END\n", "KDIAG", "1"},
	{" $SYSTEM KDIAG=2 $END\n", "KDIAG", "2"},
	{" $SYSTEM KDIAG=3 $END\n", "KDIAG", "3"},

	{"", "", ""}, /*{" $GUESS GUESS=HUCKEL $END\n" */ 
	{" $GUESS GUESS=HCORE $END\n", "GUESS", "HCORE"}, 
	{" $GUESS GUESS=MOREAD $END\n", "GUESS", "MOREAD"},
	{" $GUESS GUESS=MOSAVED $END\n", "GUESS", "MOSAVED"},
	{" $GUESS GUESS=SKIP $END\n", "GUESS", "SKIP"},

	{" $BASIS DIFFSP=.TRUE. $END\n", "DIFFSP", "T"},
	{" $BASIS DIFFS=.TRUE. $END\n", "DIFFS", "T"},
	{" $CONTRL NOSYM=1 $END\n", "NOSYM", "1"},
	{" $SYSTEM COREFL=.TRUE. $END\n", "COREFL", "T"},
	{"", "", ""}, /* discarded */
	{" $GUESS PRTMO=.TRUE. $END\n", "PRTMO", "T"},
	{" $GUESS MIX=.TRUE. $END\n", "MIX", "T"},
	{" $CONTRL MOLPLT=.TRUE. $END\n", "MOLPLT", "T"},
	{" $CONTRL PLTORB=.TRUE. $END\n", "PLTORB", "T"},
	{" $CONTRL AIMPAC=.TRUE. $END\n", "AIMPAC", "T"},
	{"", "", ""},
	{" $SCF DIRSCF=.TRUE. $END\n", "DIRSCF", "T"},
	{" $SCF FDIFF=.TRUE. $END\n", "FDIFF", "T"},
	{" $SCF UHFNOS=.TRUE. $END\n", "UNFNOS", "T"},
	{" $MP2 MP2PRP=.TRUE. $END\n", "MP2PRP", "T"},

	{" $SYSTEM BALTYP=LOOP $END\n", "BALTYP", "LOOP"},
	{"", "", ""},

	{"", "", ""},
        {" $CONTRL FRIEND=HONDO $END\n", "FRIEND", "HONDO"},
        {" $CONTRL FRIEND=MELDF $END\n", "FRIEND", "MELDF"},
        {" $CONTRL FRIEND=GAMESSUK $END\n", "FRIEND", "GAMESSUK"},
        {" $CONTRL FRIEND=GAUSSIAN $END\n", "FRIEND", "GAUSSIAN"},
        {" $CONTRL FRIEND=ALL $END\n", "FRIEND", "ALL"},

	{" $MP2 METHOD=2 $END\n", "METHOD", "2"},
	{" $MP2 METHOD=3 $END\n", "METHOD", "3"},

	{" $MP2 APOINTS=DUP $END\n", "APOINTS", "DUP"},
	{" $MP2 APOINTS=DIST $END\n", "APOINTS", "DIST"},
};


static void * root;

typedef enum
{
	GENERAL_CALC_OPTION_MENU = 0,
	GENERAL_WITH_LEFT_OPTION_MENU = GENERAL_CALC_OPTION_MENU + 4,
	GENERAL_WITH_RIGHT_OPTION_MENU = GENERAL_WITH_LEFT_OPTION_MENU + 6,
	GENERAL_IN_OPTION_MENU = GENERAL_WITH_RIGHT_OPTION_MENU + 9,
	GENERAL_ON_LEFT_OPTION_MENU = GENERAL_IN_OPTION_MENU + 2,
	GENERAL_ON_RIGHT_OPTION_MENU = GENERAL_ON_LEFT_OPTION_MENU + 3,
	
	BASIS_BASIS_SET_OPTION_MENU = GENERAL_ON_RIGHT_OPTION_MENU + 5,
	BASIS_ECP_OPTION_MENU = BASIS_BASIS_SET_OPTION_MENU + 22,
	BASIS_DHAPF_OPTION_MENU= BASIS_ECP_OPTION_MENU + 4,
	BASIS_FHAPF_OPTION_MENU=BASIS_DHAPF_OPTION_MENU+4,
	BASIS_LAPF_OPTION_MENU=BASIS_FHAPF_OPTION_MENU+2,
	
	BASIS_POLAR_OPTION_MENU=BASIS_LAPF_OPTION_MENU+4,
	
	CONTROL_RUN_TYPE_OPTION_MENU = BASIS_POLAR_OPTION_MENU + 6,
	CONTROL_MP2_CHECK_BUTTON = CONTROL_RUN_TYPE_OPTION_MENU + 21,
	CONTROL_SCF_OPTION_MENU = CONTROL_MP2_CHECK_BUTTON + 2,
	CONTROL_CI_OPTION_MENU= CONTROL_SCF_OPTION_MENU+6,
	CONTROL_LOCAL_OPTION_MENU=CONTROL_CI_OPTION_MENU+3,
	CONTROL_EXE_OPTION_MENU=CONTROL_LOCAL_OPTION_MENU+4,

	DATA_COORD_TYPE_OPTION_MENU=CONTROL_EXE_OPTION_MENU+3,
	DATA_UNIT_OPTION_MENU=DATA_COORD_TYPE_OPTION_MENU+5,

	DATA_PG_OPTION_MENU=DATA_UNIT_OPTION_MENU+2,
	DATA_ORDER_OPTION_MENU = DATA_PG_OPTION_MENU+15,

	
	SYSTEM_TIMELIMIT_OPTION_MENU = DATA_ORDER_OPTION_MENU+3,
	SYSTEM_MEMORY_OPTION_MENU,
	SYSTEM_DIAG_METHOD_OPTION_MENU,
	
	MO_GUESS_OPTION_MENU= SYSTEM_DIAG_METHOD_OPTION_MENU+4,

	BASIS_LSHELL_CHECKBUTTON = MO_GUESS_OPTION_MENU+5,
	BASIS_SSHELL_CHECKBUTTON,
	CONTROL_NOSYM_CHECKBUTTON,
	SYSTEM_COREFL_CHECKBUTTON,
	SYSTEM_XDR_CHECKBUTTON,
	GUESS_INITIAL_CHECKBUTTON,
	GUESS_ROTATE_CHECKBUTTON,
	MISC_MOLPLT_CHECKBUTTON,
	MISC_PLTORB_CHECKBUTTON,
	MISC_AIMPAC_CHECKBUTTON,
	MISC_RPAC_CHECKBUTTON,
	SCF_DIRECT_CHECKBUTTON,
	SCF_FOCK_CHECKBUTTON,
	SCF_UHF_CHECKBUTTON,
	MP2_LOCAL_CHECKBUTTON,

	SYSTEM_PARALLEL_LOOP_RADIOBUTTON,
	SYSTEM_PARALLEL_NEXT_RADIOBUTTON,

	SYSTEM_RUN_NONE_RADIOBUTTON,
	SYSTEM_RUN_HONDO_RADIOBUTTON,
	SYSTEM_RUN_MELDF_RADIOBUTTON,
	SYSTEM_RUN_GAMESS_RADIOBUTTON,
	SYSTEM_RUN_GAUSSIAN_RADIOBUTTON,
	SYSTEM_RUN_ALL_RADIOBUTTON,

	SYSTEM_TRAN_SEGMENT_RADIOBUTTON,
	SYSTEM_TRAN_2PHASE_RADIOBUTTON,

	SYSTEM_AO_DUP_RADIOBUTTON,
	SYSTEM_AO_DIS_RADIOBUTTON,

}OPTION_STRING_ID;

static UI_STRUCT menu_struct[] = 
{
	{"general.calculate", GENERAL_CALC_OPTION_MENU, &root, VALID},
		
	{"general.with.numerator", GENERAL_WITH_LEFT_OPTION_MENU, &root, VALID},
	{"general.with.denominator", GENERAL_WITH_RIGHT_OPTION_MENU, &root, VALID},
	{"general.in", GENERAL_IN_OPTION_MENU, &root, VALID},
	{"general.on.bond", GENERAL_ON_LEFT_OPTION_MENU, &root, VALID},
	{"general.on.charge", GENERAL_ON_RIGHT_OPTION_MENU, &root, VALID},
	{"basis.set", BASIS_BASIS_SET_OPTION_MENU, &root,INVALID},
	{"basis.ecp", BASIS_ECP_OPTION_MENU, &root, VALID},
	{"basis.dhapf", BASIS_DHAPF_OPTION_MENU, &root, VALID},
	{"basis.fhapf", BASIS_FHAPF_OPTION_MENU, &root, VALID},
	{"basis.lapf", BASIS_LAPF_OPTION_MENU, &root, VALID},
	{"basis.polar", BASIS_POLAR_OPTION_MENU, &root, VALID},
	
	{"control.runtype", CONTROL_RUN_TYPE_OPTION_MENU, &root, INVALID},
	
	{"control.scf", CONTROL_SCF_OPTION_MENU, &root, VALID},
	{"control.ci", CONTROL_CI_OPTION_MENU, &root, VALID},
	{"control.method", CONTROL_LOCAL_OPTION_MENU, &root, VALID},
	{"control.ext", CONTROL_EXE_OPTION_MENU, &root, VALID},
	{"data.type", DATA_COORD_TYPE_OPTION_MENU, &root, VALID},
	{"data.unit", DATA_UNIT_OPTION_MENU, &root, VALID},
	{"data.pointgroup", DATA_PG_OPTION_MENU, &root, INVALID},
	{"data.axis", DATA_ORDER_OPTION_MENU, &root,INVALID},
#if 0
	{"InpEdit.timelimit", SYSTEM_TIMELIMIT_OPTION_MENU, &root, INVALID},
	{"InpEdit.memory", SYSTEM_MEMORY_OPTION_MENU, &root,INVALID},
#endif
	{"system.diagonalization", SYSTEM_DIAG_METHOD_OPTION_MENU, &root, VALID},
	{"mo_guess.initial", MO_GUESS_OPTION_MENU, &root, VALID},
	
};

typedef enum
{
		OPTION_MENU_CALCULATE = 0,
		OPTION_MENU_WITH_LEFT,
		OPTION_MENU_WITH_RIGHT,
		OPTION_MENU_IN,
		OPTION_MENU_ON_LEFT,
		OPTION_MENU_ON_RIGHT,
		OPTION_MENU_BASIS_SET,
		OPTION_MENU_ECP,
		OPTION_MENU_DHAPF,
		OPTION_MENU_FHAPF,
		OPTION_MENU_LAPF,
		OPTION_MENU_POLAR,
		OPTION_MENU_RUN_TYPE,
		OPTION_MENU_SCF,
		OPTION_MENU_CI,
		OPTION_MENU_LOCAL_METHOD,
		OPTION_MENU_EXE,
		OPTION_MENU_COORD,
		OPTION_MENU_UNIT,
		OPTION_MENU_POINT_GROUP,
		OPTION_MENU_ORDER,
		OPTION_MENU_TIME_LIMIT,
		OPTION_MENU_MEMORY,
		OPTION_MENU_DIAG,
		OPTION_MENU_GUESS,
	
}MENU_ID;

enum 
{
	ID_MP2_CHECKBUTTON = 0,
	ID_LSHELL_CKBUTTON,
	ID_SSHELL_CKBUTTON,
	ID_NONSYM_CKBUTTON,
	ID_CORE_CKBUTTON,
	ID_INITIAL_CKBUTTON,
	ID_ROTATE_CKBUTTON,
	ID_MOLPLT_CKBUTTON,
	ID_PLTORB_CKBUTTON,
	ID_AIMPAC_CKBUTTON,
	ID_RPAC_CKBUTTON,
	ID_DIRECT_CKBUTTON,
	ID_FOCK_CKBUTTON,
	ID_UHF_CKBUTTON,
	ID_LOCAL_CKBUTTON,
	ID_PARALLEL_LOOP_CKBUTTON,
	ID_PARALLEL_NEXT_RADIOBUTTON,
	ID_RUN_NONE_RADIOBUTTON,
	ID_RUN_HONDO_RADIOBUTTON,
	ID_RUN_MELDF_RADIOBUTTON,
	ID_RUN_GAMESS_RADIOBUTTON,
	ID_RUN_GAUSSIAN_RADIOBUTTON,
	ID_RUN_ALL_RADIOBUTTON,
	
	ID_TRAN_SEGMENT_RADIOBUTTON,
	ID_TRAN_2PHASE_RADIOBUTTON,
	ID_AO_DUP_RADIOBUTTON,
	ID_AO_DIS_RADIOBUTTON,
};

const UI_STRUCT ckbutton_struct[] = 
{
	{"basis.lshell", BASIS_LSHELL_CHECKBUTTON,&root},
	{"basis.sshell", BASIS_SSHELL_CHECKBUTTON,&root},
	{"control.mp2", CONTROL_MP2_CHECK_BUTTON,&root},
	{"data.disablesymmetry",CONTROL_NOSYM_CHECKBUTTON,&root},
	{"system.core",SYSTEM_COREFL_CHECKBUTTON,&root},
#if 0
	{"InpEdit.xdr",SYSTEM_XDR_CHECKBUTTON,&root},
#endif
	{"moguess.print",GUESS_INITIAL_CHECKBUTTON,&root},
	{"moguess.rotate",GUESS_ROTATE_CHECKBUTTON,&root},
	{"misc.molplt",MISC_MOLPLT_CHECKBUTTON,&root},
	{"misc.pltorb",MISC_PLTORB_CHECKBUTTON,&root},
	{"misc.aimpac",MISC_AIMPAC_CHECKBUTTON,&root},
	{"misc.rpac",MISC_RPAC_CHECKBUTTON,&root},
	{"scf.direct",SCF_DIRECT_CHECKBUTTON,&root},
	{"scf.fockmatrix",SCF_FOCK_CHECKBUTTON,&root},
	{"scf.uhf",SCF_UHF_CHECKBUTTON,&root},
	{"mp2.localized",MP2_LOCAL_CHECKBUTTON,&root},
	{"system.parallel.loop",SYSTEM_PARALLEL_LOOP_RADIOBUTTON,&root},
	{"system.parallel.next",SYSTEM_PARALLEL_NEXT_RADIOBUTTON,&root},

	{"misc.force.none",SYSTEM_RUN_NONE_RADIOBUTTON,&root},
	{"misc.force.hondo",SYSTEM_RUN_HONDO_RADIOBUTTON,&root},
	{"misc.force.meldf",SYSTEM_RUN_MELDF_RADIOBUTTON,&root},
	{"misc.force.gamess",SYSTEM_RUN_GAMESS_RADIOBUTTON,&root},
	{"misc.force.gaussian",SYSTEM_RUN_GAUSSIAN_RADIOBUTTON,&root},
	{"misc.force.all",SYSTEM_RUN_ALL_RADIOBUTTON,&root},

	{"mp2.transformation.segmented",SYSTEM_TRAN_SEGMENT_RADIOBUTTON,&root},
	{"mp2.transformation.twophase",SYSTEM_TRAN_2PHASE_RADIOBUTTON,&root},

	{"mp2.ao.each",SYSTEM_AO_DUP_RADIOBUTTON,&root},
	{"mp2.ao.all",SYSTEM_AO_DIS_RADIOBUTTON,&root},
};

enum {
	ID_MULT_ENTRY = 0,
	ID_ICHARG_ENTRY,
	ID_RUN_TITLE_ENTRY,
	ID_TIME_LIM_ENTRY,
	ID_MEMORY_LIM_ENTRY,
};

char* ui_entry[] = 
{
	"control.charge",
	"control.multiplicity",
	"data.title",
	"general.timelimit",
	"general.memory",
};

typedef struct
{
	char* widget_name;
	int   option_index;
}UI_OPTION;

UI_OPTION ui_option[] = 
{
	/* " $CONTRL RUNTYP=ENERGY $END\n" */
	{"control.runtype", 0}, 
	/* " $CONTRL RUNTYP=OPTIMIZE $END\n" */
	{"control.runtype", 3},
	/* " $CONTRL RUNTYP=SADPOINT $END\n $STATPT HESS=CALC $END\n"*/
	{"control.runtype", 5},
	/* " $CONTRL RUNTYP=HESSIAN $END\n" */
	{"control.runtype", 2},

	/* " $BASIS GBASIS=AM1 $END\n", */
	{"basis.set", 20},
	/* " $BASIS GBASIS=PM3 $END\n", */
	{"basis.set", 21},
	/* "" RHF */
	{"control.scf", 0},
	/* " $DFT DFTTYP=B3LYP $END\n" */
	{"control.scf", -1},
	/* " $CONTRL MPLEVL=2 $END\n" */
	{"control.scf", -1},
	/* " $CONTRL CCTYP=CCSD(T) $END\n" */
	{"control.scf", -1},


	/* general->width.right option menu */
	/* " $BASIS GBASIS=STO NGAUSS=3 $END\n", */
	{"basis.set", 3},
	/* " $BASIS GBASIS=MINI $END\n", */
	{"basis.set", 0},
	/* " $BASIS GBASIS=N21 NGAUSS=3 $END\n", */
	{"basis.set", 7},
	/* " $BASIS GBASIS=N31 NGAUSS=6 NDFUNC=1 $END\n", */
	{"basis.set", 11},
	/* " $BASIS GBASIS=N31 NGAUSS=6 NDFUNC=1 NPFUNC= 1 $END\n", */
	{"basis.set", 11},
	/* " $BASIS GBASIS=N31 NGAUSS=6 NDFUNC=1 NPFUNC= 1 DIFFSP = 1 $END\n", */
	{"basis.set", 11},
	/* " $BASIS GBASIS=N31 NGAUSS=6 NDFUNC=2 NPFUNC= 1 DIFFSP = 1 $END\n", */
	{"basis.set", 11},
	/* " $BASIS GBASIS=N311 NGAUSS=6 NDFUNC=1 NPFUNC= 1 DIFFSP = 1 DIFFS=.T. $END\n", */
	{"basis.set", 12},
	/* " $BASIS GBASIS=SBKJC NDFUNC=1 $END\n $CONTRL ECP=SBKJC $END\n", */
	{"basis.set", 17},

	/* general->in option menu */
	/* "", */
	{NULL, -1},
	/* " $PCM SOLVNT=WATER $END\n", */
	{NULL, -1},

	/* general->on.left option menu */
	/* "",*/
	{"control.scf", 2},
	/* " $CONTRL SCFTYP=ROHF MULT=2 $END\n",*/
	{"control.scf", 2},
	/* " $CONTRL SCFTYP=ROHF MULT=3 $END\n",*/
	{"control.scf", 2},

	/* general->on.right option menu */
	/* " $CONTRL ICHARG=2 $END\n",*/
	{NULL, -1},
	/* " $CONTRL ICHARG=1 $END\n",*/
	{NULL, -1},
	/* "",*/
	{NULL, -1},
	/* " $CONTRL ICHARG=-1 $END\n",*/
	{NULL, -1},
	/* " $CONTRL ICHARG=-2 $END\n",*/
	{NULL, -1},

};



typedef struct 
{
	char* name;
	int index;
}OptionItem;

static OptionItem option_item[] = {

	/* ID_ITEM_MENU_RUN_TYPE = 0 */
	/* ENERGY, 0 */
	{ "GRADIENT", 1},
	{ "HESSIAN", 2},
	{ "OPTIMIZE", 3},
	{ "TRUDGE", 4},
	{ "SADPOINT", 5},
	{ "IRC", 6},
	{ "VSCF", 7},
	{ "DRC", 8},
	{ "GLOBOP", 9},
	{ "OPTFMO", 10},
	{ "GRADEXTR", 11},
	{ "SURFACE", 12},
	{ "PROP", 13},
	{ "RAMAN", 14},
	{ "NMR", 15},
	{ "MOROKUMA", 16},
	{ "TRANSITN", 17},
	{ "FFIELD", 18},
	{ "TDHF", 19},
	{ "MAKEFP", 20},

	/* ID_ITEM_MENU_SCF_TYPE */
	/* RHF, 0 */
	{ "UHF", 1},
	{ "ROHF", 2},
	{ "GVB", 3},
	{ "MCSCF", 4},
	{ "NONE", 5},

	/* ID_ITEM_MENU_EXE */
	/* RUN, 0 */
	{"CHECK", 1},
	{"DEBUG", 2},

	/* ID_ITEM_ECP */
	/* NONE, 0 */
	{"READ", 1},
	{"SBKJC", 2},
	{"HW", 3},

	/* ID_ITEM_LOCAL */
	/* NONE, 0 */
	{"BOYS", 1},
	{"RUEDNBRG", 2},
	{"POP", 3},

	/* ID_ITEM_CI */
	/* NONE, 0 */
	{"GUGA", 1},
	{"GENCI", 2},

	/* ID_ITEM_NDFUNC */
	/* "", 0 */
	{"1", 1},
	{"2", 2},
	{"3", 3},

	/* ID_ITEM_NFFUNC */
	/* "", 0 */
	{"1", 1},

	/* ID_ITEM_NPFUNC */
	/* "", 0 */
	{"1", 1},
	{"2", 2},
	{"3", 3},

	/* ID_ITEM_POLAR */
	/* "", 0 */
	{"POPLE", 1},
	{"POPN311", 2},
	{"DUNNING", 3},
	{"HUZINAGA",4},
	{"HONDO7",5},

	/* ID_ITEM_COORD  */
	/* "", 0 */
	{"HINT", 1},
	{"CART", 2},
	{"ZMT", 3},
	{"ZMTMPC", 4},

	/* ID_ITEM_UNITS */
	/* "", 0 */
	{"BOHR", 1},

	/* ID_ITEM_KDIAG */
	/* "", 0 */
	{"1", 1},
	{"2", 2},
	{"3", 3},

	/* ID_ITEM_GUESS */
	/* "", 0 */
	{"HCORE", 1},
	{"HOREAD", 2},
	{"HOSAVED", 3},
	{"SKIP", 4},

};

enum 
{
	ID_ITEM_MENU_RUN_TYPE = 0,
	ID_ITEM_MENU_SCF_TYPE = ID_ITEM_MENU_RUN_TYPE + 20,
	ID_ITEM_MENU_EXE  = ID_ITEM_MENU_SCF_TYPE + 5,
	ID_ITEM_ECP = ID_ITEM_MENU_EXE + 2,
	ID_ITEM_LOCAL = ID_ITEM_ECP + 3,
	ID_ITEM_CI_TYPE = ID_ITEM_LOCAL + 3,
	ID_ITEM_NDFUNC = ID_ITEM_CI_TYPE + 2,
	ID_ITEM_NFFUNC = ID_ITEM_NDFUNC + 3,
	ID_ITEM_NPFUNC = ID_ITEM_NFFUNC + 1,
	ID_ITEM_POLAR= ID_ITEM_NPFUNC + 3,
	ID_ITEM_COORD = ID_ITEM_POLAR + 5,
	ID_ITEM_UNITS= ID_ITEM_COORD+ 4,
	ID_ITEM_KDIAG = ID_ITEM_UNITS + 1,
	ID_ITEM_GUESS= ID_ITEM_KDIAG + 3,

};

typedef struct 
{
	char* name;
	int   type;
	int   menu;
	int   start;
	int   number;
}OptionMenu;

static OptionMenu option_keys[] = 
{
	/* CONTRL OPTIONS */
	{"SCFTYP", TYPE_MENU, OPTION_MENU_SCF, ID_ITEM_MENU_SCF_TYPE, 5}, 
	{"RUNTYP",TYPE_MENU, OPTION_MENU_RUN_TYPE, ID_ITEM_MENU_RUN_TYPE, 20}, 
	{"EXETYP", TYPE_MENU, OPTION_MENU_EXE, ID_ITEM_MENU_EXE, 2},
	{"MPLEVL", TYPE_NONE, INVALID, INVALID, 0},
	{"CITYP", TYPE_MENU, OPTION_MENU_CI, ID_ITEM_CI_TYPE, 2},
	{"CCTYP", TYPE_NONE, INVALID, INVALID, 0},
	{"MULT", TYPE_EDIT, ID_MULT_ENTRY, INVALID, 0},
	{"ICHARG", TYPE_EDIT, ID_ICHARG_ENTRY, INVALID, 0},
	{"NZVAR", TYPE_NONE, INVALID, INVALID, 0},
	{"COORD", TYPE_MENU, OPTION_MENU_COORD, ID_ITEM_COORD, 4},
    	{"ECP", TYPE_MENU, OPTION_MENU_ECP, ID_ITEM_ECP, 3},
	{"RELWFN", TYPE_NONE, INVALID, INVALID, 0},
	{"LOCAL", TYPE_MENU, OPTION_MENU_LOCAL_METHOD, ID_ITEM_LOCAL, 3},
	{"NUMGRD", TYPE_NONE, INVALID, INVALID, 0},
	{"ISPHER", TYPE_NONE, INVALID, INVALID, 0},
	{"NOSYM", TYPE_CKBUTTON, ID_NONSYM_CKBUTTON, INVALID, 0},
	{"MAXIT", TYPE_NONE, INVALID, INVALID, 0},
	{"UNITS", TYPE_MENU, OPTION_MENU_UNIT, ID_ITEM_UNITS, 1},
	{"PLTORB", TYPE_CKBUTTON, ID_PLTORB_CKBUTTON, INVALID, 0},
	{"MOLPLT",TYPE_CKBUTTON, ID_MOLPLT_CKBUTTON, INVALID, 0},
	{"AIMPAC", TYPE_CKBUTTON, ID_AIMPAC_CKBUTTON, INVALID, 0},
	{"FRIEND", TYPE_NONE, INVALID, INVALID, 0},
	{"NPRINT", TYPE_NONE, INVALID, INVALID, 0},
	{"IREST", TYPE_NONE, INVALID, INVALID, 0},
	{"GEOM", TYPE_NONE, INVALID, INVALID, 0},
	{"NORMF", TYPE_NONE, INVALID, INVALID, 0},
	{"NORMP", TYPE_NONE, INVALID, INVALID, 0},
	{"ITOL", TYPE_NONE, INVALID, INVALID, 0},
      	{"ICUT", TYPE_NONE, INVALID, INVALID, 0},
 	{"INTTYP", TYPE_NONE, INVALID, INVALID, 0},
	{"QMTTOL", TYPE_NONE, INVALID, INVALID, 0},

	/* SYSTEM OPTIONS */
	{"TIMLIM", TYPE_EDIT, ID_TIME_LIM_ENTRY, INVALID, 0},
	{"COREFL", TYPE_CKBUTTON, ID_CORE_CKBUTTON, INVALID, 0},
	{"KDIAG", TYPE_MENU, OPTION_MENU_DIAG, ID_ITEM_KDIAG, 3},

	/* BASIS */
	{"GBASIS", TYPE_NONE, INVALID, INVALID, 0},
	{"IGAUSS", TYPE_NONE, INVALID, INVALID, 0},
	{"POLAR", TYPE_MENU, OPTION_MENU_POLAR, ID_ITEM_POLAR, 5},
	{"NDFUNC", TYPE_MENU, OPTION_MENU_DHAPF, ID_ITEM_NDFUNC, 3},
	{"NFFUNC", TYPE_MENU, OPTION_MENU_FHAPF, ID_ITEM_NFFUNC, 1},
	{"DIFFSP", TYPE_CKBUTTON, ID_LSHELL_CKBUTTON, INVALID, 0},
	{"NPFUNC", TYPE_MENU, OPTION_MENU_LAPF, ID_ITEM_NPFUNC, 3},
	{"DIFFS", TYPE_CKBUTTON, ID_SSHELL_CKBUTTON, INVALID, 0},

	/* GUESS */
	{"GUESS", TYPE_MENU, OPTION_MENU_GUESS, ID_ITEM_GUESS, 4},
	{"NORB", TYPE_NONE, INVALID, INVALID, 0},
      	{"NORDER", TYPE_NONE, INVALID, INVALID, 0},
	{"MIX", TYPE_CKBUTTON, ID_ROTATE_CKBUTTON, INVALID, 0},
     	{"PRTMO", TYPE_CKBUTTON, ID_INITIAL_CKBUTTON, INVALID, 0},
	{"PUNMO", TYPE_NONE, INVALID, INVALID, 0},
	{"TOLZ", TYPE_NONE, INVALID, INVALID, 0},
      	{"TOLE", TYPE_NONE, INVALID, INVALID, 0},
	{"SYMDEN", TYPE_NONE, INVALID, INVALID, 0},
	{"PURIFY",  TYPE_NONE, INVALID, INVALID, 0},

	/* OTHER */
	{"RUNTITLE", TYPE_EDIT, ID_RUN_TITLE_ENTRY, INVALID, 0},
	{"REPLICATED MEMORY", TYPE_EDIT, ID_MEMORY_LIM_ENTRY, INVALID, 0},
};


/*################################################################################################*/

const char config_file_save_dialog::title[] = "Config File";
gamess_dialog * config_file_save_dialog::docv = NULL;
config_file_save_dialog::config_file_save_dialog(gamess_dialog * p1) :
	file_dialog(title, CONFIG_FILTER, NULL)
{
	docv = p1;

}

config_file_save_dialog::~config_file_save_dialog(void)
{
}

bool config_file_save_dialog::OkEvent(const char * filename)
{
	if (docv == NULL)
	{

	  exit(EXIT_FAILURE);
	}
	

	docv->delay_Save(filename);

	return true;
}

void config_file_save_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

const char config_file_submit_dialog::title[] = "Submit File";
gamess_dialog * config_file_submit_dialog::docv = NULL;
config_file_submit_dialog::config_file_submit_dialog(gamess_dialog * p1) :
	file_dialog(title, CONFIG_FILTER, NULL)
{
	docv = p1;
}

config_file_submit_dialog::~config_file_submit_dialog(void)
{
}

bool config_file_submit_dialog::OkEvent(const char * filename)
{
	char buff[256];
	
	if (docv == NULL)
	{

	  exit(EXIT_FAILURE);
	}
  	
	
	docv->delay_Save(filename);
	docv->delay_Destroy();

	snprintf(buff,128,"%s %s > /dev/null &", GMS_EXE, filename);
	system(buff);
	
	
	return true;
}

void config_file_submit_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

/* messin round a messin round town
typedef enum{
	GENERAL_CALCULATE,
	GENERAL_WITH,
} GmsOptionName;

typedef enum{
	GMS_MENU = 1,
	GMS_MENU_DOUBLE,
	GMS_CHECKBOX,
	GMS_RADIO,
} GmsOptionType;

typedef struct {
	char *label;
	char *code;
} GmsItem;

typedef struct {
	char *label;
	GmsOptionName name;
	GmsOptionType type;
	GmsItem *items;
	char *divider;
	GmsItem *ditems;
} GmsOptionMenuDouble;

typedef struct {
	char *label;
	GmsOptionName name;
	GmsOptionType type;
	GmsItem *items;
} GmsOptionMenu;

typedef union {
	GmsOptionMenu menu;
	GmsOptionMenuDouble menud;
} GmsOption;

GmsItem gms_general_calculate_items[] = { 
	{"Single Point Entry", "code"},
	{"Equilibrium Geometry", ""},
	{"Transition State", ""},
	{"Frequencies", ""},
};

GmsItem gms_general_with_left_items[] = { 
	{"AM1", "code"},
	{"PM3", "code"},
	{"RHF", "code"},
	{"B3LYP", "code"},
	{"MP2", "code"},
	{"CCSD(T)", "code"},
};

GmsItem gms_general_with_right_items[] = { 
	{"STO-3G", "code"},
	{"MINI", "code"},
	{"3-21G", "code"},
	{"6-31G(d)", "code"},
	{"6-31G(d,p)", "code"},
	{"6-31+G(d,p)", "code"},
	{"6-31+G(2d,p)", "code"},
	{"6-311++G(2d,p)", "code"},
	{"Core Potential", "code"},
};

GmsOption gms_options[] = {
	{ "Calculate", GENERAL_CALCULATE, GMS_MENU, calculate_items },
	{ "With", GENERAL_WITH, GMS_MENU_DOUBLE, with_left_items, "/", with_right_items },
};

*/

/*################################################################################################*/

ostringstream gamess_dialog::backupstr;
int gamess_dialog::charge = 0;
gamess_dialog::gamess_dialog(gtk_project * p1) : glade_dialog("glade/gamess_dialog.glade")
{
	prj = p1;
	dialog = glade_xml_get_widget(xml, "gamess_dialog");
	if (dialog == NULL) { cout << "gamess_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// connect the handlers...
	

	    GtkWidget * option_menu;
	    unsigned int i;

	    root = xml;
	    for(i=0; i< sizeof(menu_struct)/sizeof(UI_STRUCT);i++){ 
	    	option_menu = glade_xml_get_widget(xml, menu_struct[i].ui_name);
	    	gtk_signal_connect (GTK_OBJECT (GTK_OPTION_MENU (option_menu)->menu), "deactivate", GTK_SIGNAL_FUNC(handler_OptionMenuChanged), (gpointer)&menu_struct[i]);
	    }

	    for(i=0; i< sizeof(ckbutton_struct)/sizeof(UI_STRUCT);i++){ 
	    	option_menu = glade_xml_get_widget(xml, ckbutton_struct[i].ui_name);
	    	gtk_signal_connect (GTK_OBJECT(GTK_CHECK_BUTTON (option_menu)), "toggled", GTK_SIGNAL_FUNC(handler_CheckButtonToggled), (gpointer)&ckbutton_struct[i]);
	    }

	    //glade_xml_signal_connect_data(xml, "on_dialog_destroy", (GtkSignalFunc) handler_Destroy, this);

	    glade_xml_signal_connect_data(xml, "on_gamess_review_clicked", (GtkSignalFunc) handler_ButtonReview, (gpointer)this);
	    glade_xml_signal_connect_data(xml, "on_gamess_cancel_clicked", (GtkSignalFunc) handler_ButtonCancel, (gpointer)this);
	    glade_xml_signal_connect_data(xml, "on_gamess_save_clicked", (GtkSignalFunc) handler_ButtonSave, (gpointer)this);
	    glade_xml_signal_connect_data(xml, "on_gamess_submit_clicked", (GtkSignalFunc) handler_ButtonSubmit, (gpointer)this);
	    glade_xml_signal_connect_data(xml, "on_review_cancel_clicked", (GtkSignalFunc) handler_ButtonReviewCancel, this);
	    glade_xml_signal_connect_data(xml, "on_review_save_clicked", (GtkSignalFunc) handler_ButtonReviewOK, this);



	   // added by  shouxi


		setup1_mm * owner = dynamic_cast<setup1_mm *>(prj->GetCurrentSetup());
	    // gnome_mm1_docv * owner = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	    if (!owner) cout << "ERROR: cast failed in file_export_dialog::handler_ButtonOK()." << endl;

		/*
	   for(i = 0; i< sizeof(option_keys)/sizeof(OptionMenu); i++)
	   {
	 	// if(owner->_options.find(option_keys[i].name) == owner->_options.end())continue;

	   	// string str = owner->_options[option_keys[i].name];
		int j=0;

		switch(option_keys[i].type)
		{
		case TYPE_MENU:
			
			for(j=0; j<option_keys[i].number; j++){

				if(strcmp(str.c_str(), option_item[j + option_keys[i].start].name) == 0)
				{
					//printf("%s %d\n",option_keys[i].name,  option_item[j + option_keys[i].start].index);
				
					GtkWidget * optmenu = glade_xml_get_widget(xml, menu_struct[option_keys[i].menu].ui_name);
					if (GTK_WIDGET_SENSITIVE (optmenu))
						gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu),option_item[j + option_keys[i].start].index);
					break;
				}
			}
			break;

		case TYPE_EDIT:
			{
				GtkWidget* text = glade_xml_get_widget(xml,ui_entry[option_keys[i].menu]);
				gtk_entry_set_text(GTK_ENTRY(text),str.c_str());
				//printf("%s %s\n",ui_entry[option_keys[i].menu],str.c_str());
			}
			
			break;

		case TYPE_CKBUTTON:
		case TYPE_RADIOBTN:
			{
				//printf("%s %s\n",ckbutton_struct[option_keys[i].menu].ui_name,str.c_str());
				GtkWidget* btn = glade_xml_get_widget(xml,ckbutton_struct[option_keys[i].menu].ui_name);

				if(strcmp(str.c_str(),"T") == 0)
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),TRUE);
				if(strcmp(str.c_str(),"F") == 0)
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),FALSE);
			}

			break;
		case TYPE_NONE:
			break;
		}
			
				
	   }
	   */
	
		
	// gnome_dialog_run(GNOME_DIALOG(dialog));		// MODAL
	gtk_dialog_run(GTK_DIALOG(dialog));	// MODAL
	// gtk_widget_destroy(dialog);		// MODAL
}

gamess_dialog::~gamess_dialog()
{
}


void gamess_dialog::handler_ButtonReview(GtkWidget *widget, gpointer data)
{
	gamess_dialog * ref = (gamess_dialog *) data;
	GladeXML* xml = ref->xml;

	if(backupstr.str().length() == 0)
	{
	     UpdateData(widget,data);
	}
	else
	{
	     // get data from backup
	     GtkWidget *text;
		 GtkTextBuffer *buffer;
	     text = glade_xml_get_widget(xml,"review.text");
		 buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	     //gtk_text_set_point(GTK_TEXT(text), 0);
	     //gtk_text_forward_delete(GTK_TEXT(text), len);
	     //gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, backupstr.str().c_str(),-1); 
		 gtk_text_buffer_set_text(buffer, backupstr.str().c_str(),-1);
	}

	GtkWidget* review = glade_xml_get_widget(xml,"config_edit_dialog");
	gtk_widget_show(review);
}

void gamess_dialog::UpdateData(GtkWidget *widget, gpointer data)
{
	guint i,j,k;
	GtkWidget *text;
	GtkWidget *entry1,*entry2;
	GtkTextBuffer *buffer;
	GtkTextIter iter;
	int len;
	char buff[128];
//	file_trans translator;	// this is an unknown type? ; 20060216 TH

	gamess_dialog * ref = (gamess_dialog *) data;
	GladeXML* xml = ref->xml;

	//setup1_mm * owner = dynamic_cast<setup1_mm *>(ref->prj->GetCurrentSetup());
	model * owner = (model *) ref->prj;
	if (!owner) cout << "ERROR: cast failed in file_export_dialog::handler_ButtonOK()." << endl;

	text = glade_xml_get_widget(xml,"review.text");
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	gtk_text_buffer_set_text(buffer, "", -1);
	gtk_text_buffer_get_end_iter(buffer, &iter);
	/*
	len = gtk_text_get_length(GTK_TEXT(text));
	gtk_text_set_point(GTK_TEXT(text), 0);
	gtk_text_forward_delete(GTK_TEXT(text), len);
	*/

	/* insert the code for static things here. */
	/* added by dcurtis */
	if(owner->GetConstD_count() > 0)
	{
		snprintf(buff, 128, " $CONTRL NZVAR=%d $END\n", 3 * owner->GetAtomCount() - 6);
		// gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, buff,-1); 
		gtk_text_buffer_insert (buffer, &iter, buff,-1); 

		for(iter_CDl it1 = owner->GetConstD_begin(); it1 != owner->GetConstD_end(); it1++)
		{
			iter_cl it2;
			for(it2 = (*it1).atmr[0]->cr_list.begin(); 
				it2 !=  (*it1).atmr[0]->cr_list.end();
				it2++)
			{
				if( it2->atmr->index == (*it1).atmr[1]->index ) {
					snprintf(buff, 128, " $ZMAT DLC=.T. AUTO=.T. IFZMAT(1)=1,%d,%d FVALUE(1)=%.3f $END\n",
						(*it1).atmr[0]->index+1, (*it1).atmr[1]->index+1, (*it1).GetMinDist()*10);
					gtk_text_buffer_insert (buffer, &iter, buff,-1); 
					break;
				}
			}
			if( it2 == (*it1).atmr[0]->cr_list.end() )
			{
				snprintf(buff, 128, " $ZMAT DLC=.T. AUTO=.T. IFZMAT(1)=1,%d,%d FVALUE(1)=%f NONVDW(1)=%d,%d $END\n",
					(*it1).atmr[0]->index+1, (*it1).atmr[1]->index+1, (*it1).GetMinDist()*10,
					(*it1).atmr[0]->index+1, (*it1).atmr[1]->index+1 );
				gtk_text_buffer_insert (buffer, &iter, buff,-1); 
			}
/*
			snprintf(buffer, 100, "%d (%s)", (*it1).atoms[0]->index, (*it1).atoms[0]->el.GetSymbol());
			text[0] = g_strconcat(buffer, NULL);
			snprintf(buffer, 100, "%d (%s)", (*it1).atoms[1]->index, (*it1).atoms[1]->el.GetSymbol());
			text[1] = g_strconcat(buffer, NULL);
			snprintf(buffer, 100, "%f", (*it1).distance * 10);
			text[2] = g_strconcat(buffer, NULL);                                                
			row = gtk_clist_append(GTK_CLIST(clist), text);                                     
			gtk_clist_set_row_data(GTK_CLIST(clist), row, &(*it1));
*/
		}
	}

	bool first = true;

	for(iter_al it2 = owner->GetAtomsBegin();
			it2 != owner->GetAtomsEnd();
			it2++ )
	{
		if( (*it2).GetLocked() )
			
		{
			if( first ) {
				snprintf(buff, 128, " $STATPT IFCART(1)=\n");
				gtk_text_buffer_insert (buffer, &iter, buff,-1); 
				first = false;
			}
			else
			{
				snprintf(buff, 128, ",\n");
				gtk_text_buffer_insert (buffer, &iter, buff,-1); 
			}
			snprintf(buff, 128, "%d,%d,%d", 3*((*it2).index)+1,3*((*it2).index)+2,3*((*it2).index)+3);
			gtk_text_buffer_insert (buffer, &iter, buff,-1); 
/*
			snprintf(buffer, 100, "%d (%s)", (*it2).index, (*it2).el.GetSymbol());
			text[0] = g_strconcat(buffer, NULL);
			row = gtk_clist_append(GTK_CLIST(flist), text);
			gtk_clist_set_row_data(GTK_CLIST(flist), row, &(*it2));
*/
		}
	}
	/* if first = false then we know we've had one match */
	if( !first ) 
	{
		snprintf(buff, 128, "\n $END\n");
		gtk_text_buffer_insert (buffer, &iter, buff,-1); 
	}


	for(i=0; i< sizeof(menu_struct)/sizeof(UI_STRUCT);i++){
		GtkWidget * optmenu = glade_xml_get_widget(xml, menu_struct[i].ui_name);

		if ((!GTK_WIDGET_SENSITIVE (optmenu)) ||(menu_struct[i].value == INVALID))continue;
		GtkWidget * submenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optmenu));
		GtkWidget * item = gtk_menu_get_active(GTK_MENU(submenu));

		int index = g_list_index(GTK_MENU_SHELL(submenu)->children, item);
		memset(buff,0x00,128);
		if(strcmp(option_string[menu_struct[i].option_base+index].option,"")){
			snprintf(buff, 128, "%s",option_string[menu_struct[i].option_base+index].option); 
			gtk_text_buffer_insert (buffer, &iter, buff,-1); 

			// update from log file
			/*
			owner->_options[option_string[menu_struct[i].option_base+index].keyword] = \
		              option_string[menu_struct[i].option_base+index].value;		
					  */
		}

	}; 

	for(i=0; i< sizeof(ckbutton_struct)/sizeof(UI_STRUCT);i++){
		GtkWidget * ckbutton= glade_xml_get_widget(xml, ckbutton_struct[i].ui_name);

		/*
		if ((GTK_WIDGET_SENSITIVE (ckbutton)) && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ckbutton)) == false){
			owner->_options[option_string[ckbutton_struct[i].option_base].keyword] = "F";
		}
		*/

		if ((!GTK_WIDGET_SENSITIVE (ckbutton)) || gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ckbutton)) == false)continue;
		memset(buff,0x00,128);
	       	snprintf(buff, 128, "%s",option_string[ckbutton_struct[i].option_base].option); 
		gtk_text_buffer_insert (buffer, &iter, buff,-1); 

		// update from log file
		/*
		owner->_options[option_string[ckbutton_struct[i].option_base].keyword] = \
	             option_string[ckbutton_struct[i].option_base].value;		
		*/

	}; 

	if( ref->prj->gamess_data->GetEFPData()->GetGroupCount() > 0 &&
			ref->prj->gamess_data->GetEFPData()->GetGroupCount(EFPGroup::QM) == 0 )
	{
		snprintf(buff,128," $CONTRL COORD=FRAGONLY $END\n"); 
		gtk_text_buffer_insert (buffer, &iter, buff,-1); 
	}

	entry1 = glade_xml_get_widget(xml,"control.maxscf");
	int maxvt = atoi(gtk_entry_get_text(GTK_ENTRY(entry1)));
	if(maxvt != 20){
		memset(buff,0x00,128);
		snprintf(buff,128,"%d",maxvt); 
		// update from log file
		/*
		owner->_options["MAXIT"] = buff;		
		*/

		memset(buff,0x00,128);
		snprintf(buff,128," $CONTRL MAXIT=%d $END\n",maxvt); 
		gtk_text_buffer_insert (buffer, &iter, buff,-1); 

	}

	entry1 = glade_xml_get_widget(xml,"general.timelimit");
	entry2 = glade_xml_get_widget(xml,"general.memory");
	snprintf(buff,128," $SYSTEM TIMLIM=%d MWORDS=%3.2f $END\n\n", 
	atoi(gtk_entry_get_text(GTK_ENTRY(entry1)))*60, 
	atoi(gtk_entry_get_text(GTK_ENTRY(entry2)))/8.0);
	gtk_text_buffer_insert (buffer, &iter, buff,-1); 

	/*
	owner->_options["TIMLIM"] = gtk_entry_get_text(GTK_ENTRY(entry1)); 
	owner->_options["MWORDS"] = gtk_entry_get_text(GTK_ENTRY(entry2));
	*/

	ostringstream oss;
	stringstream intermed;
	string mystr;

	//owner->WriteStream(intermed);
	//istringstream interInput(intermed.str());

	
	//translator.Export("\n",INP_TYPE - 1, interInput, oss);
	//mystr = oss.str();
	//gtk_text_buffer_insert (buffer, &iter, mystr.c_str(),-1); 
	
	if( ref->prj->gamess_data->GetEFPData()->GetGroupCount() > 0)
	{
		bool first = true;
		EFPData * data = ref->prj->gamess_data->GetEFPData();

		for(iter_efpgl g = data->GetGroupBegin(); g != data->GetGroupEnd(); g++)
		{
			if((*g).GetType() != EFPGroup::QM) continue;

			if(first) 
			{
				ref->PrintData(buffer, &iter);
				first = false;
			}

			for(iter_alp a = (*g).GetAtomsBegin(); a != (*g).GetAtomsEnd(); a++)
			{
				const fGL *crd;

				crd = (*a)->GetCRD(0);

				snprintf(buff,128,"%s%11.1f%16.6f%16.6f%16.6f\n",
						(*a)->el.GetSymbol(),
						(float)((* a)->el.GetAtomicNumber()),
						crd[0]*10,crd[1]*10,crd[2]*10
						);

				gtk_text_buffer_insert(buffer, &iter, buff, -1);

			}
			
			if(!first)
				gtk_text_buffer_insert (buffer, &iter, " $END\n\n",-1); 
		}


		gtk_text_buffer_insert(buffer, &iter, " $EFRAG\n\n", -1);


		for(iter_efpgl g = data->GetGroupBegin(); g != data->GetGroupEnd(); g++)
		{
			//we only care about EFPs at this point
			if((*g).GetType() != EFPGroup::EFP) continue;

			//get the c.o.m.
			fGL *com = (*g).GetCenterOfMass();

			//need to find the three atoms closest to the c.o.m.
			atom *atom[3];
			fGL dist[3];

			for(int i=0; i<3; i++)
			{
				atom[i] = NULL;
				dist[i] = 0.0;
			}

			for(iter_alp a = (*g).GetAtomsBegin(); a != (*g).GetAtomsEnd(); a++)
			{
				const fGL *crd;

				fGL d;

				crd = (*a)->GetCRD(0);

				d = ref->distance(crd, com);

				//printf("atom: %s distance: %f\n", (*a)->el.GetSymbol(), d);
				//for(int i=0; i<3; i++)
				//{
					//if(atom[i] == NULL)
					//{
						//printf("atom[%d]: null\n", i);
					//} else {
						//printf("atom[%d]: %s distance: %f\n", i, atom[i]->el.GetSymbol(), dist[i]);
					//}
				//}

				for(int i=0; i<3; i++)
				{
					if( atom[i] == NULL ) 
					{
						atom[i] = (*a);
						dist[i] = d;
						break;
					}
					if( d < dist[i] )
					{
						//printf("insert at %d\n", i);

						for(int j=2; j > i; j--)
						{
							//printf("atom[%d] becoming atom[%d]\n", j, j-1);
							atom[j] = atom[j-1];
							dist[j] = dist[j-1];
						}

						atom[i] = (*a);
						dist[i] = d;
						break;
					}
				}
			}

			//for(int i=0; i<3; i++)
			//{
				//if(atom[i] == NULL)
				//{
					//printf("atom[%d]: null\n", i);
				//} else {
					//printf("atom[%d]: %s distance: %f\n", i, atom[i]->el.GetSymbol(), dist[i]);
				//}
			//}


			snprintf(buff,128,"FRAGNAME=%s\n",
					(*g).GetLabel().c_str()
					);
			gtk_text_buffer_insert(buffer, &iter, buff, -1);

			for(int i=0; i<3; i++)
			{
				if(atom[i] == NULL) break;

				const fGL *crd;

				crd = atom[i]->GetCRD(0);


				snprintf(buff,128,"%s%d%16.6f%16.6f%16.6f\n",
						atom[i]->el.GetSymbol(), i+1,
						//(float)(atom[i]->el.GetAtomicNumber()),
						crd[0]*10,crd[1]*10,crd[2]*10
						);

				gtk_text_buffer_insert(buffer, &iter, buff, -1);
			}

			delete(com);
		}

		gtk_text_buffer_insert(buffer, &iter, " $END\n", -1);
		
	} else {
		// get the atoms and output them
		const fGL *crd;

		ref->PrintData(buffer, &iter);
		
		for (iter_al it1 = ref->prj->GetAtomsBegin();it1 != ref->prj->GetAtomsEnd();it1++)
		{
			crd = (* it1).GetCRD(0);
			snprintf(buff,128,"%s%11.1f%16.6f%16.6f%16.6f\n",
					(* it1).el.GetSymbol(),
					(float)((* it1).el.GetAtomicNumber()),
					crd[0]*10,crd[1]*10,crd[2]*10
					);

			gtk_text_buffer_insert(buffer, &iter, buff, -1);

		}

		gtk_text_buffer_insert (buffer, &iter, " $END\n",-1); 

	}

	istringstream chargestr(oss.str().c_str());
	string line;
	string s = " ";
	charge = 0;
	while (getline(chargestr,line,'\n'))
	{ 
		int pos1 = line.find_first_not_of(s,line.find_first_of(s,0));
		int pos2 = line.find_first_of(s,pos1);
		string str = line.substr(pos1,pos2-pos1);
		/*
		cout<<str<<endl;
		*/
		memset(buff,0x00,128);
		for(int j=0; j<pos2-pos1;j++)buff[j]=line[j+pos1]; 
		charge += (int)atof(buff);
	}

}

fGL gamess_dialog::distance(const fGL *i, const fGL *j)
{
	fGL xd, yd, zd;
	xd = i[0] - j[0];
	yd = i[1] - j[1];
	zd = i[2] - j[2];
	return(sqrtf(fabs(xd) + fabs(yd) + fabs(zd)));
}

void gamess_dialog::PrintData(GtkTextBuffer *buffer, GtkTextIter *iter)
{
	char buff[128];

	gtk_text_buffer_insert (buffer, iter, " $DATA\n",-1); 
	snprintf(buff,128,"%s\n", gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(xml,"data.title"))));
	gtk_text_buffer_insert (buffer, iter, buff,-1); 
	//owner->_options["RUNTITLE"] = gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(xml,"InpEdit.title.entry")));

	GtkWidget * optmenu = glade_xml_get_widget(xml, menu_struct[OPTION_MENU_POINT_GROUP].ui_name);
	GtkWidget * submenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optmenu));
	GtkWidget * item = gtk_menu_get_active(GTK_MENU(submenu));

	int pg = g_list_index(GTK_MENU_SHELL(submenu)->children, item);

	memset(buff,0x00,128);
	snprintf(buff,128,"%s", option_string[DATA_PG_OPTION_MENU+pg].option);
	gtk_text_buffer_insert (buffer, iter, buff,-1); 

	optmenu = glade_xml_get_widget(xml, menu_struct[OPTION_MENU_ORDER].ui_name);

	if(GTK_WIDGET_SENSITIVE(optmenu)){
				
		submenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optmenu));
		item = gtk_menu_get_active(GTK_MENU(submenu));
		int order = g_list_index(GTK_MENU_SHELL(submenu)->children, item);

		memset(buff,0x00,128);

		
		snprintf(buff,128,"%s", option_string[DATA_ORDER_OPTION_MENU+order].option);
		
		gtk_text_buffer_insert (buffer, iter, buff,-1); 

	}
}


void gamess_dialog::handler_ButtonCancel(GtkWidget *widget, gpointer data)
{
	gamess_dialog * ref = (gamess_dialog *) data;
	cout << "handler_ButtonCancel() : ref = " << ref << endl;
	
	// close the dialog...
	//
	
	gtk_widget_destroy(ref->dialog);
}

void gamess_dialog::handler_ButtonSave(GtkWidget *widget, gpointer data)
{ 
	GtkWidget *entry1,*entry2;

	UpdateData(widget,data);
	
	gamess_dialog * ref = (gamess_dialog *) data;
	cout << "handler_ButtonCancel() : ref = " << ref << endl;

	//gnome_mm1_docv * docv= dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	setup1_mm * owner = dynamic_cast<setup1_mm *>(ref->prj->GetCurrentSetup());
	if (!owner) cout << "ERROR: cast failed in file_export_dialog::handler_ButtonOK()." << endl;

	entry1 = glade_xml_get_widget(ref->xml,"control.multiplicity");
	int multiplicity = atoi(gtk_entry_get_text(GTK_ENTRY(entry1)));

	entry2 = glade_xml_get_widget(ref->xml,"control.charge");
	int  molcharge = atoi(gtk_entry_get_text(GTK_ENTRY(entry2)));

	if( (charge - molcharge +1)%2 != multiplicity%2)
	{
		char buff[256];
		snprintf(buff,128,"Error: You chose a multiplicy of %d, but your molecule contains %d electrons.  Either the multiplicity or charge (%d) you selected is wrong.\n",multiplicity,charge - molcharge,molcharge);
		//owner->PrintToLog(buff);

		return;
	}

	if (owner) new config_file_save_dialog(ref);
						
	// close the dialog...
}

void gamess_dialog::handler_ButtonSubmit(GtkWidget *widget, gpointer data)
{
	GtkWidget *entry1,*entry2;
		
	UpdateData(widget,data);

	gamess_dialog * ref = (gamess_dialog *) data;
	cout << "handler_ButtonCancel() : ref = " << ref << endl;


	setup1_mm * owner = dynamic_cast<setup1_mm *>(ref->prj->GetCurrentSetup());
	if (!owner) cout << "ERROR: cast failed in file_export_dialog::handler_ButtonOK()." << endl;


	entry1 = glade_xml_get_widget(ref->xml,"control.multiplicity");
	int multiplicity = atoi(gtk_entry_get_text(GTK_ENTRY(entry1)));

	entry2 = glade_xml_get_widget(ref->xml,"control.charge");
	int  molcharge = atoi(gtk_entry_get_text(GTK_ENTRY(entry2)));

	if( (charge - molcharge +1)%2 != multiplicity%2)
	{
		char buff[256];
		snprintf(buff,128,"Error: You chose a multiplicy of %d, but your molecule contains %d electrons.  Either the multiplicity or charge (%d) you selected is wrong.\n",multiplicity,charge,molcharge);
		//owner->PrintToLog(buff);

		return;
	}
	
	// close the dialog...
	if (owner) new config_file_submit_dialog(ref);

#if 0
	gtk_widget_destroy(ref->dialog);
#endif
	
}


void gamess_dialog::handler_ButtonReviewOK(GtkWidget *widget, gpointer data)
{
	gamess_dialog * ref = (gamess_dialog *) data;
	GladeXML* xml = ref->xml;

	GtkWidget* text;
	GtkTextBuffer *buffer;
	GtkTextIter start, end;
	int len;
			
	text = glade_xml_get_widget(xml,"review.text");
	// len = gtk_text_get_length(GTK_TEXT(text));
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	gtk_text_buffer_get_start_iter(buffer, &start);
	gtk_text_buffer_get_end_iter(buffer, &end);
		
	backupstr.str("");
	backupstr<< gtk_text_buffer_get_text(buffer, &start, &end, false);

	GtkWidget* review = glade_xml_get_widget(xml,"config_edit_dialog");
	gtk_widget_hide(review);
}


void gamess_dialog::handler_ButtonReviewCancel(GtkWidget *widget, gpointer data)
{
	gamess_dialog * ref = (gamess_dialog *) data;
	GladeXML* xml = ref->xml;

	backupstr.str("");
	
	GtkWidget* review = glade_xml_get_widget(xml,"config_edit_dialog");
	gtk_widget_hide(review);
}

void gamess_dialog::delay_Destroy(void) {
	
	gtk_widget_destroy(this->dialog);
}

void gamess_dialog::handler_Destroy(GtkWidget *widget, gpointer data) {
	gamess_dialog * ref = (gamess_dialog *) data;
	cout << "handler_Destroy() : ref = " << ref << endl;
	
	delete ref;	// the object was created with new!!!
}

void gamess_dialog::handler_CheckButtonToggled(GtkWidget *widget, gpointer data) {

	UI_STRUCT* ms = (UI_STRUCT* )data;
	
       GladeXML* xml = *((GladeXML**)(ms->root));
	switch(ms->option_base)
	{	
			
	case CONTROL_MP2_CHECK_BUTTON:
		{
		   
		gboolean value = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

		GtkWidget *tab = glade_xml_get_widget(xml, "mp2");

		if(value){
			if(!GTK_WIDGET_VISIBLE(tab))gtk_widget_show(tab);

			GtkWidget * radio= glade_xml_get_widget(xml, "mp2.tran.segmented");
			gtk_widget_set_sensitive(radio,TRUE);
			radio = glade_xml_get_widget(xml, "mp2.tran.twophase");
			gtk_widget_set_sensitive(radio,TRUE);
			radio = glade_xml_get_widget(xml, "mp2.ao.each");
			gtk_widget_set_sensitive(radio,TRUE);
			radio = glade_xml_get_widget(xml, "mp2.ao.all");
			gtk_widget_set_sensitive(radio,TRUE);
		}
		else{
			if(GTK_WIDGET_VISIBLE(tab))gtk_widget_hide(tab);
			GtkWidget * radio= glade_xml_get_widget(xml, "mp2.tran.segment");
			gtk_widget_set_sensitive(radio,FALSE);
			radio = glade_xml_get_widget(xml, "mp2.tran.twophase");
			gtk_widget_set_sensitive(radio,FALSE);
			radio = glade_xml_get_widget(xml, "mp2.ao.each");
			gtk_widget_set_sensitive(radio,FALSE);
			radio = glade_xml_get_widget(xml, "mp2.ao.all");
			gtk_widget_set_sensitive(radio,FALSE);
		}
				    
		}

			break;
			
		
	default:
#if 0
		g_print ("Default: %i\n", ((int*)data)[1]);
#endif
		break;
	}
}


void gamess_dialog::delay_Save(const char* filename)
{
		ofstream ofile;
		GtkWidget* text;
		GtkTextBuffer *buffer;
		GtkTextIter start, end;
		int len;
			
		ofile.open(filename, ios::out);
		text = glade_xml_get_widget(xml,"review.text");
		buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
		gtk_text_buffer_get_start_iter(buffer, &start);
		gtk_text_buffer_get_end_iter(buffer, &end);
		
		if(backupstr.str().length()==0)
		
			ofile<< gtk_text_buffer_get_text(buffer, &start, &end, false);
		    //ofile << gtk_editable_get_chars(GTK_EDITABLE(text),0,len);
		else
		     ofile << backupstr.str().c_str();
			
		ofile.close();
}

void gamess_dialog::handler_OptionMenuChanged(GtkMenuShell *menu_shell,
		                    gpointer data)
{

	UI_STRUCT* ms = (UI_STRUCT*)data;
	
        GladeXML* xml = *((GladeXML**)(ms->root));
	GtkWidget *active_item;
	gint item_index;
			      
	active_item = gtk_menu_get_active (GTK_MENU (menu_shell));
	item_index = g_list_index (menu_shell->children, active_item);
			
#if 0
	g_print("%s \n", option_string[ms->option_base+ item_index]);
#endif

	switch(ms->option_base)
	{
	case GENERAL_CALC_OPTION_MENU:
		{
			int i = ms->option_base+item_index;
			GtkWidget * optmenu = glade_xml_get_widget(xml, ui_option[i].widget_name);
			if ( GTK_WIDGET_SENSITIVE (optmenu))
				gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu),ui_option[i].option_index);
		}

		menu_struct[OPTION_MENU_RUN_TYPE].value= INVALID;
		menu_struct[OPTION_MENU_CALCULATE].value= VALID;

		break;
		
	case GENERAL_WITH_LEFT_OPTION_MENU:
		{
			int i = ms->option_base+item_index;
			GtkWidget * optmenu = glade_xml_get_widget(xml, ui_option[i].widget_name);
			if ( GTK_WIDGET_SENSITIVE (optmenu) && ui_option[i].option_index != -1)
					gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu),ui_option[i].option_index);


			GtkWidget *active_item;
			gint item_index;
			      
			active_item = gtk_menu_get_active (GTK_MENU (menu_shell));
			item_index = g_list_index (menu_shell->children, active_item);

			GtkWidget * other = glade_xml_get_widget(xml, "general.with.denominator");
			GtkWidget * in = glade_xml_get_widget(xml, "general.in");
			GtkWidget * submenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(in));



			if(item_index > 1){
				if (! GTK_WIDGET_SENSITIVE (other))gtk_widget_set_sensitive (other, TRUE);
				GtkMenuItem* menuitem = (GtkMenuItem*)g_list_nth_data(GTK_MENU_SHELL(submenu)->children,1);
				GtkWidget * item = GTK_BIN(menuitem)->child;
				if (item != NULL && !GTK_WIDGET_SENSITIVE (item))gtk_widget_set_sensitive(item,TRUE);
			}
			else
			{
				if (GTK_WIDGET_SENSITIVE (other))gtk_widget_set_sensitive (other, FALSE);
				gtk_option_menu_set_history(GTK_OPTION_MENU(in),0);

				GtkMenuItem* menuitem = (GtkMenuItem*)g_list_nth_data(GTK_MENU_SHELL(submenu)->children,1);
				GtkWidget * item = GTK_BIN(menuitem)->child;
				if (GTK_WIDGET_SENSITIVE (item))gtk_widget_set_sensitive(item,FALSE);
			}

			GtkWidget * mp2 = glade_xml_get_widget(xml, "control.mp2");

			if(item_index == 4){ /* MP2 */
				if(!GTK_WIDGET_SENSITIVE(mp2))gtk_widget_set_sensitive(mp2,TRUE);
			}
			else
			{
				if(GTK_WIDGET_SENSITIVE(mp2)){
					if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(mp2)))
							gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(mp2),FALSE);
					gtk_widget_set_sensitive(mp2,FALSE);
				}
			}

#if 0
			g_print ("In on_option_selected active: %i\n", item_index);
#endif
		}
	
		break;


	case GENERAL_WITH_RIGHT_OPTION_MENU:

		menu_struct[OPTION_MENU_BASIS_SET].value= INVALID;
		menu_struct[OPTION_MENU_WITH_RIGHT].value= VALID;

		{
			int i = ms->option_base+item_index;
			GtkWidget * optmenu = glade_xml_get_widget(xml, ui_option[i].widget_name);
			if ( GTK_WIDGET_SENSITIVE (optmenu) && ui_option[i].option_index != -1)
					gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu),ui_option[i].option_index);

		}
		
		break;
		
	case GENERAL_IN_OPTION_MENU:
		{
			GtkWidget * with_left = glade_xml_get_widget(xml, "general.with.numerator");
			GtkWidget * submenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(with_left));
			GtkWidget * item = gtk_menu_get_active(GTK_MENU(submenu));
			gint index = g_list_index (GTK_MENU_SHELL(submenu)->children, item);

			if(index < 2 && item_index == 1){
				GtkWidget * in = glade_xml_get_widget(xml, "general.in");
				gtk_option_menu_set_history(GTK_OPTION_MENU(in),0);
				GtkWidget * submenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(in));
				GtkMenuItem* menuitem = (GtkMenuItem*)g_list_nth_data(GTK_MENU_SHELL(submenu)->children,1);
				GtkWidget * item = GTK_BIN(menuitem)->child;
				gtk_widget_set_sensitive(item,FALSE);
			}
		}

		break;
		
	case GENERAL_ON_LEFT_OPTION_MENU:

		{
			int i = ms->option_base+item_index;
			GtkWidget * optmenu = glade_xml_get_widget(xml, ui_option[i].widget_name);
			if ( GTK_WIDGET_SENSITIVE (optmenu) && ui_option[i].option_index != -1)
					gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu),ui_option[i].option_index);

			char buff[128];
			snprintf(buff,128,"%d", item_index+1);
			gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(xml,"control.multiplicity")), buff);


			menu_struct[OPTION_MENU_SCF].value= INVALID;
		}
				
		break;
	case GENERAL_ON_RIGHT_OPTION_MENU:

		{
			char buff[128];
			snprintf(buff,128,"%d", 2-item_index);
			gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(xml,"control.charge")), buff);
		}
	
		break;

	case BASIS_BASIS_SET_OPTION_MENU:

		menu_struct[OPTION_MENU_BASIS_SET].value= VALID;
		menu_struct[OPTION_MENU_WITH_RIGHT].value= INVALID;


		break;
	case BASIS_ECP_OPTION_MENU:
	case BASIS_DHAPF_OPTION_MENU:
	case BASIS_FHAPF_OPTION_MENU:
	case BASIS_LAPF_OPTION_MENU:
	case BASIS_POLAR_OPTION_MENU:
		
#if 0
		g_print ("Intercept: %i\n", ((int*)data)[1]);
#endif
			break;
	
    	case CONTROL_RUN_TYPE_OPTION_MENU: 

		menu_struct[OPTION_MENU_CALCULATE].value= INVALID;
		menu_struct[OPTION_MENU_RUN_TYPE].value= VALID;

			break;
			
	case CONTROL_SCF_OPTION_MENU:
		
		{
			if(item_index == 2 && menu_struct[OPTION_MENU_ON_LEFT].value == VALID)
				menu_struct[OPTION_MENU_ON_LEFT].value == INVALID;

			if( menu_struct[OPTION_MENU_SCF].value == INVALID )
				menu_struct[OPTION_MENU_SCF].value = VALID;

		}
			break;
	case CONTROL_CI_OPTION_MENU:
	case CONTROL_LOCAL_OPTION_MENU:
	case CONTROL_EXE_OPTION_MENU:

	case DATA_COORD_TYPE_OPTION_MENU:
	case DATA_UNIT_OPTION_MENU:
		break;

	case DATA_PG_OPTION_MENU:

		switch(item_index)
		{
		case 0:
		case 1:
		case 2:
		case 10:
		case 11:
		case 12:
		case 13:
		case 14:

			{
						
				GtkWidget * order = glade_xml_get_widget(xml, "data.axis");
				if (GTK_WIDGET_SENSITIVE (order))gtk_widget_set_sensitive(order,FALSE);
			}
			
			break;
		case 3:
		case 4:
		case 5:
		case 6:
		case 7:
		case 8:
		case 9:	
			
			{
						
				GtkWidget * order = glade_xml_get_widget(xml, "data.axis");
				if (!GTK_WIDGET_SENSITIVE (order))gtk_widget_set_sensitive(order,TRUE);
			}
			break;
			
		default:
			break;
		}
		break;
		
	case DATA_ORDER_OPTION_MENU:

			break;
	
	case SYSTEM_TIMELIMIT_OPTION_MENU:
	case SYSTEM_MEMORY_OPTION_MENU:
	case SYSTEM_DIAG_METHOD_OPTION_MENU:
	
	case MO_GUESS_OPTION_MENU:
#if 0
		g_print ("Intercept: %i\n", ((int*)data)[1]);
#endif
		break;
	default:
#if 0
		g_print("error \n");
#endif
		break;
	}
}

#endif  // ENABLE_GAMESS

/*################################################################################################*/

// eof
