/* GtkEditor - a source editor widget for GTK
 * Copyright (C) 1998 Thomas Mailund.
 *
 * The editor widget was written by Thomas Mailund, so bugs should be
 * reported to <mailund@daimi.au.dk>, not the gtk ppl.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef INTERNAL_H
#define INTERNAL_H

#include <sys/types.h>
#include <regex.h>

#include "gtkeditor.h"
#include "syntaxtable.h"

/* These functions should never be seen outside gtkeditor. the prefix
 * _gtk_editor_ is to prevent nameclash in linking. */
gboolean         _gtk_editor_txteq           (GtkSCText          *text,
					      char             *string,
					      int               index);
GdkFont         *_gtk_editor_fontdup         (GdkFont          *font);
GdkColor        *_gtk_editor_coldup          (const GdkColor   *color);


#endif /* INTERNAL_H */
