/* $Header: /cvs/gnome/gIDE/src/gI_menus.c,v 1.4 1999/12/04 07:11:25 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#include <string.h>
#include "structs.h"
#include "gI_file.h"
#include "gI_edit.h"
#include "gI_compile.h"
#include "gI_search.h"
#include "gI_pathwidget.h"
#include "gI_menus.h"
#include "gI_functions.h"
#include "gI_files.h"
#include "gI_tree.h"
#include "gI_prefs.h"
#include "gI_about.h"
#include "gI_help.h"
#include "gI_project.h"
#include "gI_tools.h"
#include "gI_hilite.h"
#include "gI_run.h"
#include "gI_debug.h"

/* externs */
extern gI_window *main_window;

/******************************************************************
  First, We'll Create the structures for the GNOME Menubar
******************************************************************/

GList *menu_pw_assoc = NULL;

void create_menubar( GtkWidget *app, GtkWidget *vbox )
{
	GnomeUIInfo filemenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("_New"), N_("New Source File"), file_new, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	     'N', GDK_CONTROL_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Open"), N_("Open File"), file_open, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	     'O', GDK_CONTROL_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Reload"), N_("Reload Current File"), file_reload, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'R', GDK_MOD1_MASK, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("_Save"), N_("Save Current File"), file_save, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
	     'S', GDK_CONTROL_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Save _As"), N_("Save As"), file_save_as, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("_Print"), N_("Print Current File"), file_print, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
	     'P', GDK_MOD1_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Close"), N_("Close Current File"), file_close, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
	     'Q', GDK_CONTROL_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Close All"), N_("Close All"), close_all_files, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("E_xit"), N_("Exit"), file_exit, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT,
	     'X', GDK_MOD1_MASK, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo deletemenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("To Begin of File"), N_("Delete to the beginning of the file"),
	     edit_delete_to_bof, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("To End of File"), N_("Delete to the end of the file"),
	     edit_delete_to_eof, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("To Begin of Line"), N_("Delete to the beginning of the line"),
	     edit_delete_to_bol, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("To End of Line"), N_("Delete to the end of the line"),
	     edit_delete_to_bof, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo insertmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("Date and Time"), N_("Insert Date and Time"), edit_date_time,
	     NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("GPL-Notice (C)"), N_("Insert GPL-Notice"), edit_gpl_c,
	     NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("GPL-Notice (C++)"), N_("Insert GPL-Notice"), edit_gpl_cpp,
	     NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo replacemenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("TABs with Spaces"), N_("Replace TABs with Spaces"), edit_repl_tab_spaces,
	     NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo editmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("_Undo"), N_("Undo Last Change"), edit_undo, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_UNDO,
	     'Z', GDK_CONTROL_MASK, NULL },
	    {GNOME_APP_UI_ITEM,
	     N_("_Redo"), N_("Redo Last Undid Change"), edit_redo, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REDO,
	     'R', GDK_CONTROL_MASK, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("Cut"), N_("Cut"), edit_cut, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CUT,
	     'X', GDK_CONTROL_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Copy"), N_("Copy"), edit_copy, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_COPY,
	     'C', GDK_CONTROL_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Paste"), N_("Paste"), edit_paste, NULL, NULL,
	     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PASTE,
	     'V', GDK_CONTROL_MASK, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("Select _All"), N_("Select All"), edit_select_all, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'A', GDK_MOD1_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Select _Line"), N_("Select Line"), edit_select_line, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'L', GDK_MOD1_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Select _Word"), N_("Select Word"), NULL, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    GNOMEUIINFO_SUBTREE(N_("_Insert"), insertmenu),
	    GNOMEUIINFO_SUBTREE(N_("_Delete"), deletemenu),
	    GNOMEUIINFO_SUBTREE(N_("_Replace"), replacemenu),
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_TOGGLEITEM,
	     N_("Read Only"), N_("Edit Read Only"), edit_read_only, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo searchmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("_Find"), N_("Find"), search_search, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'S', GDK_MOD1_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Find _Again"), N_("Find Again"), search_again, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'A', GDK_MOD1_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Find&Replace"), N_("Find and Replace"), search_replace, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("Find in Files"), N_("Find in Files"), find_in_files, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Replace in Files"), N_("Replace in Files"), replace_in_files, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("Goto Line"), N_("Goto Line"), search_goto_line, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'G', GDK_CONTROL_MASK, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("Match Brace"), N_("Match Brace"), NULL, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo distmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("Create DEB"), N_("Create DEB"), NULL, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Create RPM"), N_("Create RPM"), NULL, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo projectmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("_New Project"), N_("New Project"), project_new, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Open Project"), N_("Open Project"), project_open, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Edit Project"), N_("Edit Project"), project_edit, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Close Project"), N_("Close Project"), project_close, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Delete Project"), N_("Delete Project"), project_delete, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("Build Project"), N_("Build Project"), build_project, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("Create Makefile"), N_("Create Makefile"), create_makefile, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Create Configure"), N_("Create Configure"), NULL, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    GNOMEUIINFO_SUBTREE(N_("Create Distribution"), distmenu),
	    GNOMEUIINFO_END
	};

	GnomeUIInfo runmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("Run"), N_("Run Application"), run_run, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F6, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Parameters"), N_("Edit Runtime Parameters"), run_parameters, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo compilemenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("Compile to _Exec."), N_("Create Executable"), compile_compile, (gpointer)COMPILE_EXEC, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F8, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Compile to _Obj."), N_("Create Objectfile"), compile_compile, (gpointer)COMPILE_OBJ, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Make"), N_("Make"), compile_make, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'M', GDK_CONTROL_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("_Link"), N_("Link"), compile_link, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'L', GDK_CONTROL_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Build _All"), N_("Build All"), NULL, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Syntax Check"), N_("check_syntax"), compile_syntax_check, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo debugmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("Start Debug"), N_("Start Debug"), debug_debug, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F5, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Attach to Process"), N_("Attach to Process"), debug_attach, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Stop Debug"), N_("Stop Debug"), debug_stop_debug, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F5, GDK_SHIFT_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Set/Clear Breakpoint"), N_("Set or Clear Breakpoint"), debug_set_breakpoint, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F9, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Step Over"), N_("Step Over"), debug_step_over, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F10, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Step Into"), N_("Step Into"), debug_step_into, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F11, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Break"), N_("Break"), debug_break, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F12, 0, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo toolsmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("ASCII Table"), N_("ASCII Table"), tools_ascii_table, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Calculator"), N_("Calculator"), tools_calculator, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    /*{GNOME_APP_UI_ITEM,
	     N_("Code Browser"), N_("Code Browser"), gI_SCB_open, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},*/
	    {GNOME_APP_UI_ITEM,
	     N_("Difference Report"), N_("Difference Report"), tools_diff, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Prototype Generator"), N_("Prototype Generator"), gen_proto, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Word Count"), N_("Word Count"), tools_word_count, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    GNOMEUIINFO_END
	};

	GnomeUIInfo prefmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("Preferences..."), N_("Edit Preferences"), show_preferences, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Custom Tools..."), N_("Custom Tools..."), custom_tools, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("Reload Config"), N_("Reload COnfig"), reload_config, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Set to Defaults"), N_("Set to Defaults"), set_to_defaults, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    GNOMEUIINFO_END
	};

#ifdef HAVE_GTKTEXT_PATCH
	GnomeUIInfo highlightmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("Define Regexps..."), N_("Define Regexps..."), gI_hilite_set_buffer_patterns_cb, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Re-Highlight"), N_("Re-Highlight"), gI_hilite_rehilite, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
	    GNOMEUIINFO_END
	};
#endif

	GnomeUIInfo windowmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("Files"), N_("Files"), show_all_files, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'F', GDK_SHIFT_MASK, NULL},
/*	    {GNOME_APP_UI_ITEM,
	     N_("Functions"), N_("Functions"),
	     show_all_functions, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'F', GDK_CONTROL_MASK, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Tree"), N_("Tree"), show_tree, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     'T', GDK_SHIFT_MASK, NULL},*/
	    GNOMEUIINFO_END
	};

	GnomeUIInfo helpmenu[] = {
	    {GNOME_APP_UI_ITEM,
	     N_("Help"), N_("Help"), show_help, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F1, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("Manual Pages"), N_("Manual Pages"), help_man_page, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     GDK_F1, GDK_MOD1_MASK, NULL},
	    GNOMEUIINFO_SEPARATOR,
	    {GNOME_APP_UI_ITEM,
	     N_("About Help"), N_("About Help"), about_help, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    {GNOME_APP_UI_ITEM,
	     N_("About gIDE"), N_("About gIDE"), about_gide, NULL, NULL,
	     GNOME_APP_PIXMAP_NONE, NULL,
	     0, 0, NULL},
	    GNOMEUIINFO_END
	};

	GnomeUIInfo mainmenu[] = {
	    GNOMEUIINFO_SUBTREE(N_("_File"), filemenu),
	    GNOMEUIINFO_SUBTREE(N_("_Edit"), editmenu),
	    GNOMEUIINFO_SUBTREE(N_("_Search"), searchmenu),
	    GNOMEUIINFO_SUBTREE(N_("_Project"), projectmenu),
	    GNOMEUIINFO_SUBTREE(N_("_Run"), runmenu),
	    GNOMEUIINFO_SUBTREE(N_("_Compile"), compilemenu),
	    GNOMEUIINFO_SUBTREE(N_("_Debug"), debugmenu),
	    GNOMEUIINFO_SUBTREE(N_("_Tools"), toolsmenu),
	    GNOMEUIINFO_SUBTREE(N_("Sett_ings"), prefmenu),
#ifdef HAVE_GTKTEXT_PATCH
	    GNOMEUIINFO_SUBTREE(N_("_Highlight"), highlightmenu),
#endif
	    GNOMEUIINFO_SUBTREE(N_("_Windows"), windowmenu),
	    GNOMEUIINFO_SUBTREE(N_("_Help"), helpmenu),
	    GNOMEUIINFO_END
	};

	/* create menus (the widget field is filled here) */
	gnome_app_create_menus( GNOME_APP(app), mainmenu );

	/* install hints */
	gnome_app_install_statusbar_menu_hints(
	    GTK_STATUSBAR( GNOME_APP( app )->statusbar ),
	    mainmenu );

	/* now we create a GList with the widgets */
	/* File Menu */
	menus_add_item_widget( "/File/New", filemenu[0].widget );
	menus_add_item_widget( "/File/Open", filemenu[1].widget );
	menus_add_item_widget( "/File/Reload", filemenu[2].widget );
	menus_add_item_widget( "/File/Save", filemenu[4].widget );
	menus_add_item_widget( "/File/Save As", filemenu[5].widget );
	menus_add_item_widget( "/File/Print", filemenu[7].widget );
	menus_add_item_widget( "/File/Close", filemenu[8].widget );
	menus_add_item_widget( "/File/Close All", filemenu[9].widget );
	menus_add_item_widget( "/File/Exit", filemenu[11].widget );

	/* Edit Menu */
	menus_add_item_widget( "/Edit/Undo", editmenu[0].widget );
	menus_add_item_widget( "/Edit/Redo", editmenu[1].widget );
	menus_add_item_widget( "/Edit/Cut", editmenu[3].widget );
	menus_add_item_widget( "/Edit/Copy", editmenu[4].widget );
	menus_add_item_widget( "/Edit/Paste", editmenu[5].widget );
	menus_add_item_widget( "/Edit/Select All", editmenu[7].widget );
	menus_add_item_widget( "/Edit/Select Line", editmenu[8].widget );
	menus_add_item_widget( "/Edit/Select Word", editmenu[9].widget );
	menus_add_item_widget( "/Edit/Date-Time", insertmenu[0].widget ); /* /Edit/Insert/Date-Time */
	menus_add_item_widget( "/Edit/Insert/GPL-Notice (C)", insertmenu[1].widget );
	menus_add_item_widget( "/Edit/Insert/GPL-Notice (C++)", insertmenu[2].widget );
	menus_add_item_widget( "/Edit/Delete/To begin of file", deletemenu[0].widget );
	menus_add_item_widget( "/Edit/Delete/To end of file", deletemenu[1].widget );
	menus_add_item_widget( "/Edit/Delete/To begin of line", deletemenu[2].widget );
	menus_add_item_widget( "/Edit/Delete/To end of line", deletemenu[3].widget );
	menus_add_item_widget( "/Edit/Replace/TABs with Spaces", replacemenu[0].widget );
	menus_add_item_widget( "/Edit/Read Only", editmenu[15].widget );

	/* Search Menu */
	menus_add_item_widget( "/Search/Find", searchmenu[0].widget );
	menus_add_item_widget( "/Search/Find Again", searchmenu[1].widget );
	menus_add_item_widget( "/Search/Find&Replace", searchmenu[2].widget );
	menus_add_item_widget( "/Search/Find in Files", searchmenu[4].widget );
	menus_add_item_widget( "/Search/Replace in Files", searchmenu[5].widget );
	menus_add_item_widget( "/Search/Goto Line", searchmenu[7].widget );
	menus_add_item_widget( "/Search/Match Brace", searchmenu[9].widget );

	/* Project Menu */
	menus_add_item_widget( "/Project/New Project", projectmenu[0].widget );
	menus_add_item_widget( "/Project/Open Project", projectmenu[1].widget );
	menus_add_item_widget( "/Project/Edit Project", projectmenu[2].widget );
	menus_add_item_widget( "/Project/Close Project", projectmenu[3].widget );
	menus_add_item_widget( "/Project/Delete Project", projectmenu[4].widget );
	menus_add_item_widget( "/Project/Build Project", projectmenu[6].widget );
	menus_add_item_widget( "/Project/Create Makefile", projectmenu[8].widget );
	menus_add_item_widget( "/Project/Create configure", projectmenu[9].widget );
	menus_add_item_widget( "/Project/Create Distribution/Create DEB", distmenu[0].widget );
	menus_add_item_widget( "/Project/Create Distribution/Create RPM", distmenu[1].widget );

	/* Run Menu */
	menus_add_item_widget( "/Run/Run", runmenu[0].widget );
	menus_add_item_widget( "/Run/Parameters", runmenu[1].widget );

	/* Compile Menu */
	menus_add_item_widget( "/Compile/Compile to Exec.", compilemenu[0].widget );
	menus_add_item_widget( "/Compile/Compile to Obj.", compilemenu[1].widget );
	menus_add_item_widget( "/Compile/Make", compilemenu[2].widget );
	menus_add_item_widget( "/Compile/Link", compilemenu[3].widget );
	menus_add_item_widget( "/Compile/Build All", compilemenu[4].widget );
	menus_add_item_widget( "/Compile/Syntax Check", compilemenu[5].widget );

	/* Debug Menu */
	menus_add_item_widget( "/Debug/Start Debug", debugmenu[0].widget );
	menus_add_item_widget( "/Debug/Attach to Process", debugmenu[1].widget );
	menus_add_item_widget( "/Debug/Stop  Debug", debugmenu[2].widget );
	menus_add_item_widget( "/Debug/Set|Clear Breakpoint", debugmenu[3].widget );
	menus_add_item_widget( "/Debug/Step Over", debugmenu[4].widget );
	menus_add_item_widget( "/Debug/Step Into", debugmenu[5].widget );
	menus_add_item_widget( "/Debug/Break", debugmenu[6].widget );

	/* some menus missing .. add later */
}

void menus_set_sensitive( gchar *path, gint sensitive )
{
	GtkWidget *widget = NULL;

	g_return_if_fail( path != NULL );

	widget = menus_get_item_widget( path );
	if( widget )
		gtk_widget_set_sensitive( widget, sensitive );
	else
		g_warning("Unable to set sensitivity for menu which doesn't exist: %s", path);
}

GtkWidget *menus_get_item_widget( gchar *path )
{
	GtkWidget *widget = NULL;

	g_return_val_if_fail( path != NULL, NULL );

	widget = gI_PWassoc_lookup( menu_pw_assoc, path );

	return( widget );
}

void menus_add_item_widget( gchar *path, GtkWidget *widget) {
	menu_pw_assoc = gI_PWassoc_add(menu_pw_assoc, path, widget);
}

void menus_remove_item_widget( gchar *path ) {
	menu_pw_assoc = gI_PWassoc_remove( menu_pw_assoc, path );
}

void menus_free_items( void ) {
	gI_PWassoc_free(menu_pw_assoc);
	menu_pw_assoc = NULL;
}