/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DND_H__
#define __DND_H__

#include "gimageview.h"

typedef enum
{
   TARGET_URI_LIST,
   TARGET_TEXT,
   TARGET_TAB
} TargetType;


extern GtkTargetEntry dnd_types[];
extern const gint dnd_types_num;


GList *dnd_get_file_list     (const gchar          *string);
void   dnd_src_set           (GtkWidget            *widget,
			      const GtkTargetEntry *entry,
			      gint                  num);
void   dnd_dest_set          (GtkWidget            *widget,
			      const GtkTargetEntry *entry,
			      gint                  num);
void   dnd_file_operation    (const gchar          *dest_dir,
			      GdkDragContext       *context,
			      GtkSelectionData     *seldata,
			      guint                 time,
			      ThumbWindow          *tw);

#endif /* __DND_H__ */
