/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FILE_H__
#define __FILE_H__

#include "gimageview.h"


/* 
 *  For open iamge files, store file list, dir list, and any other infomations.
 */
typedef enum
{
   LOAD_CACHE,
   CREATE_THUMB
} ThumbLoadType;


typedef enum
{
   NO_OPEN_FILE,
   END,
   GETTING_FILELIST,
   IMAGE_LOADING,
   IMAGE_LOAD_DONE,
   THUMB_LOADING,
   THUMB_LOAD_DONE,
   CANCEL              = 30,
   STOP                = 31,
   CONTAINER_DESTROYED = -1,
   WINDOW_DESTROYED    = -2
} LoadStatus;


struct OpenFiles_Tag
{
   GList        *filelist;
   GList        *dirlist;
   const gchar  *dirname;

   GtkWidget    *window;      /* window containes progress bar */
   GtkWidget    *progressbar;

   /* for thumbnail */
   ThumbLoadType thumb_load_type;

   /* cancel */
   LoadStatus    status;

   /* progress infomation */
   const gchar  *now_file;
   gint          pos;
   gint          num;
};


ImageView   *image_file_load                    (const gchar     *filename);
OpenFiles   *files_loader_new                   ();
gboolean     files_loader_query_loading         ();
void         files_loader_delete                (OpenFiles       *files);
void         files_loader_stop                  ();

gint         open_image_files_in_image_view     (OpenFiles       *files);
gint         open_image_files_in_thumbnail_view (OpenFiles       *files,
						 ThumbWindow     *tw);
gint         open_image_files                   (OpenFiles       *files);
gint         open_dir_images                    (const gchar     *dirname,
						 ThumbWindow     *tw,
						 ThumbLoadType    type,
						 gboolean         scan_subdir);
gint         open_dirs                          (OpenFiles       *files,
						 ThumbWindow     *tw,
						 ThumbLoadType    type,
						 gboolean         scan_subdir);
gint         open_images_dirs                   (GList           *list,
						 ThumbWindow     *tw,
						 ThumbLoadType    type,
						 gboolean         scan_subdir);

GtkWidget   *create_filebrowser                 (gpointer         parent);

#ifdef GIMV_DEBUG
void file_disp_loading_status (OpenFiles *files);
#endif /* GIMV_DEBUG */

#endif /* __FILE_H__ */
