/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GTKUTILS_H__
#define __GTKUTILS_H__

#include <gtk/gtk.h>


typedef enum
{
   CONFIRM_ERROR = -1,
   CONFIRM_YES,
   CONFIRM_YES_TO_ALL,
   CONFIRM_NO,
   CONFIRM_CANCEL,
   CONFIRM_ASK
} ConfirmType;



GtkWidget    *create_check_button            (const gchar   *lebel_text,
					      gboolean       def_val,
					      gpointer       func,
					      gpointer       data);


/* confirm dialog window */
ConfirmType   gtkutil_confirm_dialog         (const gchar   *title,
					      const gchar   *message,
					      gboolean       multiple);

/* message dialog window */
void          gtkutil_message_dialog         (const gchar   *title,
					      const gchar   *message);

/* progress bar window */
GtkWidget    *gtkutil_create_progress_window (gchar         *title,
					      gchar         *initial_message,
					      gboolean      *cancel_pressed,
					      gint           width,
					      gint           height);
void          gtkutil_progress_window_update (GtkWidget     *window,
					      gchar         *title,
					      gchar         *message,
					      gchar         *progress_text,
					      gfloat         progress);

/* text entry window */
gchar        *gtkutil_popup_textentry        (const gchar   *title,
					      const gchar   *label_text,
					      const gchar   *entry_text);

/* compare functions */
gint          gtkutil_comp_spel              (gconstpointer  data1,
					      gconstpointer  data2);
gint          gtkutil_comp_casespel          (gconstpointer  data1,
					      gconstpointer  data2);

#endif /* __GTKUTILS_H__ */
