/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __IMAGE_INFO_H__
#define __IMAGE_INFO_H__

#include <sys/stat.h>
#include <unistd.h>

#include "gimageview.h"
#include "gimv_image.h"

struct ImageInfo_Tag
{
   gchar       *filename;
   const gchar *format;
   struct stat  st;
   gint         width;   /* if unknown, value is -1  */
   gint         height;  /* same with above */
   /* ColorSpace   color_space; */

   gboolean     sync_to_orig_image;
   guint        ref_count;
};


ImageInfo *image_info_get                 (const gchar *filename); 
void       image_info_finalize            (ImageInfo   *info);
ImageInfo *image_info_ref                 (ImageInfo   *info);
void       image_info_unref               (ImageInfo   *info);
gboolean   image_info_set_data_from_image (ImageInfo   *info,
					   GimvImage   *image);


#endif /* __IMAGE_INFO_H__ */
