/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __THUMBVIEW_LIST_H__
#define __THUMBVIEW_LIST_H__

#include "gimageview.h"
#include "thumbnail_view.h"

#define LIST_VIEW_LABEL  "List (Icon)"
#define LIST_THUMB_LABEL "List (Thumbnail)"

gboolean   list_view_append_thumb_frames    (ThumbView    *tv,
					     GList        *start,
					     gint          dest_mode);
GtkWidget *listview_add_thumbnail           (Thumbnail    *thumb,
					     gint          dest_mode,
					     ThumbLoadType type);
GtkWidget *listview_redraw                  (ThumbView    *tv,
					     gint          dest_mode,
					     GtkWidget    *scroll_win);
gboolean   listview_refresh_thumbnail       (Thumbnail    *thumb);
GtkWidget *listview_resize                  (ThumbView    *tv);
void       listview_adjust                  (ThumbView    *tv,
					     Thumbnail    *thumb);
GtkWidget *listview_create                  (ThumbView    *tv,
					     gint          dest_mode);
void       listview_remove_thumbview_data   (ThumbView    *tv);
void       listview_remove_thumbnail_data   (Thumbnail    *thumb);
gboolean   listview_set_selection           (Thumbnail    *thumb,
					     gboolean      select);

#endif /* __THUMBVIEW_LIST_H__ */
