#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>
#include <dirent.h>
#include <locale.h>

#include <sys/types.h>
#include <sys/socket.h>

#include "defines.h"

/* we don't *need* gnome =) */
#ifdef HAVE_GNOME
#include <applet-widget.h>
#include "applet.h"
#endif

#include "actions.h"
#include "conf.h"
#include "gui.h"

/*
  Global variables
*/

/* socket used to get info */
int ip_socket;

/* tells the whole program about what's happening */
int state = DISCONNECTED;

/*  the last connection chosed by the user */
char last_choice[FILENAME_MAX];

/* handler for the gtk_timeout that checks for connection */
int check_timeout = 0;

/* handler for time out that waits while the connection is 
   being stabelished */
int connecting_tout = 0;

#ifdef HAVE_GNOME
int is_applet = FALSE;
#endif

/* 
   This variables are used to store configuration and
   to help on writing config file
*/
gchar modem_tty[FILENAME_MAX];
gchar lock_file[FILENAME_MAX];
gchar connect_cmd[FILENAME_MAX];
gchar disconnect_cmd[FILENAME_MAX];

/* version and formated version */
char version[20];
char gk_dial_version [20];

/* defines usage */
void usage(char *cmd);

/* 
   Main function 
*/
int main(int argc, char *argv[]) 
{
  int i;

  /* Gets version, defined by autoconf */
  strncpy (version, VERSION, 20);

  sprintf(gk_dial_version, "GK Dial %s", version);
  /* Gettext stuff */
  setlocale (LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE);
  gtk_set_locale();

  printf(_("Gtk Kov Dialer v. %s\n"
	   "Kov Power Fool's Tools\n"
	   "Starting...\n"), version);
  fflush(stdout);

  gtk_init( &argc, &argv);

  /* open ip socket */
  if ((ip_socket = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
    {
      gk_diag (_("could not open an ip socket"));
      return 1;
    }

  for (i = 1 ; i < argc ; i++)
    {
      if (!strcmp (argv[i], "-h") || !strcmp(argv[i], "--help"))
	{
	  usage(argv[0]); 
	  exit (0);
	}
#ifdef HAVE_GNOME
      else if (!strcmp (argv[i], "-a"))
	{
	  is_applet = TRUE;
	  strcpy (argv[i], "");
	}
#endif
    }

#ifdef HAVE_GNOME
  if (is_applet)
    applet_widget_init (PACKAGE, VERSION, argc, argv, NULL, 0, NULL);
#endif

  create_main_window();

#ifdef HAVE_GNOME
  if (is_applet)
    create_panel_applet();
#endif

  check_config ();


  /* 
     adding timeout... checking for connection 
     displaying log
  */
  check_timeout = gtk_timeout_add (CHK_TIMEOUT, check_connection, NULL);

#ifdef HAVE_GNOME
  if (is_applet)
    applet_widget_gtk_main();
  else
#endif
    gtk_main(); /* Sleep at gtk_main and let the fun begin */

  return 0;
}

void usage(char *cmd)
{
  printf (_("Usage: %s [options]\n\n"
	    "GkDial supports all the standard Gtk options.\n"), cmd);
#ifdef HAVE_GNOME
  printf (_("\n\t-a\t\tturns on gnome applet\n\n"));
#endif
  printf (_("This program is under the GPL, feel free to use, modify and\n"
	    "redistribute it under its terms.\n\n"));
}
