/*
 *
 * Assembly code for hardware handling.
 *
 *
 */

#include "profile.h"

/* Read byte */
__inline__ WORD 
inb(unsigned short port)
{
     BYTE ret;
     __asm__ __volatile__("in%B0 (%1)" :
                          "=a" (ret) :
                          "d" (port));
     return ret;
}

/* Read long */
__inline__ WORD 
inl(unsigned short port)
{
     WORD ret;
     __asm__ __volatile__("in%L0 (%1)" :
                          "=a" (ret) :
                          "d" (port));
     return ret;
}

/* Write byte */
__inline__ WORD 
outb(unsigned short port, BYTE val)
{
     __asm__ __volatile__("out%B0 (%1)" ::"a" (val), "d" (port));
     return 0;
}

/* Write word */
__inline__ WORD 
outw(unsigned short port, unsigned short val)
{
     __asm__ __volatile__("out%W0 (%1)" ::"a" (val), "d" (port));
     return 0;
}

/* Write long */
__inline__ WORD
outl(unsigned short port, WORD val)
{
     __asm__ __volatile__("out%L0 (%1)" : :"a" (val), "d" (port));
     return 0;
}

/* */
long endMGA(long ret)
{
   outb(0xCF8, 0x00);
   return ret;
}

